<?php
/**
 * Upgrades the database from version 1.3.0 to version 1.3.1.
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */

Log::write(Log::LOGLEVEL_INFO, "In updater, from 1.3.1 to 1.3.2");

Log::write(Log::LOGLEVEL_INFO, "Changing note.parentid and file.parentid to allow nulls...");
database::query("ALTER TABLE `note` CHANGE `parentid` `parentid` BIGINT(20) UNSIGNED NULL COMMENT 'If null, note is attached directly to project'; ");
database::query("ALTER TABLE `file` CHANGE `parentid` `parentid` BIGINT(20) UNSIGNED NULL COMMENT 'If null, file is attached directly to project'; ");
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Creating table: beamline");
database::query("CREATE TABLE `beamline` (
`id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(200) COLLATE utf8_bin NOT NULL,
  `projectid` bigint(20) UNSIGNED NOT NULL,
  `shipmentdestinationid` bigint(20) UNSIGNED NOT NULL,
  `detectormanufacturer` varchar(100) COLLATE utf8_bin NOT NULL,
  `detectormodel` varchar(100) COLLATE utf8_bin NOT NULL,
  `detectortype` varchar(100) COLLATE utf8_bin NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name_unique_per_synchrotron` (`shipmentdestinationid`,`name`) USING BTREE,
  KEY `projectid` (`projectid`),
  KEY `shipmentdestinationid` (`shipmentdestinationid`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin; ");
database::query("ALTER TABLE `beamline`
  ADD CONSTRAINT `beamline_ibfk_1` FOREIGN KEY (`id`) REFERENCES `baseobject` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `beamline_ibfk_2` FOREIGN KEY (`projectid`) REFERENCES `project` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `beamline_ibfk_3` FOREIGN KEY (`shipmentdestinationid`) REFERENCES `shipmentdestination` (`id`) ON DELETE CASCADE ON UPDATE CASCADE; ");
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Creating table: dataset");
database::query("CREATE TABLE IF NOT EXISTS `dataset` (
`id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(50) COLLATE utf8_bin NOT NULL,
  `projectid` bigint(20) UNSIGNED NOT NULL,
  `crystalid` bigint(20) UNSIGNED NOT NULL,
  `diffractionrequestid` bigint(20) UNSIGNED DEFAULT NULL,
  `beamlineid` bigint(20) UNSIGNED DEFAULT NULL,
  `pdbdepositionid` bigint(20) UNSIGNED DEFAULT NULL,
  `remotedatasetobject` text COLLATE utf8_bin DEFAULT NULL COMMENT 'Cache of synchrotron JSON or XML description',
  `remotedatasetid` bigint(20) UNSIGNED DEFAULT NULL COMMENT 'ID of this dataset at the synchrotron',
  `datalocation` varchar(250) COLLATE utf8_bin NOT NULL COMMENT 'DOI, URL, or path',
  `description` tinytext COLLATE utf8_bin DEFAULT NULL COMMENT 'Brief description of the dataset',
  `detectormanufacturer` tinytext COLLATE utf8_bin DEFAULT NULL,
  `detectormodel` tinytext COLLATE utf8_bin DEFAULT NULL,
  `detectortype` tinytext COLLATE utf8_bin DEFAULT NULL,
  `detectormode` tinytext COLLATE utf8_bin DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `projectid` (`projectid`),
  KEY `crystalid` (`crystalid`),
  KEY `diffractionrequestid` (`diffractionrequestid`) USING BTREE,
  KEY `pdbdepositionid` (`pdbdepositionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin; ");
database::query("ALTER TABLE `dataset`
  ADD CONSTRAINT `dataset_ibfk_1` FOREIGN KEY (`projectid`) REFERENCES `project` (`id`),
  ADD CONSTRAINT `dataset_ibfk_2` FOREIGN KEY (`crystalid`) REFERENCES `crystal` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `dataset_ibfk_5` FOREIGN KEY (`id`) REFERENCES `baseobject` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `dataset_ibfk_6` FOREIGN KEY (`diffractionrequestid`) REFERENCES `diffractionrequest` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `dataset_ibfk_7` FOREIGN KEY (`pdbdepositionid`) REFERENCES `pdbdeposition`(`id`) ON DELETE SET NULL ON UPDATE CASCADE; ");
Log::write(Log::LOGLEVEL_INFO, "...done");


Log::write(Log::LOGLEVEL_INFO, "Removing unused files:");
$toDelete=array(
//    'upgrade/upgradeDatabase.php' //No longer used.
);
foreach ($toDelete as $path){
    $path=$wwwRoot.ltrim($path,'/');
    Log::write(Log::LOGLEVEL_INFO, "Removing ".$path);
    if(file_exists($path) && !@unlink($path)){
        throw new ServerException('Could not remove '.$path);
    }
}
Log::write(Log::LOGLEVEL_INFO, "...done");

