<?php
/**
 * Upgrades the database from version 1.2.3 to version 1.2.4.
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */

Log::write(Log::LOGLEVEL_INFO, "Removing old files...");
$wwwRoot=rtrim(__DIR__,'/').'/../../';
$toDelete=array(
    'classes/core/note.class.php' //Extended note, so replaced core/note with core/basenote and added model/note
);
foreach ($toDelete as $path){
    $path=$wwwRoot.ltrim($path,'/');
    Log::write(Log::LOGLEVEL_INFO, "Removing ".$path);
    if(file_exists($path) && !@unlink($path)){
        throw new ServerException('Could not remove '.$path);
    }
}
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Fixing historical datedestroyed issue on plate records...");
database::query('UPDATE plate SET datedestroyed=NULL WHERE datedestroyed =0', array());
Log::write(Log::LOGLEVEL_INFO, "...done");
