<?php 
global $icebearSessionStarted;
if(!$icebearSessionStarted){
	startIceBearSession();
}
session::set('isAdmin',true);
$users=user::getAll(array(
		'sortby'=>'fullname',
		'pagenumber'=>1,
		'pagesize'=>10000
));
$users=$users['rows'];
array_shift($users); //don't want the IceBear Administrator

$adminGroup=usergroup::getByName('Administrators');
$admins=usergroup::getmembers($adminGroup['id']);
$admins= (empty($admins)) ? array() : array_column($admins['rows'], 'id');
$superGroup=usergroup::getByName('Supervisors');
$supers=usergroup::getmembers($superGroup['id']);
$supers= (empty($supers)) ? array() : array_column($supers['rows'], 'id');
?>
<p>Here are the users who were imported from RockMaker. You should set their usernames and tell IceBear who should have special permissions. You can safely delete IceBear users from this list without affecting RockMaker.</p>
<p>You can also create new IceBear users here if they do not exist in RockMaker - for example, professors may not be registered in RockMaker but may want to see others' work.</p>
<p><strong><em>You don't need to do any of this now, but it's much easier if you do.</em></strong> IceBear lets you modify individual users' accounts, but this is the best place to set up lots of accounts.</p>
<p>New RockMaker users will be imported into IceBear automatically when they image plates. You'll just need to set their ID and activate their IceBear account.</p>
<p><strong>Username:</strong> IceBear generated unique usernames, but you will want to change them. Later versions of IceBear will support authentication via LDAP/AD. If you intend to use this in future, you should
make sure that people's IceBear usernames match their LDAP IDs.<p>
<p><strong>Administrators</strong> will have full administrator rights in IceBear. They can see and change any record. Grant this power with great caution.</p>
<p><strong>Supervisors</strong> have some additional permissions. By default, they can create projects and usergroups (but you can change this later). In later versions of IceBear, supervisors will be able to see their supervisees' work, regardless of other permissions.</p>
<p>In the next step, you will tell IceBear who supervises whom, so make sure that you identify all the supervisors here.</p>
<p>The <strong>email address</strong> is not shown here; it's used to match RockMaker users to IceBear users. It should not be changed in RockMaker or IceBear!</p>
<?php 
$template='<tr><th>Username</th><th>Full name</th></th><th>Active</th><th>Admin</th><th>Super</th><th>Delete</th></tr>';
$count=0;
echo '<table>';
foreach($users as $u){
	if($count%20==0){
		echo $template;
		$count=0;
	}
	if(in_array($u['name'],array('formulatriximporter','rigakuimporter'))){ continue; }
	if(in_array($u['fullname'],array('IceBear Administrator'))){ continue; }
	$tr=str_replace('th>', 'td>', $template);
	$tr=str_replace('>Username', '><input type="text" style="width:9em" name="user_'.$u['id'].'_name" value="'.$u['name'].'" />', $tr);
	$tr=str_replace('>Full name', '><input type="text" style="width:15em" name="user_'.$u['id'].'_fullname" value="'.$u['fullname'].'" />', $tr);
	$tr=str_replace('>Active', '><input class="isactive" type="checkbox" name="user_'.$u['id'].'_isactive" '.(1==$u['isactive']?'checked="checked"':'').' />', $tr);
	$tr=str_replace('>Admin', '><input class="isadmin" type="checkbox" name="user_'.$u['id'].'_isadmin" '.(in_array($u['id'],$admins)?'checked="checked"':'').' />', $tr);
	$tr=str_replace('>Super', '><input class="issuper" type="checkbox" name="user_'.$u['id'].'_issuper" '.(in_array($u['id'],$supers)?'checked="checked"':'').' />', $tr);
	$tr=str_replace('>Delete', '><input class="isdelete" type="checkbox" name="user_'.$u['id'].'_delete" />', $tr);
	echo $tr;
	$count++;
}
echo '</table>';

echo '<table>';
echo '<tr><th colspan="6">Create new users</th></tr>';
$template='<tr><th>Username</th><th>Full name</th></th><th>Email address</th><th>Active</th><th>Admin</th><th>Super</th></tr>';
echo str_replace('>Delete', '>&nbsp;', $template);
for($i=1;$i<=5;$i++){
	$tr=str_replace('th>', 'td>', $template);
	$tr=str_replace('>Username', '><input type="text" style="width:9em" name="create_'.$i.'_name" value="" />', $tr);
	$tr=str_replace('>Full name', '><input type="text" style="width:15em" name="create_'.$i.'_fullname" value="" />', $tr);
	$tr=str_replace('>Email address', '><input type="text" style="width:15em" name="create_'.$i.'_email" value="" />', $tr);
	$tr=str_replace('>Active', '><input class="isactive" type="checkbox" name="create_'.$i.'_isactive" />', $tr);
	$tr=str_replace('>Admin', '><input class="isadmin" type="checkbox" name="create_'.$i.'_isadmin" />', $tr);
	$tr=str_replace('>Super', '><input class="issuper" type="checkbox" name="create_'.$i.'_issuper" />', $tr);
	echo $tr;
	
}

echo '</table>';


?>
<p>Create any extra users you need, and change the existing ones as needed.</p>
<p id="taint">If you are happy with everything above, click Next to continue. Otherwise, make the changes you need and click the "Create and update users" button that will appear below.</p>

<h3>Passwords</h3>
<p>Other than the default administrator account you created earlier, all these accounts will have the following password: <b><?php echo DEFAULT_PASSWORD; ?></b>

<script type="text/javascript">
var tainted=false;
document.body.onload=function(){
	var cbs=$(document.body).select("input[type=checkbox]");
	cbs.each(function(cb){ 
		cb.observe("click",function(){ highlightRow(cb); });
	});
	var trs=$(document.body).select("tr");
	trs.each(function(tr){
		highlightRow(tr);
	});
	var fields=$(document.body).select("input[type=checkbox],input[type=text]");
	fields.each(function(f){ 
		f.observe("click",function(){ 
			tainted=true;
			var n=$("next");
			if(n){
				n.name="updateusers";
				n.id="updateusers";
				n.value="Create and update users";
				$("taint").innerHTML='Click "Create and update users" to save and review changes. Then click "Next", to configure supervision.';
			}	
		});
	});
}

function highlightRow(tr){
	tr=$(tr);
	if(tr.tagName.toLowerCase()!=="tr"){
		if(tr.up("tr")){
			tr=tr.up("tr");
		} else {
			return false;
		}
	}
	if(!tr.down("input.isactive")){ return false; }
	tr.removeClassName("isactive");
	tr.removeClassName("isadmin");
	tr.removeClassName("issuper");
	tr.removeClassName("isdelete");
	if(tr.down("input.isdelete") && tr.down("input.isdelete").checked){
		tr.addClassName("isdelete");
	} else if(tr.down("input.isadmin").checked){
		tr.addClassName("isadmin");
	} else if(tr.down("input.issuper").checked){
		tr.addClassName("issuper");
	} else if(tr.down("input.isactive").checked){
		tr.addClassName("isactive");
	}
}


</script>