<p>These are the Formulatrix imagers found in the RockMaker database. There are also two microscopes created by IceBear so that you can upload microscope images.</p>
<p><strong>Make sure to set the right temperature</strong> for each imager. In RockMaker, the imager temperature is not known; users are responsible for setting the "Set-up temperature" and "Incubation temperature" for each plate, and this can be incorrect. IceBear sets the temperature for each plate inspection based on the imager where the plate was seen, so the imager temperatures must be correct.</p>
<p>Set "Friendly name" to something short but meaningful, like "+4 imager", and check that the calculated capacity is correct.</p>
<p>For the larger imagers, IceBear can show the plate loading on the homepage. "Alert" and "Critical" are the number of plates that will make this imager show in yellow and red, respectively. By default these are at 75% and 90% of capacity. Note that the small RI1 and RI2 imagers ignore these numbers.</p>
<p>All of this can be changed later.</p>
<?php
global $icebearSessionStarted;
if(!$icebearSessionStarted){
	startIceBearSession();
}
$imagers=imager::getAll();
$template='<tr><th>Serial</th><th>Friendly name</th><th>Temp &deg;C</th><th>Capacity</th><th>Alert</th><th>Critical</th></tr>';
echo '<table>';
echo $template;
foreach($imagers['rows'] as $i){
	$tr=str_replace('th>', 'td>', $template);
	$tr=str_replace('Serial', $i['name'], $tr);
	$tr=str_replace('Friendly name', '<input name="imager_'.$i['id'].'_friendlyname" value="'.$i['friendlyname'].'" />', $tr);
	$tr=str_replace('Temp &deg;C', '<input class="number" name="imager_'.$i['id'].'_temperature" value="'.$i['temperature'].'" />', $tr);
	$tr=str_replace('Capacity', '<input class="number" name="imager_'.$i['id'].'_platecapacity" value="'.$i['platecapacity'].'" />', $tr);
	$tr=str_replace('Alert', '<input class="number" name="imager_'.$i['id'].'_alertlevel" value="'.$i['alertlevel'].'" />', $tr);
	$tr=str_replace('Critical', '<input class="number" name="imager_'.$i['id'].'_warninglevel" value="'.$i['warninglevel'].'" />', $tr);
	echo $tr;
}
echo '</table>';
?>