#!/bin/bash

DBHOST="localhost"
DBNAME="icebear"
DBUSER="icebear"
DBPASS="$( openssl rand -hex 10 )"
WWWROOT='/var/www/html'
CONFIGFILE="$WWWROOT/conf/config.ini"
INSTALLDIR="$WWWROOT/install"

mv $CONFIGFILE $CONFIGFILE.old
echo 'Writing IceBear config file'
echo ";for security:" >> $CONFIGFILE
echo ";<?php exit(); __halt_compiler();" >> $CONFIGFILE
echo "dbType=mysql" >> $CONFIGFILE
echo "dbHost=$DBHOST" >> $CONFIGFILE
echo "dbUser=$DBUSER" >> $CONFIGFILE
echo "dbPass=$DBPASS" >> $CONFIGFILE
echo "dbName=$DBNAME" >> $CONFIGFILE

#mysql --user=root -e \
mysql -e \
"CREATE USER '$DBUSER'@'localhost' IDENTIFIED BY '$DBPASS';"
mysql -e \
"CREATE DATABASE IF NOT EXISTS $DBNAME DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;"
mysql -e \
"GRANT INSERT,DELETE,SELECT,UPDATE,CREATE,DROP,INDEX,ALTER,CREATE TEMPORARY TABLES,CREATE VIEW,TRIGGER,SHOW VIEW,EVENT,CREATE ROUTINE,ALTER ROUTINE,EXECUTE,REFERENCES ON $DBNAME.* TO '$DBUSER'@'$DBHOST';"
mysql -e \
"FLUSH PRIVILEGES;"

echo "Creating IceBear database tables"
mysql --database icebear < $INSTALLDIR/icebeardatabase.sql

echo "Making default storage directory /icebearstore/"
mkdir /icebearstore/
chown www-data /icebearstore/

echo "Making log directory /var/log/icebear/"
mkdir /var/log/icebear/
chown www-data /var/log/icebear/

echo "Setting up temporary cron job for later install tasks"
HERE="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
PHPVERSION="$(php -v | head -n 1 | cut -d " " -f 2 | cut -f1-2 -d"." )"
croncmd="$HERE/rootinstalltasks.sh"
cronjob="* * * * * $croncmd"
( crontab -l | grep -v -F "$croncmd" ; echo "$cronjob" ) | crontab -

echo "Renaming default Apache index file"
mv /var/www/html/index.html /var/www/html/index_old.html

echo "Configuring Apache - enable mod_rewrite"
a2enmod -q rewrite

echo "Configuring Apache - set AllowOverride"
#Enable .htaccess - 
# - read in from /etc/apache2/apache2.conf
# - set first instance of AllowOverride after /var/www/ from None to All
# - write out to /etc/apache2/tmp
# - rename /etc/apache2/tmp to /etc/apache2/apache2.conf
awk 'f==1 && /AllowOverride None/{$0="AllowOverride All";f=0}/Directory \/var\/www/{f=1}1' /etc/apache2/apache2.conf > /etc/apache2/tmp && mv /etc/apache2/tmp /etc/apache2/apache2.conf

echo "Running apt-get update - some PHP modules are not found unless we do this first"
apt-get update

echo "Configuring PHP - installing Sybase module to communicate with Formulatrix SQL Server database"
apt-get --assume-yes install php$PHPVERSION-sybase
echo "Configuring PHP - installing GD module for image manipulation"
apt-get --assume-yes install php$PHPVERSION-gd
echo "Configuring PHP - installing cURL module for remote communication"
apt-get --assume-yes install php$PHPVERSION-curl

echo "Configuring PHP - modifying php.ini files to enable MSSQL secure connection"
echo " " >> /etc/php/$PHPVERSION/apache2/php.ini
echo "#Added by IceBear installer, allows connection to MSSQL without pre-existing DSN" >> /etc/php/$PHPVERSION/apache2/php.ini
echo "mssql.secure_connection = on" >> /etc/php/$PHPVERSION/apache2/php.ini
echo " " >> /etc/php/$PHPVERSION/cli/php.ini
echo "#Added by IceBear installer, allows connection to MSSQL without pre-existing DSN" >> /etc/php/$PHPVERSION/cli/php.ini
echo "mssql.secure_connection = on" >> /etc/php/$PHPVERSION/cli/php.ini

# Set the max post and upload sizes to 8 MB
cp /etc/php/$PHPVERSION/apache2/php.ini /etc/php/$PHPVERSION/apache2/php.ini.bak
sed -i 's,^post_max_size =.*$,post_max_size = 8M,' /etc/php/$PHPVERSION/apache2/php.ini
sed -i 's,^upload_max_filesize =.*$,upload_max_filesize = 8M,' /etc/php/$PHPVERSION/apache2/php.ini
cp /etc/php/$PHPVERSION/cli/php.ini /etc/php/$PHPVERSION/cli/php.ini.bak
sed -i 's,^post_max_size =.*$,post_max_size = 8M,' /etc/php/$PHPVERSION/cli/php.ini
sed -i 's,^upload_max_filesize =.*$,upload_max_filesize = 8M,' /etc/php/$PHPVERSION/cli/php.ini

echo "Restarting Apache to refresh Apache and PHP config"
systemctl restart apache2

echo "Installing cifs-utils package to enable mounting Formulatrix/Windows image stores"
apt-get --assume-yes install cifs-utils

echo "Setting up a firewall"
ufw default deny incoming
ufw default allow outgoing
ufw allow http
ufw allow https
ufw allow ssh
#ufw enable
systemctl enable ufw.service

touch /var/www/html/install/preInstallDone
chown -R www-data /var/www/html

echo " **********************************************************************************"
echo " *                                                                                *"
echo " * IceBear pre-install script complete.                                           *"
echo " *                                                                                *"
echo " * FIREWALL                                                                       *"
echo " *                                                                                *"
echo " * This install script has activated a firewall (ufw) and created some basic      *"
echo " * rules, but YOU are responsible for ensuring the security of this machine! Ask  *"
echo " * your IT department for advice.                                                 *"
echo " *                                                                                *"
echo " * SECURE HTTP (HTTPS)                                                            *"
echo " *                                                                                *"
echo " * Any web server, including this one, should be configured to encrypt traffic    *"
echo " * via secure HTTP (URLs begin with https:// instead of http://). This is NOT     *"
echo " * the default, meaning that usernames, passwords, and scientific data travel     *"
echo " * UNENCRYPTED between server and browser. You really should configure Apache to  *"
echo " * use secure HTTP. You will almost certainly need to get a certificate from your *"
echo " * IT department for this. Ask them for advice.                                   *"
echo " *                                                                                *"
echo " * IMPORTANT: STORAGE AND BACKUP DIRECTORIES                                      *"
echo " *                                                                                *"
echo " * By default, IceBear stores file uploads and imported images at /icebearstore   *"
echo " * and NO BACKUP is configured. If you choose to put the IceBear store in a       *"
echo " * different location, you must create that directory now and ensure that it is   *"
echo " * WRITABLE by the Apache user (probably www-data).                               *"
echo " *                                                                                *"
echo " * Unless you have another backup mechanism in place, you really should have      *"
echo " * IceBear take backups. The backups should AT LEAST be on a different disk, but  *"
echo " * should really be as far from this machine as is practical. As with the storage *"
echo " * directory, you need to mount the backup directory now. The backup directory    *"
echo " * must be READABLE by the Apache user (probably www-data).                       *"
echo " *                                                                                *"
echo " * However you back up IceBear, you should check regularly that backups are being *"
echo " * taken AND that you can restore from them!                                      *"
echo " *                                                                                *"
echo " * You will configure the storage and backup directories later in the install     *"
echo " * process, but the directories MUST EXIST before you continue.                   *"
echo " *                                                                                *"
echo " * DATABASE CREDENTIALS                                                           *"
echo " *                                                                                *"
echo " * No root password is required. The root user can log into the database without  *"
echo " * further authentication. This is the default behaviour in Ubuntu.               *"
echo " *                                                                                *"
echo " * The IceBear database credentials, used by the application, can be found in     *"
echo " * /var/www/html/conf/config.ini                                                  *"
echo " *                                                                                *"
echo " * Continue in your web browser by going to the index page on this server,        *"
echo " * e.g., http://this-machine.myuni.edu                                            *"
echo " *                                                                                *"
echo " **********************************************************************************"

####################
# End of pre-install
####################

#For reference only
#To add it to the crontab, with no duplication:
#( crontab -l | grep -v -F "$croncmd" ; echo "$cronjob" ) | crontab -
#To remove it from the crontab:
#( crontab -l | grep -v -F "$croncmd" ) | crontab -
