var userExtensions={
	
	/**
	 * Insert tabs before (to the left of) the default tabs in the user view page.
	 * This function is called automatically from the base user view page. You just need to add your tabs.
	 */
	tabsBefore:function(tabSet){
		/* Example of a tab. See the tab function in ui.js for more details.
		tabSet.tab({ 
			id:'before', 
			label:'Before', 
			url:'/api/user/'+data['id']+'/thing', 
			successHandler:function(){ $("before").next().innerHTML="Tab before default user tabs"; }
		 });
		*/
		tabSet.tab({ 
			id:'plates', 
			label:'Plates', 
			url:'/api/user/'+data['id']+'/plate', 
			headers:['Barcode','Project'],
			sortOrders:['name','project.name'],
			cellTemplates:['<a href="/plate/{{id}}">{{name}}</a>','<a href="/project/{{projectid}}">{{projectname}}</a>'],
			sortBy:'name',
			sortDescending:true
		 });
	},
	
	/**
	 * Insert tabs after (to the right of) the default tabs in the user view page.
	 * This function is called automatically from the base user view page. You just need to add your tabs.
	 */
	tabsAfter:function(tabSet){
		/* Example of a tab. See the tab function in ui.js for more details.
		tabSet.tab({ 
			id:'before', 
			label:'Before', 
			url:'/api/user/'+data['id']+'/thing', 
			successHandler:function(){ $("before").next().innerHTML="Tab after default user tabs"; }
		 });
		*/
	},
			
	
}