<?php $pageTitle='Create a shipment destination';
include realpath(__DIR__).'/../../core/_common/header.php'; 
$sharedProject=project::getByName(project::SHARED);
$sharedProjectId=$sharedProject['id'];
$shipmentHandlers=shipmentdestination::getHandlerScriptNames();
?>
<script type="text/javascript">

document.observe("dom:loaded",function(){
	var grid=ui.grid();
	var detailsBox=grid.box({ 
		classes:'r1 c1 h3 w1',
		title:'Details'
	});

	var frm=detailsBox.form({
		action:'/api/shipmentdestination/',
		method:'post',
	});
	frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name', value:'' });

	frm.dropdown({ label:"Shipment handler", name:"shipmenthandler", 
		options:[
			<?php 
			     $parts=array();
			     foreach($shipmentHandlers as $h){
			         $parts[]='{ "value":"'.$h.'","label":"'.$h.'" }';
			     } 
			     echo implode(', ', $parts);
			?>
		],
		value:'DefaultShippingHandler'
	});
	frm.textField({ label:"Base URI", name:'baseuri' });
	
	frm.createButton();
	
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php'; ?>
