<?php $pageTitle='Shipment: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; 
$sharedProject=project::getByName(project::SHARED);
$sharedProjectId=$sharedProject['id'];
$canShip=shipment::canCreate();

?>
<script type="text/javascript">
//TODO Read-only if already shipped or non-admin/shipper/technician
let userCanShip=<?php echo $canShip ? 'true' : 'false '; ?>;

let userUpdateProjects=[ <?php echo implode(',', session::getUpdateProjects(false)); ?> ];

Crystal.KEEP="<?php echo diffractionrequest::KEEP_CRYSTAL; ?>";
Crystal.WASH="<?php echo diffractionrequest::WASH_CRYSTAL; ?>";

document.observe("dom:loaded",function(){

	Shipment.getShipmentDestination();

	let grid=ui.grid();

	let ts=grid.tabSet({ id:"shiptabs", classes:'r1 c1 w3 h3' });
	let detailsTab=ts.tab({
		"label":"Shipment",
		"id":"shipmentdetails"
	});

	let frm=detailsTab.form({
		action:'/api/shipment/'+data.id,
		method:'patch',
		id:'shipmentdetails_form',
		readonly:!userCanShip || ""!==data.dateshipped
	});
	let frm2=detailsTab.form({
		action:'#',
		method:'get',
		id:'shipmentactions_form',
		classes:'noprint'
	});


	frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.insert({bottom:'<label><h3>Shipment details</h3></label>'});
	frm.textField({ label:"Name", name:'name', value:data.name });
	frm.roleField({
		label:"Destination", 
		name:'shipmentdestinationid', 
		otherId:data["shipmentdestinationid"],
		otherName:data["shipmentdestinationname"],
		otherType:'shipmentdestination',
		labelField:'name',
		headers:['Name'],
		cellTemplates:['{{name}}']
	});
	frm.roleField({
		label:"Shipper", 
		name:'shipperid', 
		otherId:data["shipperid"],
		otherName:data["shippername"],
		otherType:'user',
		labelField:'name',
		headers:['Name'],
		cellTemplates:['{{name}}']
	});
	if(""!==data.dateshipped){
		if(""!==data.proposalname){
    		frm.textField({ label:"Proposal", name:'proposalname', value:data.proposalname, readOnly:true });
    		frm.textField({ label:"Session", name:'sessionname', value:data.sessionname, readOnly:true });
		}
		frm.dateField({ label:"Date shipped", name:'dateshipped', value:data.dateshipped });
	}
	if(""!==data.datereturned){
		frm.dateField({ label:"Date returned", name:'datereturned', value:data.datereturned });
	}

	if(userCanShip && ""===data.dateshipped){
    	frm2.insert({bottom:'<label id="dewaraddlabel"><h3>Add a dewar</h3></label>'});
    	frm2.textField({ label:"Scan a barcode", name:'addtoplevelbybarcode', placeholder:"Barcode" });
    	frm2.insert({bottom:'<br/><br/><br/><label><h3>Send this shipment</h3></label>'});
    	frm2.buttonField({ label:"Send shipment...", onclick:Shipment.send });
    	frm2.onsubmit=function(){ Shipment.addDewarByBarcode(); return false; };
	} else if(""!==data.dateshipped){
		//Need shipmentdestination AND handler
		//Then handler.
		//Then write link to DLS - opens in new window / tab
		window.setTimeout(renderActionLinks	,100);
	}

	if(""!==data["manifest"] && data["manifest"].rows){
		data["manifest"].rows.each(function(row){
			Shipment.renderDewar(row);
		});
		ts.filesTab();
	} else {
		Shipment.getAndRenderContainers();
	}	

	if(""!==data.dateshipped){
		if(""===data.datereturned){
    		//Shipped but not returned
    		Shipment.DataCollection.renderTab();
		} else if(userCanShip){
			//Shipped and returned
			Shipment.DewarReturn.renderTab();
		}
	}
	
	//TODO accept plates
	
	
});

function renderActionLinks(){
	if(!window.shipmentDestination || ""===window.shipmentDestination["shipmenthandler"] || !window[shipmentDestination["shipmenthandler"]]){
		return window.setTimeout(renderActionLinks,250);
	}
	if(""!==data.urlatremotefacility){
		let ff=$("shipmentactions_form").formField({
			id:"remotelinklabel", 
			label:"&nbsp;", 
			content:'<a target="_blank" href="'+data.urlatremotefacility+'">Open shipment in new tab</a>' 
		});
		ff.insert({top:'<h3>Your shipment at '+window.shipmentDestination.name+'</h3><hr/>'});
	}
	new Ajax.Request('/api/shipment/'+data.id+'/file',{
		method:'get',
		onSuccess:function(transport){
			let files=transport.responseJSON.rows;
			files.each(function(file){
				if(file.filename==='shipment'+data.id+'manifest.pdf'){
					var ff2=$("shipmentactions_form").formField({ 
						label:"&nbsp;", 
						content:'<a target="_blank" href="/api/file/'+file.id+'/'+file.filename+'">Open PDF in new tab</a>' 
					});
					ff2.insert({top:'<h3>Printable shipment manifest</h3><hr/>'});
				}
			});
			renderReturnLink();
            renderGetDatasetButton();
		},
		onFailure:function(){
			//meh
			renderReturnLink();
            renderGetDatasetButton();
        },
	});
}

function renderReturnLink(){
    if(userCanShip && ""===data.datereturned){
        let ff=$("shipmentactions_form").buttonField({ label:"Return shipment", onclick:Shipment.markReturned });
        ff.insert({top:'<h3>Shipment return</h3><hr/>'});
    }
}

function renderGetDatasetButton(){
    if(Shipment.hasDatasetRetrieval() && userCanShip && ""!==data.dateshipped){
        let ff=$("shipmentactions_form").buttonField({ label:"Retrieve dataset metadata", onclick:Shipment.getCollectedDatasets });
        ff.insert({top:'<h3>Dataset metadata</h3><hr/>'});
    }
}

</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';