<?php $pageTitle='Create a shipment';
include realpath(__DIR__).'/../../core/_common/header.php'; 
$sharedProject=project::getByName(project::SHARED);
$sharedProjectId=$sharedProject['id'];
$canCreateShipments=session::isAdmin() || usergroup::userisingroup(usergroup::SHIPPERS);
?>
<script type="text/javascript">

document.observe("dom:loaded",function(){
	var grid=ui.grid();
	var detailsBox=grid.box({ 
		classes:'r1 c1 h3 w1',
		title:'Details'
	});
	var frm=detailsBox.form({
		action:'/api/shipment/',
		method:'post',
	});
	frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
    <?php if(isset($_GET['dewars'])){ ?>
    frm.hiddenField('dewarbarcodes',"<?php echo isset($_GET['dewars']) ? $_GET['dewars'] :''; ?>");
    frm.formField ({
            'label':'Dewars',
            'content':'<?php echo implode('<br/>', explode(',', $_GET['dewars'])); ?>'
        },
        "");
    <?php } else { ?>
    frm.hiddenField('dewarbarcodes',"");
    <?php } ?>
	frm.textField({ label:"Shipment name", name:'name', value:'' });
	frm.roleField({ 
		label:"Destination", 
		name:'shipmentdestinationid', 
		otherType:'shipmentdestination',
		labelField:'name',
		headers:['Name'],
		cellTemplates:['{{name}}']
	});
	frm.createButton();

    var infoBox=grid.box({
        classes:'r1 c2 h3 w2',
        title:'Automated shipment submission',
        content:'<p>IceBear currently supports automated shipment data submission to MAX-IV and Diamond Light Source.</p>'+
                '<p>For other synchrotrons, you will need to submit the shipment data manually using the '+
                'synchrotron\'s own systems. You can still use IceBear to record data collection notes and '+
                'manage the unpacking of returned dewars.</p>'
    });


});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php'; ?>
