let projectExtensions={
	
	/**
	 * Insert tabs before (to the left of) the default tabs in the project view page.
	 * This function is called automatically from the base project view page. You just need to add your tabs.
	 */
	tabsBefore:function(tabSet){
		/* Example of a tab. See the tab function in ui.js for more details.
		tabSet.tab({ 
			id:'before', 
			label:'Before', 
			url:'/api/project/'+data['id']+'/permission', 
			successHandler:function(){ $("before").next().innerHTML="Tab before default project tabs"; }
		 });
		*/
		tabSet.tab({ 
			id:'plates', 
			label:'Plates', 
			url:'/api/project/'+data['id']+'/plate?sortby=id&sortdescending=yes', 
			headers:['Barcode','Owner','Description','Best score'],
			sortOrders:['name','user.fullname','','crystalscore.scoreindex'],
			cellTemplates:['<a href="/plate/{{id}}">{{name}}</a>','<a href="/user/{{ownerid}}">{{ownername}}</a>',[projectExtensions.trimDescription,'description'],[Plate.renderPlateBestScoreCell,'bestscorelabel'] ]
		});
		tabSet.tab({ 
			id:'proteins', 
			label:'Proteins', 
			url:'/api/project/'+data['id']+'/protein', 
			successHandler:function(transport){ projectExtensions.writeProteins(transport.responseJSON.rows);  },
			failureHandler:function(){ $("proteins_body").innerHTML=""; projectExtensions.writeProteinCreateForm();  }
		});
		tabSet.tab({ 
			id:'crystals', 
			label:'Crystals', 
			url:'/api/crystal/projectid/'+data['id']+'?sortby=id&sortdescending=yes', 
			headers:['Image','Plate','Drop and number'],
			cellTemplates:[ [Crystal.getThumbnailLink,'id'], '<a href="/plate/{{plateid}}">{{platename}}</a>',  [Crystal.getTextLink,'id'] ],
		});
		Dataset.listTab(tabSet, 'projectid', data['id']);
	},
	
	/**
	 * Insert tabs after (to the right of) the default tabs in the project view page.
	 * This function is called automatically from the base project view page. You just need to add your tabs.
	 */
	tabsAfter:function(tabSet){
		/* Example of a tab. See the tab function in ui.js for more details.
		tabSet.tab({ 
			id:'after', 
			label:'After', 
			url:'/api/project/'+data['id']+'/permission', 
			successHandler:function(){ $("after").next().innerHTML="Tab after default project tabs"; }
		 });
		*/
	},
	
	trimDescription:function(item){
		let maxLength=50;
		let desc=item.description;
		if(desc.length<=maxLength){ return desc; }
		desc=desc.substr(0,maxLength-3);
		let lastSpace=desc.lastIndexOf(" ");
		if(0<lastSpace){
			desc=desc.substr(0,lastSpace);
		}
		return desc+'...';
	},

	
	writeProteins:function(rows, proteinIdToOpen, constructIdToOpen){
		let tab=$("proteins_body");
		tab.innerHTML='';
		rows.each(function(r){
			tab.treeItem({
				record:r,
				id:"protein"+r.id,
				header:r.name+" (Acronym: "+r.proteinacronym+")",
				updater:projectExtensions.renderProtein
			});
			if(1*r.id===1*proteinIdToOpen){
				ui.doToggleTreeItem($('protein'+r.id));
			}
		});
		projectExtensions.writeProteinCreateForm();
	},
	renderProtein:function(treeHeader,constructIdToOpen){
		let ti=treeHeader.up(".treeitem");
		let tb=ti.down(".treebody");
		tb.innerHTML='';
		let protein=ti.record;
		let f=ti.form({
			action:"/api/protein/"+protein['id'],
			method:"patch"
		});
		f.hiddenField('projectid',data['id']);
		if(canEdit){
			let nameField=f.textField({
				label:'Name',
				name:'name',
				value:protein['name'],
				helpText:'Protein name must be unique within this project',
			});
			let acronymField=f.textField({
				label:'Protein acronym (safety identifier)',
				name:'proteinacronym',
				value:protein['proteinacronym'],
				helpText:'Short code, 3-5 characters. Identifies the protein for synchrotron safety purposes'
			});
			nameField.observe("keyup",function(){
				ti.down("h3").innerHTML='<span class="toggleitem"></span>'+nameField.down("input").value+' (Acronym: '+acronymField.down("input").value+')';
			});
			acronymField.observe("keyup",function(){
				ti.down("h3").innerHTML='<span class="toggleitem"></span>'+nameField.down("input").value+' (Acronym: '+acronymField.down("input").value+')';
			});

		}
		f.textField({
			readonly:!canEdit,
			label:'Description',
			name:'description',
			value:protein['description'],
			helpText:'A short description of the protein',
			readOnly:!canEdit
		});
		
		new Ajax.Request('/api/protein/'+protein['id']+'/construct',{
			method:"get",
			onSuccess:function(transport){ projectExtensions.writeConstructs(transport,constructIdToOpen); },
			onFailure:function(){ projectExtensions.writeConstructCreateForm(tb); },
		});
	},
	writeProteinCreateForm:function(){
		let tab=$("proteins_body");
		if(canEdit){
			let createItem=tab.treeItem({
				header:'Create a new protein'
			});
			let f=createItem.form({
				action:"/api/protein",
				method:"post"
			});
			f.hiddenField('projectid',data['id']);
			f.textField({
				label:'Name',
				name:'name',
				helpText:'Protein name must be unique within this project'
			});
			f.textField({
				label:'Protein acronym (safety identifier)',
				name:'proteinacronym',
				helpText:'Short code, 3-5 characters. Identifies the protein for synchrotron safety purposes'
			});
			f.textField({
				label:'Description',
				name:'description',
				helpText:'A short description of the protein'
			});
			f.createButton({
				afterSuccess:function(createResponse){
					new Ajax.Request('/api/project/'+data.id+'/protein',{
						method:'get',
						onSuccess:function(transport){
							projectExtensions.writeProteins(transport.responseJSON.rows, createResponse.created.id);
						}
					})
				}
			});
			f.formField({
				label:'<img alt="" style="vertical-align: bottom" src="/images/icons/darkicons/warning.png"> Please note!',
				name:'',
				content:'<div style="width:80%;float:right;text-align:left;line-height:1.5em">The protein acronym is used when shipping your crystals to the synchrotron, to identify the ' +
					'protein for safety purposes. It should be <b>very short</b> (ideally 3-5 characters), contain <b>no ' +
					'spaces</b> or special characters, and <b>must match exactly</b> the protein acronym in the ' +
					'synchrotron\'s safety system at time of shipping. Mismatched acronyms will prevent your crystals from being shipped.</div>'
			});
			f.up(".treeitem").addClassName("noprint");
		}
	},
	
	
	writeConstructs:function(transport,constructIdToOpen){
		let wrapper;
		transport.responseJSON.rows.each(function(r){
			wrapper=$("protein"+r['proteinid']+"_body");
			wrapper.treeItem({
				record:r,
				id:"construct"+r.id,
				header:"Construct: "+r.name,
				updater:projectExtensions.renderConstruct
			});
			if(1*r.id===1*constructIdToOpen){
				ui.doToggleTreeItem($("construct"+r.id));
			}
		});
		projectExtensions.writeConstructCreateForm(wrapper);
	},
	renderConstruct:function(treeHeader){
		let ti=treeHeader.up(".treeitem");
		let tb=ti.down(".treebody");
		tb.innerHTML='';
		let con=ti.record;
		let f=ti.form({
			action:"/api/construct/"+con['id'],
			method:"patch"
		});
		f.hiddenField('constructid',con['id']);
		if(canEdit){
			let nameField=f.textField({
				label:'Name',
				name:'name',
				value:con['name'],
				helpText:'Construct name must be unique within this protein',
			});
			nameField.observe("keyup",function(){
				ti.down("h3").innerHTML='<span class="toggleitem"></span>Construct: '+nameField.down("input").value;
			});
		}
		f.textField({
			readonly:!canEdit,
			label:'Description',
			name:'description',
			value:con['description'],
			helpText:'A short description of the construct'
		});
		projectExtensions.getSequences(con.id);
	},
	writeConstructCreateForm:function(wrapper){
		if(canEdit){
			let createitem=wrapper.treeItem({
				header:'Create a new construct'
			});
			f=createitem.form({
				action:"/api/construct",
				method:"post"
			});
			let prot=wrapper.up(".treeitem").record;
			f.hiddenField('projectid',data['id']); 
			f.hiddenField('proteinid',prot['id']); 
			f.textField({
				label:'Name',
				name:'name',
				helpText:'Construct name must be unique within this protein'
			});
			f.textField({
				label:'Description',
				name:'description',
				helpText:'A short description of the construct'
			});
			f.createButton({
				afterSuccess:function(createResponse){
					new Ajax.Request('/api/project/'+data.id+'/protein',{
						method:'get',
						onSuccess:function(transport){
							projectExtensions.writeProteins(transport.responseJSON.rows, prot['id'], createResponse.created.id);
						}
					})
				}
			});
		}
	},
	
	getSequences:function(constructId){
		new Ajax.Request('/api/construct/'+constructId+'/sequence',{
			method:'get',
			onSuccess:function(transport){ projectExtensions.getSequences_onSuccess(transport, constructId); },
			onFailure:function(transport){ projectExtensions.getSequences_onFailure(transport, constructId); },
		});
	},
	getSequences_onSuccess:function(transport, constructId){
		if(!AjaxUtils.checkResponse(transport)){ return false; }
		projectExtensions.renderSequences(transport.responseJSON.rows,constructId);
	},
	getSequences_onFailure:function(transport, constructId){
		if(404===1*transport.status){
			projectExtensions.renderSequences([],constructId);
		} else {
			return AjaxUtils.checkResponse(transport);
		}
	},
	renderSequences:function(sequences, constructId){
		sequences.each(function(seq){
			let f=projectExtensions.generateSequenceBlock(seq);
			$("construct"+seq.constructid+"_body").appendChild(f);
		});
		if(canEdit){
			let f=$("construct"+constructId+"_body").form({
				action:'/api/sequence/',
				method:'post',
				id:"construct"+constructId+"addseqform"
			});
			let ff=f.formField({
				label:'<input type="button" onclick="projectExtensions.showSequenceWindow(this)" id="construct'+constructId+'addseqbutton" value="Add sequence..." />',
				name:'',
				value:''
			});
			ff.innerHTML+='&nbsp;';
			ff.sequence={};
			ff.down("input").dataset.constructid=constructId;
		}
	},

	generateSequenceBlock:function(seq){
		let f=ui.form({
			action:'/api/sequence/'+seq.id,
			method:'patch',
			id:'seq'+seq.id
		});
		let seqToShow=projectExtensions.generateSequencePreviewString(seq);
		let ff=f.formField({
			label:'Sequence: '+seq.name,
			name:'seq'+seq.id,
			value:seq.name
		});
		ff.sequence=seq;
		let viewButton='<input type="button" onclick="projectExtensions.showSequenceWindow(this)" value="View..." /> ';
		let deleteButton="";
		if(canEdit){
			viewButton=viewButton.replace("View","View/Edit");
			deleteButton='<input type="button" onclick="projectExtensions.deleteSequence(this)" value="Delete" />';
		}
		ff.innerHTML+=('<span class="seqpreview">'+seqToShow+"</span><br/>"+viewButton+deleteButton);
		ff.down("input").dataset.constructid=seq.constructid;
		return f;
	},
	
	sequencePreviewLength:36,

	generateSequencePreviewString:function(seq){
		let seqToShow=seq.dnasequence;
		if(""!==seq.proteinsequence){ seqToShow=seq.proteinsequence; }
		if(""===seqToShow){ return "(no DNA or protein sequence)"; }
		if(seqToShow.length>projectExtensions.sequencePreviewLength){
			return seqToShow.substr(0,projectExtensions.sequencePreviewLength).toUpperCase()+"...";
		}
		return seqToShow.toUpperCase();
	},
	
	showSequenceWindow:function(btn){
		let seq=btn.up("label").sequence;
		let seqName=seq.name||"";
		let dnaSeq=seq.dnasequence||"";
		let proteinSequence=seq.proteinsequence||"";
		let formAction=seq.id ? '/api/sequence/'+seq.id : '/api/sequence/';
		let formMethod=seq.id ? 'patch' : 'post';
		let formClasses=seq.id ? '' : 'create';
		let boxTitle=seq.name ? 'Sequence: '+seq.name : 'Add a sequence';
		let buttonLabel=seq.id ? 'Save changes' : 'Add sequence';
		let buttonAction=projectExtensions.submitSequenceForm;
		let mb=ui.modalBox({ title:boxTitle, content:'', confirmClose:true });
		let f=modalBox.form({
			id:'sequenceform',
			action:formAction,
			method:formMethod,
		});
		f.hiddenField("seqconstructid",btn.dataset.constructid);
		f.textField({
			label:'Name',
			name:'seqname',
			helpText:'Sequence name must be unique for this construct',
			value:seqName,
			readonly:!canEdit
		});
		if(canEdit || (!canEdit && ""!==dnaSeq)){
			f.textArea({
				label:'DNA sequence, if known',
				name:'dnasequence',
				helpText:'The DNA sequence',
				value:dnaSeq,
				readonly:!canEdit
			});
		}
		if(canEdit || (!canEdit && ""!==proteinSequence)){
			f.textArea({
				label:'Protein sequence',
				name:'proteinsequence',
				helpText:'The protein sequence',
				value:proteinSequence,
				readonly:!canEdit
			});
		}
		if(canEdit){
			f.buttonField({
				id:"seqsubmit",
				label:buttonLabel,
				onclick:buttonAction
			});
			fieldValidations['seqname']="required";
			fieldValidations['dnasequence']="dnaSequence";
			fieldValidations['proteinsequence']="proteinSequence";
			$$("#modalBox textarea, #modalBox input[type=text]").each(function(elem){ 
				elem.onkeyup=function(){ $("modalBox").tainted=true; }; 
				elem.style.width="70%"; 
			});
			$$("#modalBox textarea").each(function(elem){ 
				elem.style.height="10em"; 
				elem.onclick=function(){ $("modalBox").tainted=true; }; 
			});
			let psBox=$("proteinsequence");
			let dsBox=$("dnasequence");
			psBox.observe("keyup",projectExtensions.onEditProteinSequence);
			psBox.observe("click",projectExtensions.onEditProteinSequence);
			dsBox.observe("keyup",projectExtensions.onEditDnaSequence);
			dsBox.observe("click",projectExtensions.onEditDnaSequence);
		}
	},

	onEditProteinSequence:function(){
		let psBox=$("proteinsequence");
		let seq=psBox.value+"";
		seq=seq.replace(/[^\*ACDEFGHIKLMNPQRSTVWY]/gi, "").toUpperCase();
		if(""===seq){ return; }
		psBox.value=Protein.formatProteinSequence(seq);
	},
		
	onEditDnaSequence:function(){
		let dsBox=$("dnasequence");
		let seq=dsBox.value+"";
		seq=seq.replace(/[^\*ACGT]/gi, "").toUpperCase();
		if(""===seq){ return; }
		dsBox.value=Protein.formatDnaSequence(seq);
	},

	dnaMatchesProtein:function(){
		let dnaSequence=$("dnasequence").value.replace(/\s/g,"");
		let proteinSequence=$("proteinsequence").value.replace(/\s/g,"");
		if(""===proteinSequence || ""===dnaSequence){ return true; }
		if(proteinSequence.length*3 !== dnaSequence.length){ return false; }
		let convertedDna=Protein.dnaToProtein(dnaSequence);
		return convertedDna === proteinSequence;
	},
	
	submitSequenceForm:function(){
		let sequenceForm=$('sequenceform');
		let proteinSequenceBox=$('proteinsequence');
		let dnaSequenceBox=$('dnasequence');
		let isValid=validator.validate($('seqname'));
		isValid=validator.validate(proteinSequenceBox) && isValid;
		isValid=validator.validate(dnaSequenceBox) && isValid;
		if(!isValid){ return false;	}
		if(!projectExtensions.dnaMatchesProtein()){
			if(!confirm("DNA and protein sequences do not match.\n\nClick OK to generate the protein sequence from the DNA sequence.\nClick Cancel to edit by hand.")){
				return false;
			}
			$("proteinsequence").value=Protein.dnaToProtein($("dnasequence").value);
		} else if(""===proteinSequenceBox.value && ""!==dnaSequenceBox.value){
			if(confirm("The protein sequence is empty.\n\nClick OK to generate the protein sequence from the DNA sequence.\nClick Cancel to leave it empty.")){
				$("proteinsequence").value=Protein.formatProteinSequence(Protein.dnaToProtein($("dnasequence").value));
			}
		}
		$("seqsubmit").up("label").addClassName("updating");
		let method="post";
		if("post"!==sequenceForm.dataset.ajaxmethod){ method="patch"; }
		new Ajax.Request(sequenceForm.action,{
			method:method,
			parameters:{
				csrfToken:csrfToken,
				name:$("seqname").value,
				dnasequence:dnaSequenceBox.value,
				proteinsequence:proteinSequenceBox.value,
				constructid:$("seqconstructid").value,
			},
			onSuccess:projectExtensions.submitSequenceForm_onSuccess,
			onFailure:projectExtensions.submitSequenceForm_onFailure,
		})
		
	},
	submitSequenceForm_onSuccess:function(transport){
		$("seqsubmit").up("label").removeClassName("updating");
		if(!AjaxUtils.checkResponse(transport)){ return false; }
		let updated=transport.responseJSON.updated;
		let created=transport.responseJSON.created;
		if(updated){
			let seqBox=$("seq"+updated.id);
			seqBox.down(".label").innerHTML="Sequence: "+updated.name;
			seqBox.down(".seqpreview").innerHTML=projectExtensions.generateSequencePreviewString(updated);
			seqBox.down("label").sequence=updated;
		} else if(created){
			let f=projectExtensions.generateSequenceBlock(created);
			$("construct"+created.constructid+"addseqform").insert({before:f});	
		}
		$("modalBox").tainted=false;
		ui.closeModalBox();
	},
	submitSequenceForm_onFailure:function(transport){
		$("seqsubmit").up("label").removeClassName("updating");
		AjaxUtils.checkResponse(transport);
	},

	deleteSequence:function(elem){
		if(!canEdit){ 
			alert("You don't have permission to delete sequences");
			return false;
		}
		let frm=$(elem).up("form");
		elem.up("label").addClassName("updating");
		window.setTimeout(function(){
			new Ajax.Request(frm.action, {
				method:'delete',
				parameters:{ csrfToken:csrfToken },
				onSuccess:projectExtensions.deleteSequence_onSuccess,
				onFailure:projectExtensions.deleteSequence_onFailure
			});
		},250); //give the "updating" time to show - deletion is very quick, may be jarring
	},
	deleteSequence_onSuccess:function(transport){
		if(!AjaxUtils.checkResponse(transport)){ return false; }
		let deletedId=transport.responseJSON['deleted'];
		$("seq"+deletedId).remove();
	},
	deleteSequence_onFailure:function(transport){
		$("seqsubmit").up("label").removeClassName("updating");
		AjaxUtils.checkResponse(transport);
		
	},
	
};