<?php $pageTitle='Plate type: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; 
$sharedProject=project::getByName(project::SHARED);
$sharedProjectId=$sharedProject['id'];
?>
<script type="text/javascript">

document.observe("dom:loaded",function(){
	var grid=ui.grid();
	var detailsBox=grid.box({ 
		classes:'r1 c1 h3 w1',
		title:'Details'
	});

	var frm=detailsBox.form({
		action:'/api/platetype/'+data['id'],
		method:'post',
	});
	frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name' });
	frm.textField({ label:"Number of rows", name:'rows' });
	frm.textField({ label:"Number of columns", name:'cols' });
	frm.textField({ label:"Drops per well", name:'subs' });
	frm.textField({ label:"Drop mapping", name:'dropmapping' });

	var ts=grid.tabSet({ classes:'r1 c2 w2 h3' });
	ts.tab({
		'label':'Plates',
		'url':'/api/plate/platetypeid/'+data.id+'',
		'sortBy':'name',
		'sortDescending':true,
		'headers':['Plate','Project'],
		'sortOrders':['name','project.name'],
		'cellTemplates':['<a href="/plate/{{id}}">{{name}}</a>','<a href="/project/{{projectid}}">{{projectname}}</a>']
	});
	ts.filesTab();
	ts.notesTab();
		
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php'; ?>
