<?php
/** @var array $data */
$pageTitle='Plate: '.$data['name'];
$breadcrumbs=array(
		array('url'=>'/project/'.$data['projectid'], 'icon'=>'project', 'help'=>'Go to this plate\'s project')
);
$qItem=platereimportqueue::getByPlateId($data['id']);
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
canEdit=<?php echo plate::canUpdate($data['id'])?'true':'false'; ?>;
if(!canEdit && 1*data["ownerid"]===1*userId){ canEdit=true; }
let isDestroyed=(""!==data.datedestroyed);
let canCreateInspections=canEdit && !isDestroyed && <?php echo (1==config::get('imaging_allowmanual')) ? 'true' : 'false'; ?>;
let canReimport=<?php echo (1==config::get('reimport_enabled') && (session::isAdmin() || session::getUserId()==$data['ownerid'])) ? 'true' : 'false'; ?>;
let queueItem= <?php echo json_encode($qItem); ?>;
let isQueuedForReimport=<?php echo ($qItem? 'true;' : 'false;'); ?>;

document.observe("dom:loaded",function(){

	Plate.getManualImagers();
	Plate.getPlateType();
	Plate.getWellDrops();
	Plate.getConstructs();
	
	ui.grid();

	let details=grid.box({
		classes:'r1 c1 h2 w1',
		title:'Details'
	});
	let df=details.form({
		action:'/api/plate/'+data.id,
		method:'patch'
	});
	df.textField({
		label:'Barcode',
		value:data.name,
		readonly:true
	});
	df.textField({
		label:'Description',
		name:'description',
		value:data.description,
		readonly:!canEdit
	});
	df.formField({ label:"Plate type"}).innerHTML+='<a href="/platetype/'+data["platetypeid"]+'">'+data["platetypename"]+'</a>';
	df.formField({ label:"Project", id:'project' }).innerHTML+='<a href="/project/'+data.projectid+'">'+data["projectname"]+'</a>';
	df.roleField({
		readonly:!isAdmin,
		label:"Owner", 
		name:'ownerid', 
		otherId:data["ownerid"],
		otherName:data["ownername"],
		otherType:'user',
		labelField:'fullname',
		headers:['Name'],
		cellTemplates:['{{fullname}}']
	});

	//TODO better handling of long text
    if(df.down("#description")){
        df.down("#description").style.width="70%";
    }

	if(data["locationid"]){
		/*
		df.textField({
			label:'Location',
			id:'locationid',
			value:'Getting location...',
			readonly:true
		});
		//firstly request the location's baseobject so we know what type it is...
		new Ajax.Request('/api/baseobject/'+data.locationid, {
			method:'get',
			onSuccess:function(transport){
				var loc=transport.responseJSON;
				//...then request the actual object
				var locType=loc.objecttype;
				new Ajax.Request('/api/'+locType+'/'+loc.id,{
					method:'get',
					onSuccess:function(transport){
						var loc=transport.responseJSON;
						var locId=loc.id;
						var locName=loc.name;
						if(loc.friendlyname){ locName=loc.friendlyname; }
						var locLink='<a href="/'+locType+'/'+locId+'">'+locName+'</a>';
						$("locationid_label").innerHTML=$("locationid_label").innerHTML.replace("Getting location...",locLink);
					},
					onFailure:function(transport){
						$("locationid_label").remove();
					},
				});
			},
			onFailure:function(transport){
				$("locationid_label").remove();
			},
		});
		*/
	}

    let ts = grid.tabSet({
        classes: 'r1 c2 h3 w2'
    });

    let contentBefore = null;
    let sortOrders = ['-imageddatetime', '', ''];
    let headers = ['Inspection', 'Temperature', 'Imager'];
    let cellTemplates = [
        [Plate.writeInspectionLink, 'imageddatetime'],
        '{{temperature}}C',
        '<a href="/imager/{{imagerid}}" title="{{imagername}}">{{imagerfriendlyname}}</a>'
    ];

    let newInspectionButton='<input type="button" style="float:none" value="Create new manual inspection for this plate..." onclick="Plate.beginCreateInspection()" />';

	if(canCreateInspections){
		contentBefore=newInspectionButton;
		headers.push(' ');
		sortOrders.push('');
		cellTemplates.push([
			function(obj,field){ 
				if(1===1*obj[field]){
					return '<input type="button" value="Edit..." onclick="Plate.beginEditInspection(this)" />';
				}
				return ''; 
			},
			'manualimaging'
		]);
	}
	
	ts.tab({
		id:'inspections',
		label:'Inspections',
		url:'/api/plate/'+data['id']+'/imagingsession',
		headers:headers,
		cellTemplates:cellTemplates,
		sortOrders:sortOrders,
		sortBy:"imageddatetime",
		sortDescending:true,
		contentBefore:contentBefore,
		failureHandler:function(){
			let content='No inspections on this plate';
			if(canCreateInspections){
				content+='<br/><br/>'+newInspectionButton;
			}
			$("inspections_body").innerHTML=content;
		}
	});
	
	ts.tab({
		id:'crystals',
		label:'Crystals',
		url:'/api/plate/'+data['id']+'/crystal',
		headers:['Image','Drop and number'],
		cellTemplates:[ [Crystal.getThumbnailLink,'id'], [Crystal.getTextLink,'id'] ],
	});
	insertFishLink();	

	ts.tab({
		id:'proteins',
		label:'Protein',
		renderer:Plate.renderProteinTab,
	});

	ts.tab({
		id:'screens',
		label:'Screen',
		renderer:Plate.renderScreenTab,
	});

    let dc = ts.tab({
        id: 'drops',
        label: 'Drop conditions',
        renderer: Plate.renderDropConditionsTab,
    });
    dc.onclick=Plate.renderDropConditionsTab; //Force render onclick because width doesn't take.

    ts.filesTab(data.screenid);
    ts.notesTab();


    let actions = grid.box({
        classes: 'r3 c1 h1 w1',
        title: 'Actions'
    });
    let af=actions.form({
		action:'/api/plate/'+data.id,
		method:'get'
	});

    let destroyedField;
    if(isDestroyed){
		destroyedField=af.formField({ label:"Plate has been destroyed"});
		if(canEdit){
			destroyedField.innerHTML+='<input type="button" value="Undo" onclick="updateDestroyed(this)" />';
		}
	} else if(canEdit){
		destroyedField=af.formField({ label:"Mark plate as destroyed:" });
		destroyedField.innerHTML+='<input type="button" value="Destroy plate" onclick="updateDestroyed(this)" />';
	}

	if(!isDestroyed && canReimport){
		let reimportField;
		if(isQueuedForReimport){
			reimportField=af.formField({ label:"Plate is queued for re-import" });
			reimportField.innerHTML+='<input type="button" id="reimport" value="Cancel" onclick="cancelReimport()" />';
		} else {
			reimportField=af.formField({ label:"Queue plate for re-import:" });
			reimportField.innerHTML+='<input type="button" id="reimport" value="Queue" onclick="queueForReimport()" />';
		}
	}

	
});

function insertFishLink(){
    if(!canEdit){ return false; } //can't update the plate, so can't fish crystals from it
	if(isDestroyed){ return false; }
	if(!data["projectname"] || 'Default Project'===data["projectname"]){ return false; }
	let t=document.getElementById("crystals_body");
	if("Loading..."===t.innerHTML){
		window.setTimeout(insertFishLink,250);
		return false;
	}
	if("None found"===t.innerHTML){ t.innerHTML=""; }
	t.innerHTML='<a class="nosmall" href="/containercontent/create?barcodes='+data.name+'">Fish crystals from this plate...</a>'+t.innerHTML;
}

//TODO move to client.js::Plate, accept plate ID and date. If no date supplied (NOT empty), undestroy
function updateDestroyed(btn){
//  	var isDestroyed=(""!=data.datedestroyed);
//  	alert(isDestroyed+" "+!isDestroyed);
	if(!Plate.setIsDestroyed(data.id, !isDestroyed)){
		return false;
	}
	btn.up("label").addClassName("updating");
}

function cancelReimport(){
	$("reimport").up("label").addClassName("updating");
	new Ajax.Request('/api/platereimportqueue/'+queueItem.id,{
		method:'delete',
		parameters:{
			csrfToken:csrfToken
		},
		onSuccess:afterImportChange,
		onFailure:AjaxUtils.checkResponse
	});
}
function queueForReimport(){
	$("reimport").up("label").addClassName("updating");
	new Ajax.Request('/api/platereimportqueue/',{
		method:'post',
		parameters:{
			csrfToken:csrfToken,
			plateid:data.id
		},
		onSuccess:afterImportChange,
		onFailure:AjaxUtils.checkResponse
	});
}
function afterImportChange(){
	ui.forceReload();
}

Plate.periodicallyUpdateWellSolutions();
</script>

<?php include realpath(__DIR__).'/../../core/_common/footer.php';
