<?php 
$scoringSystems=crystalscoringsystem::getAll();
if(empty($scoringSystems)){
	throw new BadRequestException('Cannot create plates because no scoring system has been set up. Talk to your administrator.');
}
$scoringSystems=$scoringSystems['rows'];

$pageTitle='Create a plate';
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
var scoringSystems=<?php echo json_encode($scoringSystems); ?>;

document.observe("dom:loaded",function(){

	ui.grid();

	grid.box({ 
		classes:'r1 c2 h3 w2',
		title:'Plates',
		content:'If you have an automatic imaging system, you probably don\'t need to do this.'
	});

	var detailsBox=grid.box({ 
		classes:'r1 c1 h3 w1',
		title:'Details'
	});

	var frm=detailsBox.form({
		action:'/api/plate/',
		method:'post',
	});
	frm.hiddenField("ownerid",userId);
	frm.textField({ label:"Barcode", name:'name', value:'' });
	frm.roleField({ 
		label:"Project", 
		name:'projectid',
		otherType:'project',
		labelField:'name',
		headers:['Name', 'Description'],
		cellTemplates:['{{name}}','{{description}}']
	});
	frm.roleField({ 
		label:"Plate type", 
		name:'platetypeid', 
		otherType:'platetype',
		labelField:'name',
		headers:['Name', 'Geometry'],
		cellTemplates:['{{name}}','{{rows}}x{{cols}}, {{subs}}-drop']
	});

	if(scoringSystems.length>1){
		frm.roleField({ 
			label:"Scoring system", 
			name:'crystalscoringsystemid', 
			otherType:'crystalscoringsystem',
			labelField:'name',
			headers:['Name'],
			cellTemplates:['{{name}}']
		});
		frm.createButton();
	} else {
		frm.createButton();
		frm.hiddenField("crystalscoringsystemid",scoringSystems[0]['id']);
	}
});


</script>
<?php 
include realpath(__DIR__).'/../../core/_common/footer.php';
?>