<?php $pageTitle='Imager: '.$data['friendlyname'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
var manualImagingAllowed=<?php echo (config::get('imaging_allowmanual')) ? 'true' : 'false'; ?>;
document.observe("dom:loaded",function(){

	ui.grid();

	var detailsBox=grid.box({ 
		classes:'r1 c1 h3 w1',
		title:'Details'
	});

	var frm=detailsBox.form({
		action:'/api/imager/'+data['id'],
		method:'post',
	});
	frm.textField({ label:"Serial", name:'name', value:data['name'],readonly:!isAdmin });
	frm.textField({ label:"Friendly name", name:'friendlyname', value:data['friendlyname'],readonly:!isAdmin });
	frm.textField({ label:"Manufacturer", name:'manufacturer', value:data['manufacturer'],readonly:!isAdmin });
	frm.textField({ label:"Temperature", name:'temperature', value:data['temperature'],readonly:!isAdmin });
	frm.textField({ label:"Plate capacity", name:'platecapacity', value:data['platecapacity'],readonly:!isAdmin });
	frm.textField({ label:"Alert level", name:'alertlevel', value:data['alertlevel'],readonly:!isAdmin });
	frm.textField({ label:"Warning level", name:'warninglevel', value:data['warninglevel'],readonly:!isAdmin });
	frm.textField({ label:"Active plates", name:'platesactive', value:data['platesactive'],readonly:true });
	frm.textField({ label:"Expired plates", name:'platesexpired', value:data['platesexpired'],readonly:true });
	if(manualImagingAllowed){
		frm.checkbox({ label:'Manual imaging', name:'manualimaging', value:data['manualimaging'],readonly:!isAdmin });
	}

	var ts=grid.tabSet({ classes:"r1 c2 h3 w2"});

	var headerTemplates;
	var cellTemplates;

// 	headerTemplates=['Plate', 'Owner', 'Next inspection', 'Final inspection','Inspections left'];
// 	cellTemplates=[ '<a href="/plate/{{id}}">{{name}}</a>','<a href="/user/{{ownerid}}">{{ownername}}</a>',[ui.fieldToFriendlyDate,'nextinspectiontime'],[ui.fieldToFriendlyDate,'finalinspectiontime'],'{{inspectionsremaining}}' ];
 	headerTemplates=['Plate', 'Owner', 'Project', 'Final inspection','Inspections left'];
 	cellTemplates=[ '<a href="/plate/{{id}}">{{name}}</a>','<a href="/user/{{ownerid}}">{{ownername}}</a>','<a href="/project/{{projectid}}">{{projectname}}</a>',[ui.fieldToFriendlyDate,'finalinspectiontime'],'{{inspectionsremaining}}' ];
	contentBefore='There may be other plates in the imager. These are the ones you have permission to see.';
	if(isAdmin){ contentBefore=""; }
	ts.tab({
		id:'contents',
		label:'Contents',
		url:'/api/imager/'+data['id']+'/plate?sortby=finalinspectiontime&pagesize='+data.platecapacity,
		headers:headerTemplates,
		cellTemplates:cellTemplates,
		contentBefore:contentBefore
	});

	headerTemplates=['Inspection','Plate','Owner','Project'];
	cellTemplates=[ [ImagingSession.getLink,'imageddatetime'], '<a href="/plate/{{plateid}}">{{platename}}</a>', '{{ownername}}', '<a href="/project/{{projectid}}">{{projectname}}</a>' ];
	if(isAdmin){
		cellTemplates=[ [ImagingSession.getLink,'imageddatetime'], '<a href="/plate/{{plateid}}">{{platename}}</a>', '<a href="/user/{{ownerid}}">{{ownername}}</a>', '<a href="/project/{{projectid}}">{{projectname}}</a>' ];
	}
	ts.tab({
		id:'inspections',
		label:'Latest inspections',
		url:'/api/imagingsession/imagerid/'+data['id']+'?sortby=imageddatetime&sortdescending=1',
		headers:headerTemplates,
		cellTemplates:cellTemplates,
	});

	ts.filesTab();

    // let audioTab=ts.tab({
    //     id:'test',
    //     label:'Audio test',
    // });
    // let f=audioTab.form({
    //    action:'#',
    //    method:'post'
    // });
    // f.audioField();
//    f.audioField({readonly:true});


	window.setTimeout(highlightExpiredPlates,500);
	
});

function highlightExpiredPlates(){
	var plateRows=$("contents_body").select("tr");
	if(plateRows && 0<plateRows.length){
		var MS_PER_DAY=1000*60*60*24;
		var now=new Date();
		var nowUTC=Date.UTC(now.getFullYear(), now.getMonth(), now.getDate());
		plateRows.each(function(tr){
			if(!tr.rowData){ return; }
			if(0==tr.rowData.inspectionsremaining){
				tr.style.background="#fcc";
				tr.title="Plate has expired and should be removed from the imager";
			} else {
				var finalImaging=tr.rowData.finalinspectiontime;
				if(finalImaging && finalImaging.match(/^\d\d\d\d-\d\d-\d\d/)){
					var finalUTC=Date.UTC(finalImaging.substr(0,4), (finalImaging.substr(5,2)-1), finalImaging.substr(8,2));
					var dayDiff=(nowUTC-finalUTC)/MS_PER_DAY;
					if(dayDiff>=7){ 
						tr.style.background="#ffc";
						tr.title="Plate has uncompleted final imaging more than one week old. The imager may have failed to mark it as expired. Plate should probably be removed from the imager.";
					}
				}
			}
		});
	}
	window.setTimeout(highlightExpiredPlates,2000);
}
</script>
<?php 
include realpath(__DIR__).'/../../core/_common/footer.php';
?>