<?php
/** @var array $data The crystal we are going to view */
$pageTitle='Crystal: '.$data['name'];
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(project::SHARED);
//$canManagePdbDepositions=(session::isAdmin() || in_array($data['projectid'], session::getUpdateProjects()));
$canManagePdbDepositions=(session::isAdmin() || (int)($data['projectownerid'])===(int)(session::getUserId()));
$sharedProjectId=$sharedProject['id'];
$breadcrumbs=array(
    array('url'=>'/project/'.$data['projectid'], 'icon'=>'project', 'help'=>'Go to this plate\'s project'),
    array('url'=>'/plate/'.$data['plateid'], 'icon'=>'plate', 'help'=>'Go to this plate')
);
include realpath(__DIR__).'/../../core/_common/header.php';
?>
<script type="text/javascript">
let canManagePdbDepositions=<?php echo $canManagePdbDepositions ? 'true' : 'false '; ?>;

document.observe("dom:loaded",function(){
	let grid=ui.grid();
	let detailsBox=grid.box({
		id:'crystaldetails',
		classes:'r1 c1 h3 w1',
		title:'Crystal'
	});

	detailsBox.innerHTML+='<div id="dropimage" style="position:relative"><img alt="Crystal drop" src="/dropimagefile/'+data.dropimageid+'" style="width:100%" /></div>';

	new Ajax.Request('/api/dropimage/'+data.dropimageid, {
		method:'get',
		onFailure:function(transport){ /* meh */},
		onSuccess:function(transport){
			detailsBox.addClassName("dropviewer");
			let di=$("dropimage");
			di.innerHTML+='<div id="xs_crosshair" class="xs_crosshair">'+
			'<div class="xs_cross" style="cursor:auto"><div class="xs_crossx"></div><div class="xs_crossy"></div></div>'+
			'<div class="xs_ring" style="cursor:auto"></div>'+
			'</div>';
            let xh=$("xs_crosshair");
            if(1!==parseInt(data.isdummycoordinate)){
                xh.style.display="block";
                xh.style.cursor="auto";
                let scale=di.down("img").getWidth()/transport.responseJSON["pixelwidth"];
                xh.style.top=( scale*data.pixely - (xh.getHeight()/2))+"px";
                xh.style.left=( scale*data.pixelx - (xh.getWidth()/2))+"px";
            }
		}
	});
	
	let frm=detailsBox.form({
		action:'/api/crystal/'+data['id'],
		method:'patch',
	});
	let wellDropName=data["welldropname"].split('_')[1];
	let dropNumber=data.numberindrop;
	frm.formField({ readOnly:true, label:"&nbsp;", content:`<a href="/imagingsession/${data["imagingsessionid"]}#${wellDropName}c${dropNumber}">Show in drop viewer</a>` });
    frm.formField({ readOnly:true, label:"Plate", content:'<a href="/plate/'+data["plateid"]+'">'+data["platename"]+'</a>' });
    frm.formField({ readOnly:true, label:"Well and drop", content:wellDropName.replace("."," drop ") });
    new Ajax.Request("/api/plate/"+data.plateid,{
        method:"get",
        onFailure:function(){/* meh */},
        onSuccess:function(transport){
            let plate=transport.responseJSON;
            if(""!==plate.screenid){
                new Ajax.Request("/api/screen/"+plate.screenid,{
                    method:"get",
                    onFailure:function(){/* meh */},
                    onSuccess:function(transport){
                        let screen=transport.responseJSON;
                        new Ajax.Request("/api/screen/"+plate.screenid+"/screencondition?pagenumber=1&pagesize=1000",{
                            method:"get",
                            onFailure:function(){/* meh */},
                            onSuccess:function(transport){
                                let conditions=transport.responseJSON.rows;
                                let plateRow=parseInt(data.row);
                                let plateCol=parseInt(data.col);
                                conditions.each(function(c){
                                    let conditionRow=parseInt(c.row);
                                    let conditionCol=parseInt(c.col);
                                    if(plateRow===conditionRow && plateCol===conditionCol){
                                        if(1===parseInt(screen["isstandard"])){
                                            frm.formField({ readOnly:true, label:"Screen", content:screen.name });
                                        }
                                        frm.formField({ readOnly:true, label:"Condition", content:c.description });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }
    });

	let ts=grid.tabSet({ classes:'r1 c2 w2 h3' });
	Crystal.renderProteinTab(data,ts);
	Crystal.renderDataCollectionsTab(data,ts);
	ts.filesTab();
	ts.notesTab();

});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php'; ?>
