<?php 
/**
 * This is the crystal fishing UI.
 */
$pageTitle='Fishing crystals';
$breadcrumbs=array();
$hasConfig=true;
include realpath(__DIR__).'/../../core/_common/header.php'; 
$sharedProject=project::getByName(project::SHARED);
$sharedProjectId=$sharedProject['id'];
$canShip=shipment::canCreate();
?>
<script type="text/javascript" src="/js/model/fishing/fishing.js?t=<?php echo @filemtime($wwwroot.'/client/js/model/fishing/fishing.js'); ?>">"></script>
<script type="text/javascript">
var canShip=<?php echo $canShip ? 'true' : 'false'; ?>;
var startBarcodes=[<?php if(isset($_GET['barcodes'])){ echo '"'.implode('","',explode(',',$_GET['barcodes'])).'"'; } ?>];

document.observe("dom:loaded",function(){

	ui.keepAlive();
	
	var grid=ui.grid(); //which we'll ignore, but the CSS may depend on the nesting

	var scanBox=grid.box({
		title:'Barcode entry',
		content:''
	});	
	var trashBox=grid.box({
		id:"trashbox",
		title:'Remove containers',
		content:'Drag containers here to remove them from the bench'
	});
	var plateBox=grid.box({
		id:"platebox",
		title:'Plate',
		content:''
	});
	var pinsBox=grid.box({
		id:"pinsbox",
		title:'Pins',
		content:''
	});
	var pucksAndDewarsBox=grid.box({
		id:"pucksdewarsbox",
		title:'Pucks and dewars',
		content:''
	});
 	scanBox.up(".box").setStyle(  { position:"absolute", top:"1%",  left:"1%", width:"42%", height:"15%" });
 	trashBox.up(".box").setStyle( { position:"absolute", top:"1%",  left:"44%", width:"17%", height:"15%" });
 	plateBox.up(".box").setStyle( { position:"absolute", top:"18%", left:"1%", width:"60%", height:"80%" });
 	pinsBox.up(".box").setStyle(  { position:"absolute", top:"1%",  left:"62%", height:"97%", width:"18%" });
	pucksAndDewarsBox.up(".box").setStyle( { position:"absolute", top:"1%",  left:"81%", height:"97%", width:"18%" });

	var f=scanBox.form({
		autosubmit:false,
		id:"barcodeform"
	});
	var barcodeField=f.textField({
		name:"barcode",
		label:"",
		value:"",
		helpText:"If not using a barcode scanner, type the barcode and press Enter"
	}).down("input");
	barcodeField.placeholder="Scan a plate, pin, puck or dewar barcode";
	barcodeField.setStyle({width:"98%", fontSize:"1.5em", margin:"0.25em" });
	barcodeField.autocomplete="off";

	var pucksBox=document.createElement("div");
	pucksBox.id="pucksbox";
	$(pucksBox).setStyle({ position:"absolute", top:"0",  left:"0", right:"0", maxHeight:"58%", padding:"0.25em", overflow:"auto" });
	pucksAndDewarsBox.appendChild(pucksBox);

	var dewarsBox=document.createElement("div");
	dewarsBox.id="dewarsbox";
	$(dewarsBox).setStyle({ position:"absolute", bottom:"0",  left:"0", right:"0", maxHeight:"38%", padding:"0.25em", overflow:"auto" });
	pucksAndDewarsBox.appendChild(dewarsBox);
	
	Fishing.init();
	
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php'; ?>
