<?php $pageTitle='Usergroup: '.$data['name'];
include realpath(__DIR__).'/../_common/header.php'; ?>
<script type="text/javascript">
document.observe("dom:loaded",function(){

	
	ui.grid();
	var detailsBox=grid.box({ 
		classes:'r1 c1 h3 w1',
		title:'Details'
	});
	var frm=detailsBox.form({
		action:'/api/usergroup/'+data['id'],
	});
	var isSystem=data['issystem']*1;
	var isGroupAdmin=data['isgroupadmin']*1;
	frm.textField({ label:"Name", name:'name', value:data['name'], readonly:(isSystem || (!isAdmin && !isGroupAdmin)) });
	frm.textField({ label:"Description", name:'description', value:data['description'], readonly:(isSystem || (!isAdmin && !isGroupAdmin)) });
	frm.dropdown({ label:'Group visibility', name:'groupvisibility', value:data['groupvisibility'], readonly:(!isAdmin && !isGroupAdmin),
		options:[{ label:'Hidden',value:'hidden'}, {label:'Members only',value:'membersonly'}, {label:'Visible',value:'visible'}] });
	frm.dropdown({ label:'Membership visibility', name:'membershipvisibility', value:data['membershipvisibility'], readonly:(!isAdmin && !isGroupAdmin),
		options:[{ label:'Hidden',value:'hidden'}, {label:'Members only',value:'membersonly'}, {label:'Visible',value:'visible'}] });
// 	frm.dropdown({ label:'Joining the group', name:'joining', value:data['joining'], readonly:(!isAdmin &&!isSystem),
// 		options:[{ label:'Closed',value:'closed'}, {label:'Request',value:'request'}, {label:'Open',value:'open'}, {label:'Auto',value:'auto'}] });
	frm.checkbox({ label:'Project creators', name:'cancreateprojects',readonly:!isAdmin });
	frm.checkbox({ label:'Usergroup creators', name:'cancreateusergroups',readonly:!isAdmin });

	var ts=grid.tabSet({ classes:'r1 c2 h3 w2' });
	var headers=['Name','Group admin'];
	var cellTemplates=['<a href="/user/{{id}}">{{fullname}}</a>',[Usergroup.writeIsGroupAdminCell,'isgroupadmin'] ]; 
	if(isAdmin || 1==data.isgroupadmin){
		headers.push('<input type="button" onclick="Usergroup.startAddMember()" value="Add group members..." />');
		cellTemplates.push('<input type="button" onclick="Usergroup.removeMember(this)" value="Remove" />');
	}
	
	ts.tab({ 
		id:'members',
		label:'Members', 
		url:'/api/usergroup/'+data['id']+'/member', 
		headers:headers,
		cellTemplates:cellTemplates,
		failureHandler:Usergroup.membersTabOnFailure
	});
	ts.tab({ 
		id:'permissions', 
		label:'Permissions', 
		url:'/api/usergroup/'+data['id']+'/permission', 
		successHandler:Usergroup.writePermissions,
	 });

	
	
});

var Usergroup={

	membersTabOnFailure: function(transport){
		var out='';
		if(404==transport.status){
			out='<p>This group has no members.</p><p><input type="button" onclick="Usergroup.startAddMember()" value="Add group members..." /></p>';
		} else if(transport.responseJSON && transport.responseJSON.error){
			out='<p>Could not get member list.</p><p>'+transport.responseJSON.error+'</p>';
		} else {
			out='<p>Could not get member list. The server said:</p><p>'+transport.responseText+'</p>';
		}
		$("members_body").innerHTML=out;
	},
		
	writeIsGroupAdminCell: function(obj, field){
		if(1==obj.isadmin){
			return '<img src="/images/icons/yes.gif" title="(System-wide administrator)"/>';
		} else if(!isAdmin && 1!=data.isgroupadmin){
			return ui.checkmark(obj,'isgroupadmin');
		} else {
			if(1==obj.isgroupadmin){
				return '<img src="/images/icons/btn_yes.gif" id="gm'+obj.groupmembershipid+'" style="cursor:pointer" onclick="Usergroup.toggleIsGroupAdmin(this)" />';
			} else {
				return '<img src="/images/icons/btn_no.gif" id="gm'+obj.groupmembershipid+'" style="cursor:pointer" onclick="Usergroup.toggleIsGroupAdmin(this)" />';
			}
		}
	},

	/**
	 * Remove the user from this usergroup.
	 * @param elem The "Remove" button
	 */
	removeMember: function(elem){
		var rowData=elem.up("tr").rowData;
		if(!confirm('Remove '+rowData.fullname+' from group "'+data.name+'"?')){ return false;}
		var gmid=rowData.groupmembershipid;
		elem.up("tr").addClassName("updating");
		new Ajax.Request('/api/groupmembership/'+gmid, {
			method:'delete',
			parameters:{ csrfToken:csrfToken },
			onSuccess:function(transport){ Usergroup.removeMember_onSuccess(transport,elem); },
			onFailure:function(transport){ Usergroup.removeMember_onFailure(transport,elem); }
		});
	},
	removeMember_onSuccess: function(transport,elem){
		if(!AjaxUtils.checkResponse(transport)){ return false; }
		elem.up("tr").remove();
	},
	removeMember_onFailure: function(transport,elem){
		AjaxUtils.checkResponse(transport);
	},


	/**
	 * Begin the "Add member" process by displaying a list of users who are not group members.
	 */
	startAddMember: function(){
		var mb=ui.modalBox({
			'url':'/api/usergroup/'+data.id+'/nonmember',
			'title':'Find users to add',
			'headers':['Name',''],
            'showFilters':[true,false],
			'cellTemplates':['{{fullname}}','<input type="button" onclick="Usergroup.addMember(this)" value="Add to group" />']
		});
	},

	/**
	 * Add the user to this usergroup. They will be added as a normal, non-group-admin, member.
	 * @param elem The "Add" button
	 */
	addMember: function(elem){
		var rowData=elem.up("tr").rowData;
		elem.up("tr").addClassName("updating");
		new Ajax.Request('/api/groupmembership/', {
			method:'post',
			parameters:{ csrfToken:csrfToken, userid:rowData.id, usergroupid:data.id },
			onSuccess:function(transport){ Usergroup.addMember_onSuccess(transport,elem); },
			onFailure:function(transport){ Usergroup.addMember_onFailure(transport,elem); }
		});
	},
	addMember_onSuccess: function(transport,elem){
		if(!AjaxUtils.checkResponse(transport)){ return false; }
		elem.up("tr").remove();
		$("members_body").refresh();
		if(!$("modalBox").down("tr.datarow")){
			ui.closeModalBox();
		}
	},
	addMember_onFailure: function(transport,elem){
		AjaxUtils.checkResponse(transport);
	},
		
	/**
	 * Write the permissions table for this usergroup. Success handler for the Permissions tab.
	 * @param transport The XHR object
	 */
	writePermissions: function(transport){
		if(!transport.responseJSON){
			$("permissions_body").innerHTML="Could not understand reply from server:</br></br>"+transport.responseText;
			return;
		}
		$("permissions_body").addClassName("hastable");
		var out='<table><tr><th>Project</th><th>Read</th><th>Update</th><th>Create</th><th>Delete</th></tr>'
		transport.responseJSON.rows.each(function(proj){
			out+='<tr><td><a href="/project/'+proj.id+'">'+proj.name+'</a></td>';
			if("<?php echo usergroup::ADMINISTRATORS; ?>"==data['name']){
				Object.keys(proj.permissions).each(function(p){
					out+='<td><img src="/images/icons/yes.gif" id=""/></td>';
				});
			} else if(isAdmin ||proj.owner==userId){
				//editable permissions
				Object.keys(proj.permissions).each(function(p){
					if(proj.permissions[p]){
						out+='<td><img class="buttonimg" src="/images/icons/btn_yes.gif" data-permissiontype="'+p+'" data-projectid="'+proj.id+'" data-usergroupid="'+data["id"]+'" id="p'+proj.id+p+'" data-permissionid="'+proj.permissions[p]+'" /></td>';
					} else {
						out+='<td><img class="buttonimg" src="/images/icons/btn_no.gif" data-permissiontype="'+p+'" data-projectid="'+proj.id+'" data-usergroupid="'+data["id"]+'" id="p'+proj.id+p+'" data-permissionid="" /></td>';
					}
				});
			} else { 
				//Read-only permissions, cannot edit
				Object.keys(proj.permissions).each(function(p){
					if(proj.permissions[p]){
						out+='<td><img src="/images/icons/yes.gif" id=""/></td>';
					} else {
						out+='<td><img src="/images/icons/no.gif" id=""/></td>';
					}
				});
			}
			out+='</tr>';
		});
		out+='</table>';
		$("permissions_body").innerHTML=out;
		$$("#permissions_body img.buttonimg").each(function(img){ img.observe("click",Usergroup.togglePermission) });
	},

	/**
	 * Promote a group member to group admin, or demote a group admin to a regular member.
	 * @param btn The toggle button/image.
	 */
	toggleIsGroupAdmin: function(btn){
		var tr=btn.up("tr");
		if(tr.hasClassName("updating")){ return false; } 
		var obj=tr.rowData;
		var newValue= (1==obj.isgroupadmin) ? "0" : "1";
		tr.addClassName("updating");
		new Ajax.Request("/api/groupmembership/"+obj.groupmembershipid,{
			method:"patch",
			parameters:{
				csrfToken:csrfToken,
				isgroupadmin:newValue,
			},
			onSuccess:Usergroup.toggleIsGroupAdmin_onSuccess,
			onFailure:Usergroup.toggleIsGroupAdmin_onFailure
		});
	},
	toggleIsGroupAdmin_onSuccess: function(transport){
		if(!AjaxUtils.checkResponse(transport)){ return false; }
		var updated=transport.responseJSON.updated;
		var btn=$("gm"+updated.id);
		var tr=btn.up("tr");
		if(1==updated.isgroupadmin){
			btn.src=btn.src.replace("btn_no","btn_yes");
		} else {
			btn.src=btn.src.replace("btn_yes","btn_no");
		}
		tr.removeClassName("updating");
	},
	toggleIsGroupAdmin_onFailure: function(transport){
		AjaxUtils.checkResponse(transport);
	},
	
	/**
	 * Add or remove a group's permission on a project.
	 */
	togglePermission: function(evt){
		var btn=$(evt.target);
		if(btn.up("td").hasClassName("updating")){ return false; }
		btn.up("td").addClassName("updating");
		if(btn.dataset.permissionid && btn.dataset.permissionid!=""){
			//delete the permission
			new Ajax.Request("/api/permission/"+btn.dataset.permissionid,{
				method:"delete",
				postBody:"csrfToken="+csrfToken,
				onSuccess:function(transport){ Usergroup.togglePermission_onSuccess(transport,btn) },
				onFailure:function(transport){ Usergroup.togglePermission_onFailure(transport,btn) },
			});
		} else {
			//create the permission
			new Ajax.Request("/api/permission",{
				method:"post",
				postBody:"csrfToken="+csrfToken+"&projectid="+btn.dataset.projectid+"&usergroupid="+btn.dataset.usergroupid+"&type="+btn.dataset.permissiontype,
				onSuccess:function(transport){ Usergroup.togglePermission_onSuccess(transport,btn) },
				onFailure:function(transport){ Usergroup.togglePermission_onFailure(transport,btn) },
			});
		}
	},
	togglePermission_onSuccess: function(transport,btn){
		btn.up("td").removeClassName("updating");
		if(!transport.responseJSON || transport.responseJSON.error){
			return Usergroup.togglePermission_onFailure(transport,btn);
		}
		if(transport.responseJSON.created){ 
			btn.dataset.permissionid=transport.responseJSON.created.id;
			btn.src=btn.src.replace("no.gif","yes.gif");
		} else {
			btn.dataset.permissionid="";
			btn.src=btn.src.replace("yes.gif","no.gif");
		}
	},
	togglePermission_onFailure: function(transport,btn){
		btn.up("td").removeClassName("updating");
		if(transport.responseJSON && transport.responseJSON.error){
			alert(transport.responseJSON.error);
		} else {
			alert(transport.responseText); 
		}
	},
	
} //end of Usergroup object

</script>
<?php include realpath(__DIR__).'/../_common/footer.php'; ?>