<?php
/** @var array $data */
$pageTitle='User: '.$data['fullname'];
include realpath(__DIR__).'/../_common/header.php'; ?>
<script type="text/javascript"><?php include realpath(__DIR__).'/../../model/user/extensions.js'; ?></script>
<script type="text/javascript">
document.observe("dom:loaded",function(){
	
	ui.grid();
    let detailsBox;
    let passwordBox;

	//basic page layout first
	if(isAdmin || 1*userId===1*data['id'] /* TODO && using database authentication */){
		detailsBox=grid.box({
			classes:'r1 c1 h2 w1',
			title:'Details'
		});
		passwordBox=grid.box({
			classes:'r3 c1 h1 w1',
			title:'Change password'
		});
			                   	
	} else {
		detailsBox=grid.box({
			classes:'r1 c1 h3 w1',
			title:'Details'
		});
	}

	
	let ts=grid.tabSet({ classes:'r1 c2 h3 w2' });

	//see ../model/extensions.js
	userExtensions.tabsBefore(ts);	

	if(isAdmin || 1*userId===1*data['id'] /* TODO && using database authentication */){

		if(1*data["isadmin"]===1){ //User BEING VIEWED is an administrator
			ts.tab({ 
				id:'projects', 
				label:'Projects', 
				content:data["fullname"]+' is an administrator, and has full rights on all projects.',
			 });
		 } else {
			ts.tab({ 
				id:'projects', 
				label:'Projects', 
				url:'/api/user/'+data['id']+'/project', 
				successHandler:writePermissions
			 });
		 }

		if(isAdmin){ //User VIEWING THIS PAGE is an administrator
			//Show all groups with add/add-as-admin/remove
			ts.tab({ 
    			id:'memberships', 
    			label:'Groups', 
    			url:'/api/usergroup',
    			pageSize:1000,
    			headers:['Name','','','',''],
    			cellTemplates:[
        			'<a href="/usergroup/{{id}}">{{name}}</a>',
        			'<span class="user_groupstatus">...</span>', 
        			'<span class="user_groupnonmember">...</span>', 
        			'<span class="user_groupmember">...</span>', 
        			'<span class="user_groupadmin">...</span>'
        		]
    		});
    		UserGroupManagement.getMemberships();
		} else{
			//Show only groups the user belongs to, read-only
			ts.tab({ 
    			id:'memberships', 
    			label:'Groups', 
    			url:'/api/user/'+data['id']+'/usergroup',
    			headers:['Name','Is group admin'],
    			cellTemplates:['<a href="/usergroup/{{id}}">{{name}}</a>',[ui.checkmark,'isgroupadmin'] ]
    		});
		}

	} else {
		ts.tab({ 
			id:'more', 
			label:'Info', 
			content:'If you aren\'t an administrator, you can\'t see other users\' project and group information', 
		 });
	}

	//see ../model/extensions.js
	userExtensions.tabsAfter(ts);	

	
	if(undefined!==passwordBox){
		let passwordForm=passwordBox.form({
			action:'/api/user/'+data['id'],
			classes:'create'
		});
		if(!isAdmin){
			passwordForm.passwordField({ label:"Old", name:'oldpassword', value:'', readonly:false });
		}
		passwordForm.passwordField({ label:"New", name:'password1', value:'', readonly:false});
		passwordForm.passwordField({ label:"New again", name:'password2', value:'', readonly:false });
		passwordForm.buttonField({ label:"Change", id:"changepassword", onclick:changePassword });
	}


	let frm=detailsBox.form({
		action:'/api/user/'+data['id'],
	});
	frm.textField({ label:"Full name", name:'fullname', value:data['fullname'], readonly:!isAdmin });
	if(isAdmin){
		frm.textField({ label:"Email address", name:'email', value:data['email'] });
		frm.textField({ label:"Username", name:'name', value:data['name'], readonly:!isAdmin });
		frm.checkbox({ label:"Account is active", name:'isactive', value:data['isactive'] });
	}

	if(""===data["supervisorid"] || 0===data["supervisorid"]){
		frm.roleField({
			readonly:!isAdmin,
			label:"Supervisor", 
			name:'supervisorid', 
			otherType:'user',
			labelField:'fullname',
			headers:['Name'],
			cellTemplates:['{{fullname}}']
		});
	} else {
		new Ajax.Request('/api/user/'+data.supervisorid, {
			method:'get',
			onSuccess:function(transport){
				let supervisor=transport.responseJSON;
				frm.roleField({
					readonly:!isAdmin,
					label:"Supervisor", 
					name:'supervisorid', 
					otherId:supervisor.id, 
					otherName:supervisor.fullname, 
					otherType:'user',
					labelField:'fullname',
					headers:['Name'],
					cellTemplates:['{{fullname}}']
				});
			},
			onFailure:function(){}
		});
	}
	
});

function changePassword(evt){
	let btn=$(evt.target);
	let frm=btn.closest("form");
	let oldPasswordField=frm.querySelector("[name=oldpassword]");
	let new1Field=frm.querySelector("[name=password1]");
	let new2Field=frm.querySelector("[name=password2]");
	if(oldPasswordField && ""===oldPasswordField.value){
		alert("Old password is required");
		return false;
	} else if(new1Field.value!==new2Field.value || ""===new1Field.value){
		alert("New password: Both fields must match");
		return false;
	}
	btn.closest("label").classList.add("updating");
	let body="csrfToken="+csrfToken+"&password="+new1Field.value;
	if(oldPasswordField){ body +="&oldpassword="+oldPasswordField.value; }
	new Ajax.Request("/api/user/"+data['id'], {
		method:"patch",
		postBody:body,
		onSuccess:changePassword_onSuccess,
		onFailure:changePassword_onFailure
	});
}
function changePassword_onSuccess(transport){
	if(!transport.responseJSON || transport.responseJSON.error){ return changePassword_onFailure(transport); }
    let lbl=document.getElementById("changepassword").closest("label");
	lbl.classList.remove("updating");
	lbl.innerHTML="Password changed";
}
function changePassword_onFailure(transport){
	document.getElementById("changepassword").closest("label").classList.remove("updating");
	if(transport.responseJSON && transport.responseJSON.error){ 
		alert(transport.responseJSON.error);
	} else {
		alert(transport.responseText);
	}
}

function writePermissions(transport){
    let pb=document.getElementById("projects_body");
	if(!transport.responseJSON){
		pb.innerHTML="Could not understand reply from server:</br></br>"+transport.responseText;
		return;
	}
	pb.classList.add("hastable");
	let permissionTypes=['read','update','create','delete'];
	let out='<table><tr><th>Project</th><th>Read</th><th>Update</th><th>Create</th><th>Delete</th></tr>';
	transport.responseJSON.rows.each(function(proj){
		let ownerFlag='';
		if(1===1*proj["isowner"]){ ownerFlag=' (owner)'; }
		out+='<tr><td><a href="/project/'+proj.id+'">'+proj.name+'</a>'+ownerFlag+'</td>';
		//Read-only permissions, cannot edit
		permissionTypes.forEach(function(t){
			if(1===1*proj["isowner"]){
				out+='<td><img alt="Yes" src="/images/icons/yes.gif" title="Because '+data["fullname"]+' owns the project" id=""/></td>';
			} else if(!!proj.permissions[t]){
				let label="From group";
				if(proj.permissions[t].length>1){ label+="s"; }
				label+=": ";
				proj.permissions[t].each(function(perm){
					label+=perm["usergroupname"]+", ";
				});
				label=label.slice(0,-2);
				out+='<td><img alt="Yes" src="/images/icons/yes.gif" title="'+label+'" id=""/></td>';
			} else {
				out+='<td><img alt="No" src="/images/icons/no.gif" id=""/></td>';
			}
		});
		out+='</tr>';
	});
	out+='</table>';
	pb.innerHTML=out;
}

let UserGroupManagement={

	getMemberships:function(){
		new Ajax.Request('/api/user/'+data['id']+'/usergroup?pagenum=1&pagesize=1000',{
			method:"get",
			onSuccess:function(transport){
				UserGroupManagement.updateGroupMembershipStatuses(transport.responseJSON.rows);
			},	
			onFailure:function(transport){
				if(404===1*transport.status){
					UserGroupManagement.updateGroupMembershipStatuses([]);
				} else {
					alert("Could not get group memberships");
				}
			}	
		});
	},

 	updateGroupMembershipStatuses:function(groups){
	    let mb=document.getElementById("memberships_body");
 	 	if(!mb.querySelector("td")){
			window.setTimeout(function(){
				UserGroupManagement.updateGroupMembershipStatuses(groups);
			},250);
			return false;
 	 	}
 		mb.querySelectorAll("tr").forEach(function(tr){
			if(!tr.rowData){ return; }
			tr.id="group"+tr.rowData["id"];
			tr.rowData['groupmembershipid']=null;
			tr.rowData['isgroupadmin']=null;
		});
		groups.forEach(function(grp){
		    let tr=document.getElementById("group"+grp.id);
			tr.rowData['groupmembershipid']=grp['groupmembershipid'];
			tr.rowData['userisgroupadmin']=grp['isgroupadmin'];
 		});
 		mb.querySelectorAll("tr").forEach(function(tr){
			if(!tr.rowData){ return; }
			UserGroupManagement.updateGroupMembershipStatus(tr);
 		});
 	},
	
	updateGroupMembershipStatus:function(tr){
		tr.classList.remove("updating");
		if(!tr.rowData){ return; }
		let groupStatus='Not in group';
		let bgColor='';
		let removeButton='<input type="button" data-newstatus="nonmember" value="Remove from group" onclick="UserGroupManagement.handleMemberButton(this)"/>';
		let addButton='<input type="button" data-newstatus="groupmember" value="Make group member" onclick="UserGroupManagement.handleMemberButton(this)" />';
		let addAdminButton='<input type="button" data-newstatus="groupadmin" value="Make group admin" onclick="UserGroupManagement.handleMemberButton(this)" />';
		if(!tr.rowData['groupmembershipid']){ 
			//Not a member "Add" "Add as group admin"
			removeButton='&nbsp;';
		} else {
			let isGroupAdmin=1*tr.rowData['userisgroupadmin'];
			if(!isGroupAdmin){ 
    			//Regular member "Remove" "Make group admin" 
    			addButton='&nbsp;';
    			groupStatus='<span style="font-weight:bold;color:green">Group member</span>';
    			bgColor='#dfd';
    		} else {
    			//Group admin "Remove" "Make regular member" 
    			addAdminButton='&nbsp;';
    			groupStatus='<span style="font-weight:bold;color:#f60">Group admin</span>';
    			bgColor='#ffd';
    		}
		}
		tr.style.backgroundColor=bgColor;
		tr.querySelector(".user_groupstatus").innerHTML=groupStatus;
		tr.querySelector(".user_groupnonmember").innerHTML=removeButton;
		tr.querySelector(".user_groupmember").innerHTML=addButton;
		tr.querySelector(".user_groupadmin").innerHTML=addAdminButton;
	},

	handleMemberButton:function(btn){
		let tr=btn.closest("tr");
		let membershipId=tr.rowData['groupmembershipid'];
		let newStatus=btn.dataset.newstatus;
		if("nonmember"===newStatus){
			UserGroupManagement.removeFromGroup(tr);
		} else {
			let makeAdmin=false;
			if("groupmember"===newStatus){
				makeAdmin=false;
			} else if("groupadmin"===newStatus){
				makeAdmin=true;
			}
			if(membershipId){
				UserGroupManagement.changeGroupAdminStatus(tr, makeAdmin);
			} else {
				UserGroupManagement.addToGroup(tr, makeAdmin);
			}
		} 
	},
	
	removeFromGroup:function(tr){
		tr.classList.add("updating");
		new Ajax.Request('/api/groupmembership/'+tr.rowData['groupmembershipid'],{
			method:'delete',
			parameters:{ csrfToken:csrfToken },
			onSuccess:function(){
				tr.rowData['groupmembershipid']=null;
				tr.rowData['userisgroupadmin']=null;
				UserGroupManagement.updateGroupMembershipStatus(tr);
			},
			onFailure:AjaxUtils.checkResponse
		});
	},

	addToGroup:function(tr, makeAdmin){
		tr.classList.add("updating");
		new Ajax.Request('/api/groupmembership/',{
			method:'post',
			parameters:{ 
				csrfToken:csrfToken, 
				userid:data['id'],
				usergroupid:tr.rowData['id'],
				isgroupadmin:1*makeAdmin
			},
			onSuccess:function(transport){ 
				tr.rowData['groupmembershipid']=transport.responseJSON.created.id;
				tr.rowData['userisgroupadmin']=transport.responseJSON.created.isgroupadmin;
				UserGroupManagement.updateGroupMembershipStatus(tr);
			},
			onFailure:AjaxUtils.checkResponse
		});

	},

	changeGroupAdminStatus(tr, makeAdmin){
		tr.classList.add("updating");
		new Ajax.Request('/api/groupmembership/'+tr.rowData['groupmembershipid'],{
			method:'patch',
			parameters:{ 
				csrfToken:csrfToken, 
				isgroupadmin:1*makeAdmin
			},
			onSuccess:function(){
				tr.rowData['userisgroupadmin']=makeAdmin;
				UserGroupManagement.updateGroupMembershipStatus(tr);
			},
			onFailure:AjaxUtils.checkResponse
		});

	}
	
};
</script>
<?php include realpath(__DIR__).'/../_common/footer.php';