<?php 
/**
 * This is the basic "view" page for a project. Don't modify this. Instead, add tabs through extensions.js in this directory.
 */
$pageTitle='Project: '.$data['name'];
include realpath(__DIR__).'/../_common/header.php'; ?>
<script type="text/javascript"><?php include realpath(__DIR__).'/../../model/project/extensions.js'; ?></script>
<script type="text/javascript">

var isOwner=(parseInt(data['owner'])===parseInt(userId));
var canWriteInProject=<?php echo (in_array($data['id'], session::getUpdateProjects()))? 'true':'false'; ?>;

document.observe("dom:loaded",function(){

	
	ui.grid();
	var detailsBox=grid.box({ 
		classes:'r1 c1 h3 w1',
		title:'Details'
	});
	var frm=detailsBox.form({
		action:'/api/project/'+data['id'],
	});
	var isSystem=data['issystem'];
	frm.textField({ label:"Name", name:'name', value:data['name'], readonly:(!isAdmin &&!isOwner) });
	frm.textField({ label:"Description", name:'description', value:data['description'], readonly:(!isAdmin &&!isOwner) });
	frm.roleField({
		readonly:!isAdmin && userId!=data.owner,
		label:"Owner", 
		name:'owner', 
		otherId:data.owner, 
		otherName:data.ownername, 
		otherType:'user',
		labelField:'fullname',
		headers:['Name'],
		cellTemplates:['{{fullname}}']
	});

	//TODO better handling of long text
	if(frm.down("#description")){
        frm.down("#description").style.width="70%";
    }

	
	if(!isAdmin && userId==data.owner){
		var btn=frm.down("input[name=owner]").up("label").down("input[type=button]");
		btn.observe("click",function(){
			alert("You can see and update this project because you are the owner. If you change the owner, "+ 
					"you may lose all rights on this project!\n\nIf you've just created the project and are "+
					"setting it up for someone else, make all your other changes before changing the project owner.");
		});
	}
	/*
	var archiveBox=grid.box({ 
		classes:'r3 c1 h1 w1',
		title:'Archive this project',
		content:'Not implemented yet. Archiving a project makes it (and everything in it) read-only. It also means items in the project will not be offered as suggestions, so archiving old projects makes the system easier to use.'
		
	});
	*/
	
	var ts=grid.tabSet({ classes:'r1 c2 h3 w2' });

	//see ../model/extensions.js
	projectExtensions.tabsBefore(ts);	

	ts.tab({ 
		id:'permissions', 
		label:'Permissions', 
		url:'/api/project/'+data['id']+'/permission', 
		successHandler:writePermissions
	 });

    ts.filesTab();
    ts.notesTab();

	//see ../model/extensions.js
	projectExtensions.tabsAfter(ts);	
	
});

function writePermissions(transport){
	if(!transport.responseJSON){
		$("permissions_body").innerHTML="Could not understand reply from server:</br></br>"+transport.responseText;
		return;
	}
	$("permissions_body").addClassName("hastable");
	var out='<table><tr><th>Group</th><th>Read</th><th>Update</th><th>Create</th><th>Delete</th></tr>'
	transport.responseJSON.rows.each(function(grp){
		out+='<tr><td><a href="/usergroup/'+grp.id+'">'+grp.name+'</a></td>';
		if("<?php echo usergroup::ADMINISTRATORS; ?>"==grp.name){
			Object.keys(grp.permissions).each(function(p){
				out+='<td><img src="/images/icons/yes.gif" id=""/></td>';
			});
		}else if(isAdmin || data['owner']==userId){
			//editable permissions
			Object.keys(grp.permissions).each(function(p){
				if(grp.permissions[p]){
					out+='<td><img class="buttonimg" src="/images/icons/btn_yes.gif" data-permissiontype="'+p+'" data-projectid="'+data["id"]+'" data-usergroupid="'+grp.id+'" id="p'+grp.id+p+'" data-permissionid="'+grp.permissions[p]+'" /></td>';
				} else {
					out+='<td><img class="buttonimg" src="/images/icons/btn_no.gif" data-permissiontype="'+p+'" data-projectid="'+data["id"]+'" data-usergroupid="'+grp.id+'" id="p'+grp.id+p+'" data-permissionid="" /></td>';
				}
			});
		} else { 
			//Read-only permissions, cannot edit
			Object.keys(grp.permissions).each(function(p){
				if(grp.permissions[p]){
					out+='<td><img src="/images/icons/yes.gif" id=""/></td>';
				} else {
					out+='<td><img src="/images/icons/no.gif" id=""/></td>';
				}
			});
		}
		out+='</tr>';
	});
	out+='</table>';
	$("permissions_body").innerHTML=out;
	$$("#permissions_body img.buttonimg").each(function(img){ img.observe("click",togglePermission) });
}


function togglePermission(evt){
	var btn=$(evt.target);
	if(btn.up("td").hasClassName("updating")){ return false; }
	btn.up("td").addClassName("updating");
	if(btn.dataset.permissionid && btn.dataset.permissionid!=""){
		//delete the permission
		new Ajax.Request("/api/permission/"+btn.dataset.permissionid,{
			method:"delete",
			postBody:"csrfToken="+csrfToken,
			onSuccess:function(transport){ togglePermission_onSuccess(transport,btn) },
			onFailure:function(transport){ togglePermission_onFailure(transport,btn) },
		});
	} else {
		//create the permission
		new Ajax.Request("/api/permission",{
			method:"post",
			postBody:"csrfToken="+csrfToken+"&projectid="+btn.dataset.projectid+"&usergroupid="+btn.dataset.usergroupid+"&type="+btn.dataset.permissiontype,
			onSuccess:function(transport){ togglePermission_onSuccess(transport,btn) },
			onFailure:function(transport){ togglePermission_onFailure(transport,btn) },
		});
	}
}
function togglePermission_onSuccess(transport,btn){
	btn.up("td").removeClassName("updating");
	if(!transport.responseJSON || transport.responseJSON.error){
		return togglePermission_onFailure(transport,btn);
	}
	if(transport.responseJSON.created){ 
		btn.dataset.permissionid=transport.responseJSON.created.id;
		btn.src=btn.src.replace("no.gif","yes.gif");
	} else {
		btn.dataset.permissionid="";
		btn.src=btn.src.replace("yes.gif","no.gif");
	}
}
function togglePermission_onFailure(transport,btn){
	btn.up("td").removeClassName("updating");
	if(transport.responseJSON && transport.responseJSON.error){
		alert(transport.responseJSON.error);
	} else {
		alert(transport.responseText); 
	}
	
}

</script>
<?php include realpath(__DIR__).'/../_common/footer.php'; ?>