<?php 
$rfidAllowed=false;
if('database'==strtolower(config::get('auth_method')) && 1==config::get('auth_db_allow_rfid_login')){
    $rfidAllowed=true;
} else if('ldap'==strtolower(config::get('auth_method')) && 1==config::get('auth_ldap_allow_rfid_login')){
    $rfidAllowed=true;
}
$pageTitle="Log in to IceBear";
include realpath(__DIR__).'/../_common/header.php'; 

$icebearCodeVersion="1.0"; //default
$codeVersionFile=trim(@file_get_contents(rtrim($_SERVER['DOCUMENT_ROOT'],'/').'/conf/codeversion'));
if(!empty($codeVersionFile)){
    $icebearCodeVersion=($codeVersionFile);
}

$messageHeader=str_replace("'","\'", htmlentities(config::get('core_prelogin_messageheader')));
$message=str_replace("'","\'", htmlentities(config::get('core_prelogin_message')));

?>

<script type="text/javascript">
let requestedUri='<?php echo htmlentities($uri); ?>';
let icebearDbVersion='<?php echo config::get('core_icebearversion'); ?>';
if(!icebearDbVersion){ icebearDbVersion='unknown'; }
let icebearCodeVersion='<?php echo $icebearCodeVersion; ?>';
if(!icebearCodeVersion){ icebearCodeVersion='unknown'; }

let codeAndDbMatch=(icebearCodeVersion===icebearDbVersion);

let messageHeader='<?php echo $messageHeader; ?>'.trim();
let message='<?php echo $message; ?>'.trim();

let rfidAllowed=<?php echo ($rfidAllowed) ? 'true' : 'false'; ?>;
let rfid=/^\d+$/;

let grid=ui.grid();

let loginBoxParams={
    'id':'loginbox',
    'title':'Log in',
    'classes':'r1 c2 h1 w1'
};
if(!codeAndDbMatch){

    grid.box({
        'id':'message',
        'title':'Database version mismatch',
        'classes':'r1 c2 h1 w1',
        'content':'<span style="color:red">IceBear can\'t be used at the moment because its database and code don\'t match.<br/><br/>The database version ('+icebearDbVersion+') does not match the code version ('+icebearCodeVersion+'). An administrator needs to fix this</span>.'
    });
    loginBoxParams={
        'id':'loginbox',
        'title':'Administrator login',
        'classes':'r2 c2 h1 w1'
    };
} else if(""!==message){
    loginBoxParams["classes"]="r2 c2 h1 w1";
}

let b=grid.box(loginBoxParams);
let frm=b.form({
    'action':'/api/Login'
});
frm.textField({ label:"Username", name:'username' });
frm.passwordField({ label:"Password", name:'password' });
frm.submitButton({ label:'Log in' });
frm.onsubmit=function(){ Login.doLogin(); return false; };
/*
    if(rfidAllowed){
    	grid.box({
    		'id':'rfidBox',
    		'title':'RFID login',
    		'classes':'r2 c2 h1 w1',
    		'content':'<p>You can log in with your RFID card if this computer has a reader. Just touch your card to the reader.</p><p>To register a new card, touch it to the reader, then provide your username and password.</p><p>If RFID login doesn\'t work, click in the Username box and try again.</p>'
    	});
    }
 */
Event.observe(window,"load",function(){ $("username").focus()});
Event.observe(window,"keyup",Login.maskRfidLogin);
Event.observe(window,"click",Login.maskRfidLogin);

if(""!==message){
    grid.box({
         'id':'prelogin',
         'title':messageHeader,
         'classes':'r1 c2 h1 w1',
         'content':message
    });
}

if(codeAndDbMatch){
    let bs=grid.box({
        'id':'logoBox',
        'classes':'r3 c2 h1 w1'
    });

    let out='<div style="width:100%;position:absolute;bottom:0;left:0;text-align:center;"><img alt="IceBear logo" src="/images/icebearlogo.svg"/>';
    out+='<p style="margin-top:1em;font-size:75%">';
    out+='IceBear version '+icebearDbVersion+' &bull; <a target="_blank" href="http://scripts.iucr.org/cgi-bin/paper?S2059798320015223">Cite IceBear</a>';
    out+='<br/>Distributed under the <a href="/LICENSE.txt" target="_blank">MIT Licence</a></p>';
    out+='</div>';
    bs.innerHTML=out;
    bs.style.border="none";
    bs.style.background="transparent";
    bs=bs.closest(".box");
    bs.style.border="none";
    bs.style.background="transparent";
    setLogoHeight();
    window.onresize=setLogoHeight;
}

function setLogoHeight(){
    let box=document.getElementById("logoBox");
    let pHeight=box.querySelector("p").offsetHeight;
    let maxLogoHeight=160;
    let logoHeight=(box.clientHeight-pHeight-50);
    box.querySelector("img").style.height=Math.min(logoHeight,maxLogoHeight)+"px";
}

</script>

<?php include realpath(__DIR__).'/../_common/footer.php';