<?php $pageTitle='Configuration';
include realpath(__DIR__).'/../_common/header.php'; ?>
<script type="text/javascript">

document.observe("dom:loaded",function(){
	
	ui.grid();

	let ts=grid.tabSet({ classes:'r1 c1 h3 w3' });

    ts.tab({
        id:'prelogin',
        label:'Pre-login message',
        content:'<p class="loadingmsg">Loading config...</p>',
    });
    ts.tab({
        id:'imagers',
        label:'Imagers',
        content:'<p class="loadingmsg">Loading config...</p>',
    });
	ts.tab({
		id:'storage', 
		label:'Storage &amp; Backup',
		content:'<p class="loadingmsg">Loading config...</p>', 
	});
	ts.tab({
		id:'auth', 
		label:'Authentication', 
		content:'<p class="loadingmsg">Loading config...</p><p>IceBear currently supports username/password configuration via its own database.</p><p>Later versions will support LDAP/AD authentication. If you intend to use these later, your life will be easier if people\'s IceBear usernames are the same as their LDAP/AD usernames.</p>',
	});
	let versionTab=ts.tab({
		id:'version', 
		label:'IceBear version',
		content:'<p class="loadingmsg">Checking for IceBear updates...</p>',
	});
	<?php
    	$codeVersion=trim(file_get_contents(rtrim($_SERVER['DOCUMENT_ROOT'],'/').'/conf/codeversion'));
    	$databaseVersion=trim(config::get('core_icebearversion'));
	?>
	versionTab.dataset.codeversion="<?php echo $codeVersion; ?>";	
	versionTab.dataset.databaseversion="<?php echo $databaseVersion; ?>";	
	getConfig();

	//Override this function to submit to /api/config/itemname
	ui.doUpdateFormField=function(field){
		if(field.oldvalue===field.value){ return false; }
		if(field.up("label,td")){ field.up("label,td").classList.add("updating"); }
		let body;
		if(field.type && field.type==="checkbox"){
			body=field.name+"="+(field.checked ? "1" : "0")+"&csrfToken="+csrfToken;
			field.oldvalue=field.checked ? "0" : "1";
		} else {
			field.oldvalue=field.value;
			body=field.name+"="+encodeURIComponent(field.value)+"&csrfToken="+csrfToken;
		}
		window.setTimeout(function(){
			new Ajax.Request('/api/config/'+field.name,{
				method:'patch',
				postBody:body,
				onSuccess:function(transport){ ui.updateFormField_onSuccess(transport,field) },
				onFailure:function(transport){ ui.updateFormField_onFailure(transport,field) }
			});
		},250);
	};
	
});

function getConfig(){
	new Ajax.Request('/api/config/',{
		method:'get',
		onSuccess:renderConfig,
		onFailure:getConfigFailed
	});
}
function getConfigFailed(){
	alert("Could not retrieve configuration from server.");
}
function renderConfig(transport){

		let config={};
		transport.responseJSON.rows.each(function(ci){
			config[ci.name]=ci;
		});
	
		let tabFields={
            'prelogin':['core_prelogin_messageheader','core_prelogin_message'],
			'imagers':[
						'Section:Manual imaging','imaging_allowmanual',
						'Section:Plate re-import','reimport_enabled','reimport_ownerscanqueue','reimport_quota',
						'Section:Formulatrix imagers','fx_hasimagers','fx_dbhost','fx_dbport','fx_dbuser','fx_dbpass','fx_rmdbname','fx_ridbname',
 						'Section:Rigaku','rigaku_hasimagers','rigaku_platepath','rigaku_imagepath','rigaku_thumbpath'
			],
			'storage':[
						'Section:Crystal image storage','core_imagestore','core_imagestorebackup',
						'Section:Uploaded file storage','core_filestore','core_filestorebackup',
						'Section:Database backup','core_databasebackup','core_databasebackupstokeep',
			],
			'auth':['Section:Timeout','auth_timeout_mins'],
		};

		Object.keys(tabFields).each(function(t){
			let tb=document.getElementById(t+'_body');
			tb.querySelector(".loadingmsg").remove();
			let f=tb.form('/api/config');
			tabFields[t].each(function(field){
				if(0===field.indexOf("Section:")){
					f.insert({bottom:'<label><h3>'+field.substr(8).trim()+'</h3></label>'});
				} else {
					let configItem=config[field];
					if(!configItem){
						f.textField({
							label:'<span style="color:red">Unknown config item '+field+'</span>',
							name:'bogus',
							value:'',
							readonly:true
							
						});
					} else if("enum"===configItem.type){
						let parts=configItem["enumvalues"].trim("'");
						parts=parts.split("','");
						let options=[];
						parts.each(function(p){ 
							p=p.replace("'","");
							options.push({ label:p, value:p });
						});
						f.dropdown({
							label:configItem.description,
							name:configItem.name,
							options:options,
							value:configItem.value
						});
					} else if("text"===configItem.type){
						f.textField({
							label:configItem.description,
							name:configItem.name,
							value:configItem.value
						});
					} else if("int"===configItem.type){
						f.textField({
							label:configItem.description,
							name:configItem.name,
							value:configItem.value
						});
					} else if("boolean"===configItem.type){
						f.checkbox({ 
							label:configItem.description,
							name:configItem.name,
							value:configItem.value
						});
					}
				}
			});
		});
		let versionTabHeader=document.getElementById("version");
		if(undefined!==config['update_baseuri']){
			versionTabHeader.dataset.updatesbaseuri=config['update_baseuri'].value;
		}
		checkForUpdates();
}

/**
 * Code below here is for updating IceBear.
 */

let currentVersion;
let newVersion;

function checkForUpdates(){
	let versionTabHeader=document.getElementById("version");
	let codeVersion=versionTabHeader.dataset.codeversion;
	let databaseVersion=versionTabHeader.dataset.databaseversion;
	currentVersion=versionTabHeader.dataset.codeversion;
	if(!codeVersion||!databaseVersion){
		showUpdateCheckError("Could not determine current IceBear version. You will need to install any updates manually.");
	} else if(codeVersion!==databaseVersion){
		showUpdateCheckError("Code version ("+codeVersion+") does not match database version ("+databaseVersion+"). This must be fixed manually.");
		//TODO Determine whether this is something we can fix, e.g., newer code unpacked manually and a database upgrade path exists 
	} else {
		getReleases();
	}
}

function getReleases(){
	new Ajax.Request('/api/updater',{
		method:'get',
		onSuccess:getReleases_onSuccess,
		onFailure:getReleases_onFailure
	});
}
function getReleases_onSuccess(transport){
	let mainVersion=0;
	let subVersion=0;
    let subSubVersion=0;
	let parts=currentVersion.split("\.");
	mainVersion=parts[0]*1;
	if(parts.length>=2){ subVersion=parts[1]*1; }
	if(parts.length>=3){ subSubVersion=parts[2]*1; }
	
	let releases=transport.responseJSON;
	if(!releases){ releases=JSON.parse(transport.responseText); }
	if(!releases){ return getReleases_onFailure(transport); }
	let available=[];
	releases.rows.each(function(r){
		if(parseInt(r["mainversion"])>mainVersion){
			//Release's main version is greater than current, so we want it.
			available.push(r);
		} else if(parseInt(r["mainversion"])===mainVersion){
			//Release's main version is same as current... 
			if(r["subversion"]>subVersion){
				//...but its sub-version is greater than current, we so want it.
				available.push(r);
			} else if(parseInt(r["subversion"])===subVersion){
				//Release's main and sub-versions are same as current...
				if(parseInt(r["subsubversion"])>subSubVersion){
					//...but its sub-sub-version is greater than current, we so want it.
					available.push(r);
				}
			}
		}

	});
	let numAvailable=available.length;
	let currentVersionText="IceBear version: <strong>"+mainVersion+"."+subVersion+"."+subSubVersion+"</strong><br/>";
    let versionTabBody=document.getElementById("version_body");
    if(0===numAvailable){
		currentVersionText+='<p><strong style="color:#060">Your IceBear is up to date.</strong><p>';
		versionTabBody.innerHTML=currentVersionText;
 	} else {
 	 	if(1===numAvailable){
	  		currentVersionText+='<strong style="color:#600">A newer version is available.</strong><br/><br/>';
 	 	} else {
 			currentVersionText+='<strong style="color:#600">Newer versions are available.</strong> You can update to any of these versions.<br/><br/>';
 	 	}
    	versionTabBody.table({
    		contentBefore:currentVersionText,
    		headers:['Version','Description',''],
    		cellTemplates:['IceBear {{mainversion}}.{{subversion}}.{{subsubversion}}','{{description}}','<input type="button" onclick="confirmUpdate(this)" value="Update to this version" />'],
    	}, { total:available.length, rows:available });
	}
}
function getReleases_onFailure(transport){
	let msg='Could not get list of IceBear releases.';
	if(transport.responseJSON && transport.responseJSON.error){
		msg+="<br/><br/>"+transport.responseJSON.error;
	}
	showUpdateCheckError(msg);
}

function showUpdateCheckError(msg){
	let versionTabBody=document.getElementById("version_body");
	versionTabBody.innerHTML='<div class="error">'+msg+'</div>';
}

function confirmUpdate(btn){
	let tr=btn.closest("tr");
	newVersion=tr.rowData["mainversion"]+'.'+tr.rowData["subversion"]+'.'+tr.rowData["subsubversion"];
	let out="<h3>Before updating IceBear...</h3>";
	out+='<p>...check that you have a <strong>good, current back-up</strong> of both the IceBear code and the IceBear database. You will need these if there is a problem with the update.</p>';
	out+='<p>Do this update in a quiet time when nobody else is trying to use IceBear.</p>';
	out+='<form>';
	out+='<label><input type="checkbox" name="understood" id="understood" /> Yes, I\'ve checked. I have a good back-up.</label>';
	out+='<label><input type="checkbox" name="showdebug" id="showdebug" /> I want to see the full debugging output.</label>';
	out+='<label><input type="button" onclick="submitHasBackupsConfirmation()" name="doupdate" id="doupdate" value="Update to version '+newVersion+'"/></label>';
	out+='</form>';
	document.getElementById("version_body").innerHTML=out;
}

function submitHasBackupsConfirmation(){
    let understood=document.getElementById("understood");
    let updateButton=document.getElementById("doupdate");
	if(!understood.checked){
		understood.closest("label").classList.add("invalidfield");
		return false;
	}
	understood.closest("label").classList.remove("invalidfield");
    updateButton.closest("label").classList.add("updating");
    updateButton.disabled=true;
    updateButton.value="Beginning update...";
	new Ajax.Request('/api/updater/1',{
		method:'patch',
		parameters:{ "host": window.document.location.host,
			"csrfToken":csrfToken,
			"confirmedHasBackups":"yes",
			"oldversion":currentVersion,
			"newversion":newVersion
		},
		onSuccess:function(){ doUpdate(false); },
		onFailure:function(){ doUpdate(false); }
	});
}

let updaterUpdated=false;
let updateCompleted=false;
let updateFailed=false;
let failureResponse=null;
let showDebug=1;

function doUpdate(isSecondPass){
    let checkbox=document.getElementById("showdebug");
	if(checkbox){
		showDebug=1;
    	if(!checkbox.checked){
    		showDebug=0;
    	}
	}
	let parameters={
		"csrfToken":csrfToken,
		"newversion":newVersion,
		"showdebug":showDebug
	};
	if(isSecondPass){
		parameters['secondpass']=1;
	}
    let versionTabBody=document.getElementById("version_body");
	versionTabBody.innerHTML='Downloading and installing update...';
	new Ajax.Request('/api/updater/',{
		method:'post',
		parameters:parameters,
		onSuccess:doUpdate_onSuccess,
		onFailure:doUpdate_onFailure
	});
	window.setTimeout(pollForUpdateLog, 1000);
}
function doUpdate_onSuccess(transport){
	if(!transport.responseJSON){
		return doUpdate_onFailure(transport);
	} else if(transport.responseJSON["updaterupdated"]){
		updaterUpdated=true;
		updateFailed=false;
	} else if(transport.responseJSON.success){
		updateCompleted=true;
		updateFailed=false;
	} else {
		return doUpdate_onFailure(transport);
	}
}
function doUpdate_onFailure(transport){
	updateCompleted=false;
	updateFailed=true;
	if(!transport.responseJSON){
			failureResponse=transport.responseText;
	}
}

function pollForUpdateLog(){
	new Ajax.Request('/api/updater/',{
		method:'get',
		parameters:{
			"getupdatelog":"yes"
		},
		onSuccess:writeLogToTab,
		onFailure:writeLogToTab
	});
}
function writeLogToTab(transport){
    let pollInterval=5000;
    let versionTabBody=document.getElementById("version_body");
    if(!transport.responseJSON){
		versionTabBody.innerHTML=transport.responseText;
		window.setTimeout(pollForUpdateLog, pollInterval);
	} else {
		let log=transport.responseJSON.log.replace(/&amp;/g,'&').replace(/&lt;/g,'<').replace(/&gt;/g,'>').replace(/&quot;/g,'"').replace(/<strong/g,'<br/><strong');
		versionTabBody.innerHTML='<div style="font-family:monospace;font-size:120%">'+log+'</div>';
		if(updateFailed){
			if(failureResponse){
				versionTabBody.innerHTML+=failureResponse;
			}
			versionTabBody.innerHTML+='<p><strong style="color:#600">Update failed. Please contact support. The logs above will be really helpful.</strong></p>';
		} else if(updaterUpdated){
			versionTabBody.innerHTML+='<p><strong>Update will continue in a moment, do not leave this page..</strong></p>';
			updaterUpdated=false;
			updateCompleted=false;
			updateFailed=false;
			failureResponse=null;
			window.setTimeout(function(){ doUpdate(true) }, 5000);
			window.setTimeout(pollForUpdateLog, 5500);
		} else if(updateCompleted){
			versionTabBody.innerHTML+='<p><strong style="color:#060">Update complete. Enjoy your new IceBear!</strong></p>';
		} else {
			versionTabBody.innerHTML+='<p><strong>Update in progress, do not leave this page.</strong></p>';
			window.setTimeout(pollForUpdateLog, pollInterval);
		}
	}
	versionTabBody.scrollTop=versionTabBody.scrollHeight;
}

</script>
<?php include realpath(__DIR__).'/../_common/footer.php'; 