<!DOCTYPE html>
<html>
<head>
	<title><?php echo $pageTitle; ?></title>
	<meta charset="utf-8"/>
	<script type="text/javascript" src="/js/prototype1_7_2.js"></script>
	<script type="text/javascript" src="/js/prototype1_7_2_http_fix.js"></script>
	<script type="text/javascript" src="/js/client.js?t=<?php echo @filemtime($wwwroot.'/client/js/client.js'); ?>"></script>
	<script type="text/javascript" src="/js/ui.js?t=<?php echo @filemtime($wwwroot.'/client/js/ui.js'); ?>"></script>
	<script type="text/javascript">
	<?php 
	//Next release
	//$skinName=$userConfig['skin'];
	//$skin=skin::getByName($skinName);
	$skinName="default";
	$skin=array(
	    "name"=>"default",
	    "navbaricontheme"=>"darkicons",
	    "boxheadericontheme"=>"darkicons",
	    "treeheadericontheme"=>"lighticons",
	    "bodyicontheme"=>"darkicons"
	);
	?>
    let nullValue="<?php echo database::$nullValue; ?>";
	var currentUser=<?php echo json_encode(session::getUser()); ?>;
	var username="<?php echo session::getUsername(); ?>";
	var userId=<?php echo session::getUserId(); ?>;
	var csrfToken="<?php echo session::get('csrfToken'); ?>";
	UserConfig.items=<?php echo json_encode($userConfig); ?>;
	var skin=<?php echo json_encode($skin); ?>;
	var skinName=skin.name;
	var theme="light"; //Or dark. LATER From skin metadata. ALSO CHANGE BODY TAG BELOW!
	var helpTexts=<?php echo (isset($helpTexts)) ? json_encode($helpTexts) : 'null' ; ?>;
	var fieldValidations=<?php echo (isset($fieldValidations)) ? json_encode($fieldValidations) : 'null' ; ?>;
	var validationPatterns=<?php echo (isset($validationPatterns)) ? json_encode($validationPatterns) : 'null' ; ?>;
	var submitTimer;
	var data=<?php echo isset($data) ? json_encode($data) : 'null'; ?>;
	var pageTitle="<?php echo $pageTitle ?>";
	var initialHash=document.location.hash;
	<?php if(session::isLoggedIn()){
		$isAdmin=session::isAdmin();
		echo 'var sharedProject='.json_encode(project::getByName(project::SHARED)).";\n";
		echo 'var isAdmin='.($isAdmin?'true':'false').";\n";
		if(null==session::get('isTechnician')){
			try {
				$techniciansGroup=usergroup::getByName(usergroup::TECHNICIANS);
				$isTechnician=usergroup::userisingroup($techniciansGroup['id']);
			} catch (Exception $e){
				$isTechnician=false;	
			}
			session::set('isTechnician', $isAdmin || $isTechnician);
		}
		echo 'var isTechnician='.($isAdmin || session::get('isTechnician')?'true':'false').";\n";
		if(null==session::get('isShipper')){
			try {
				$shippersGroup=usergroup::getByName(usergroup::SHIPPERS);
				$isShipper=usergroup::userisingroup($shippersGroup['id']);
			} catch (Exception $e){
				$isShipper=false;	
			}
			session::set('isShipper', $isAdmin || $isShipper);
		}
		echo 'var isShipper='.($isAdmin || session::get('isShipper')?'true':'false').";\n";
	} ?>
	<?php if(isset($canUpdate)){
		echo 'var canEdit='.($canUpdate ? 'true':'false').";\n"; 
	}  else {
		echo "var canEdit=true; //Default because \$canUpdate was not set by server. Permissions will be enforced server-side.\n";
	}?>
	
	</script>
	<link rel="stylesheet" type="text/css" href="/skins/base.css?t=<?php echo @filemtime($wwwroot.'/client/skins/base.css'); ?>" />
	<link rel="stylesheet" type="text/css" href="/skins/client.css?t=<?php echo @filemtime($wwwroot.'/client/skins/client.css'); ?>" />
	<link rel="stylesheet" type="text/css" href="/skins/<?php echo $skinName; ?>/skin.css?t=<?php echo @filemtime($wwwroot.'/client/skins/'.$skinName.'/'.$skinName.'.css'); ?>" />
</head>
<body>
<div id="container">
<header id="header" class="<?php echo $skin['navbaricontheme']; ?>">
<?php if(session::isLoggedIn()){ ?>
		<a class="control noprint" href="#" onclick="showMenu();return false" title="Menu"><img src="/images/icons/<?php echo $skin['navbaricontheme']; ?>/header/btn_menu.png" alt="Menu"/></a>
		<?php 
		if(isset($objectType) && file_exists($wwwroot.'/client/help/'.$objectType.'/index.php') ){ ?>
			<a class="control noprint" href="/help/<?php echo $objectType; ?>" target="_blank"><img id="helpbutton" src="/images/icons/<?php echo $skin['navbaricontheme']; ?>/header/btn_help.png" title="Get help" alt="Get help"/></a>
		<?php } ?>
		<?php if($hasConfig){ ?>
			<a class="control noprint nosmall" href="#"><img id="configbutton" src="/images/icons/<?php echo $skin['navbaricontheme']; ?>/header/btn_config.png" title="Configure this page" alt="Configure this page"/></a>
		<?php } ?>
		<input class="noprint nosmall" type="text" name="headersearch" id="headersearch" data-classlist="plate,platetype,container,crystal,pdbdeposition" onfocus="HeaderSearchBox.onUpdate(this)" onkeyup="HeaderSearchBox.onUpdate(this,event)" onblur="HeaderSearchBox.stop(this)" placeholder="Find by name..." title="Type a name or scan a barcode" />
<?php } ?>
<script type="text/javascript">
var path=document.location.pathname.substr(1).replace(/\/$/, "");
var breadcrumbs='';
var crumbParts=null;
<?php if(isset($breadcrumbs)){
	echo "crumbParts=".json_encode($breadcrumbs).";\n";
}?>
if(!userId){
	/* No breadcrumbs needed, login page */
} else if(null!=crumbParts){
	breadcrumbs+='<a class="breadcrumb noprint" href="/"><img src="/images/icons/<?php echo $skin['navbaricontheme']; ?>/header/bc_home.png" title="Home" alt="Home"/></a>';
	crumbParts.each(function(part){
		breadcrumbs+='<a class="breadcrumb noprint" href="'+part.url+'"><img src="/images/icons/<?php echo $skin['navbaricontheme']; ?>/header/bc_'+part.icon+'.png" title="'+part.help+'" alt="'+part.icon+'"/></a>';
	});
} else if(''!=path){
	breadcrumbs+='<a class="breadcrumb noprint" href="/"><img src="/images/icons/<?php echo $skin['navbaricontheme']; ?>/header/bc_home.png" title="Home" alt="Home"/></a>';
	path=path.split("/");
	var objType=path[0];
	if(2<=path.length && ''!=path[1]){
		breadcrumbs+='<a class="breadcrumb noprint" href="/'+objType+'/"><img src="/images/icons/<?php echo $skin['navbaricontheme']; ?>/header/bc_'+objType+'.png" title="'+objType+'s" alt="'+objType+'s"/></a>';
	} else {
		<?php if(isset($showCreateLink) && true==$showCreateLink){ ?>
		pageTitle+='&nbsp;&nbsp;&nbsp;&nbsp;<a style="font-size:80%;float:none;" href="/'+objType+'/create">Create new...</a>';
		<?php }?>
	}
}
//document.write('<h1>'+breadcrumbs+'&nbsp;'+pageTitle);
//document.write('</h1>');

document.write(breadcrumbs+'&nbsp;'+'<h1>'+pageTitle+'</h1>');

if(document.getElementById("headersearch")){ 
	document.getElementById("headersearch").focus();
}

$(document).observe("dom:loaded",function(){
	ui.checkForSmallScreen();
	initialHash=initialHash.replace("#","");
	if(initialHash){
		var elem=$(initialHash);
		if(elem && elem.hasClassName("tab")){
			elem.click();
		}
	}
	window.setTimeout(ui.smallScreenInit,100);	
});

</script>
</header>
<div id="content">
