let ui={
		
		//How many records to retrieve in paginated queries
		defaultPageSize:25,
		
		daysOfWeek:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],
		monthsOfYear:["January","February","March","April","May","June","July","August","September","October","November","December"],

		forceReload:function(){
			let f=document.createElement("form");
			f.action=window.document.location;
			f.method="post";
			document.body.appendChild(f);
			f.submit();
		},

		errorMessageBar:function(msg, parent){
			return ui._messageBar(msg,'errorbar',parent);
		},
		warningMessageBar:function(msg, parent){
			return ui._messageBar(msg,'warningbar',parent);
		},
		infoMessageBar:function(msg, parent){
			return ui._messageBar(msg,'infobar',parent);
		},
		_messageBar:function(msg,cssClass,parent){
			let bar=document.createElement("div");
			bar.className="msgbar "+cssClass;
			bar.innerHTML=msg;
			if(null!=parent){ parent.appendChild(bar); }
			return bar;
		},

		/************************************************
		 * REPLACEMENT FOR PROTOTYPE FUNCTIONS
		 * Avoid using these.
		 ************************************************/

		/**
		 * Returns the total offset from the top left of the document.
		 * @param elem
		 * @returns {{top: number, left: number}}
		 */
		cumulativeOffset:function (elem) {
			let clientRect = elem.getBoundingClientRect();
			return {
				left: clientRect.left + document.body.scrollLeft,
				top: clientRect.top + document.body.scrollTop
			};
		},

		/**
		 * Returns the element's offset from its closest positioned ancestor
		 * @param elem
		 * @returns {{top: number, left: number}}
		 */
		positionedOffset:function (elem){
			return {
				top: elem.offsetTop,
				left:elem.offsetLeft
			}
		},



		unescapeHTML:function(str) {
			let doc = new DOMParser().parseFromString(str, "text/html");
			return doc.documentElement.textContent;
		},


		/**
		 * Renders a box inside the parent element. If parent is not specified, it will default to document.getElementById("grid"), then document.getElementById("content");
		 * @param box An object containing some of the following keys:
		 * - id The box ID
		 * - classes A space-separated list of CSS classes to apply to the box
		 * - title The box title. If not present, the box will have no header
		 * - content HTML for the box body. Should not be used with "url" option
		 * - url The API url to fetch content for the box
		 * - pageSize How many records to fetch at a time, default is ui.defaultPageSize
		 * - sortBy The property name on which to sort
		 * - sortDescending If true, sort descending
		 * - headers Headers for contained table, see ui.table
		 * - showFilters Whether to show the filter box for each table column
		 * - cellTemplates Cell templates for contained table, see ui.table
		 * - sortOrders Sort order info for columns in contained table, see ui.table
		 * @param parent The parent element
		 */
		box:function(box, parent){
			let b=document.createElement("div");
			b.classList.add("box");
			let boxid='box'+Math.floor(1000000*Math.random());
			if(box.id){ boxid=box.id; }
			b.id=boxid;
			if(box.classes){ b.classList.add(...box.classes.split(" ")); }
			if(box.title){ 
				let h2=document.createElement("h2");
				h2.classList.add(skin["boxheadericontheme"]);
				h2.innerHTML=box.title;
				b.appendChild(h2);
			} else {
				b.classList.add("noheader");
			}
			let bb=document.createElement("div")
			bb.classList.add("boxbody");
			bb.classList.add(skin["bodyicontheme"]);
			b.appendChild(bb);
			let content='';
			if(box.url){
				bb.dataset.apiurl=box.url;
				if(box.sortBy){ 
					bb.dataset.sortby=box.sortBy;
					if(box.sortDescending){
						bb.dataset.sortdescending=box.sortDescending+"";
					}
				}
				bb.dataset.pagesize=box.pageSize || ui.defaultPageSize;
				bb.dataset.pagenumber="1";
				content='Loading...';
			} else if(box.content){
				content=box.content;
			}
			bb.innerHTML=content;
			b.table=function(tbl,data){ return ui.table(tbl,data,boxid); };
			b.form=function(frm){ return ui.form(frm,b); };
			b.treeItem=function(item){ return ui.treeItem(item,b); };
			bb.table=function(tbl,data){ return ui.table(tbl,data,boxid); };
			bb.form=function(frm){ return ui.form(frm,b); };
			bb.treeItem=function(item){ return ui.treeItem(item,b); };
			if(null!=parent){
				if("string"===typeof parent){ parent=document.getElementById(parent); }
				parent.appendChild(b);
			}
			if(box.url){
				let successHandler=function(transport){
					b.table({ headers:box.headers, cellTemplates:box.cellTemplates, showFilters:box.showFilters, sortOrders:box.sortOrders }, transport.responseJSON);
				};
				if(box.successHandler){ successHandler=box.successHandler; }
				if(box.url.indexOf("?")>1){
					box.url+="&";
				} else {
					box.url+="?";
				}
				box.url+="pagenumber=1&pagesize="+bb.dataset.pagesize;
				if(box.sortBy){
					box.url+="&sortby="+box.sortBy;
					if(box.sortDescending){
						box.url+="&sortdescending=1";
					}
				}
				new Ajax.Request(box.url,{
						method:'get',
						onSuccess:function(transport){ successHandler(transport, b)},
						onFailure:function(transport){ ui.defaultFailureHandler(transport, b)}
				});
			}
			return bb;
		},
		
		/**
		 * Open a modal box with the specified title and content. If needed, a function to call on close can be specified.
		 * 
		 * Parameters: As for ui.box (title and content are most interesting here), plus optionally confirmClose or onclose.
		 * 
		 * title: The title of the box
		 * content: The content of the box
		 * confirmClose: if document.getElementById("modalBox").tainted===true at close, call ui.confirmCloseModalBox on close. The onclose option overrides this.
		 * onclose: A custom function called when the box is closed. It should return true if the box can be close, false otherwise. Overrides confirmClose.
		 */
		modalBox:function(box){
			let mw=document.getElementById("modalWindow");
			if(!mw){
				document.body.innerHTML+='<div id="modalWindow"><div id="modalBackground"></div><div id="modalContent" onclick="ui.closeModalBox()"></div></div>';
			}
			if(document.getElementById('modalBox')){ document.getElementById('modalBox').remove(); }
			if(document.getElementById('modalTabSet')){ document.getElementById('modalTabSet').remove(); }
			box.id="modalBox";
			let mbox=ui.box(box,'modalContent');
			let mb=document.getElementById("modalBox");
			mb.querySelector("h2").innerHTML='<span>'+mb.querySelector("h2").innerHTML+'</span>';
			mb.querySelector("h2").innerHTML='<img alt="Close" id="modalboxclose" onclick="ui.closeModalBox()" '+
				'style="cursor: pointer; height:2em; position:absolute; right:0.25em; top:0;" '+'' +
				'src="/images/icons/'+skin["boxheadericontheme"]+'/close.gif" /></div>'+
				mb.querySelector("h2").innerHTML;
			mw.style.display="block";
			if(box.onclose){ 
				mw.closeCallback=box.onclose;
			} else if(box.confirmClose){
				mw.closeCallback=ui.confirmCloseModalBox;
			}
			mb.tainted=false;
			document.addEventListener("keyup",ui.checkForCloseModalBoxEscapeKey);
			return mbox;
		},
		
		setModalBoxTitle:function(title){
			let mb=document.getElementById("modalBox");
			if(!mb){ return; }
			mb.querySelector("h2 span").innerHTML=title;
		},

		logToDialog:function(message, type){
			let mb=document.getElementById("modalBox");
			if(!mb){
				mb=ui.modalBox({ "title":"Log messages" })
			}
			if("success"===type){
				message='<span style="font-weight:bold;color:#090">'+message+'</span>';
			}if("error"===type || "failure"===type){
				message='<span style="font-weight:bold;color:#900">'+message+'</span>';
			}
			mb.querySelector(".boxbody").innerHTML+='<br/>'+message;
		},

		modalTabSet:function(tabSet){
			if(!tabSet){ tabSet={}; }
			let mw=document.getElementById("modalWindow");
			if(!mw){
				document.body.innerHTML+='<div id="modalWindow"><div id="modalBackground" onclick="ui.closeModalBox()"></div><div id="modalContent" onclick="ui.closeModalBox()"></div></div>';
			}
			if(document.getElementById('modalBox')){ document.getElementById('modalBox').remove(); }
			if(document.getElementById('modalTabSet')){ document.getElementById('modalTabSet').remove(); }
			mw.style.display="block";
			document.addEventListener("keyup",ui.checkForCloseModalBoxEscapeKey);
			let ts=ui.tabSet({ id:'modalTabSet' }, document.getElementById('modalContent'));
			let t =document.createElement("h2");
			t.classList.add("tab","close");
			t.innerHTML='Close';
			t.onclick=ui.closeModalBox;
			if(tabSet.onclose){
				mw.closeCallback=tabSet.onclose;
			} else if(tabSet.confirmClose){
				mw.closeCallback=ui.confirmCloseModalBox;
			}
			ts.appendChild(t);
			return ts;
		},
		
		checkForCloseModalBoxEscapeKey:function(evt){
			if(27===evt.keyCode){ ui.closeModalBox(); }
		},
		
		/**
		 * Closes a modal box. If onclose or confirmClose was specified and returns false, the box will not close.
		 */
		closeModalBox:function(){
			let mw=document.getElementById("modalWindow");
			if(mw.closeCallback && !mw.closeCallback()){ return false; }
			mw.querySelector("#modalBox,#modalTabSet").remove();
			mw.style.display="none";
			document.stopObserving("keyup",ui.checkForCloseModalBoxEscapeKey);
		},
		
		/**
		 * Default "confirm close" function for modal box. Returns true if document.getElementById("modalBox").tainted evaluates to false or the user confirms close.
		 * Specify this behaviour with confirmClose:true in the original call to ui.modalBox().
		 */
		confirmCloseModalBox:function(){
			if(false===document.getElementById("modalBox").tainted){ return true; }
			return confirm("Really close this box?");
		},
		

		tabSet:function(tabSet, parent){
			let ts=document.createElement("div");
			ts.classList.add("tabset");
			if(tabSet.id){ ts.id=tabSet.id; }
			if(tabSet.classes){ ts.classList.add(...tabSet.classes.split(" ")); }
			if(null!=parent){ parent.appendChild(ts);}
			let tw=document.createElement("div");
			tw.classList.add("tabwrapper");
			ts.appendChild(tw);
			ts.tab=function(tab){ return ui.tab(tab,ts); };
			ts.filesTab=function(relatedObjectIds){ return ui.filesTab(ts,relatedObjectIds); };
			ts.notesTab=function(idOverride){ return ui.notesTab(ts,idOverride); };
			ts.startTab=document.location.hash.substr(1);
			return ts;
		},
		
		tab:function(tab,parent){
			let t =document.createElement("h2");
			if(tab.classes){ t.className=tab.classes; }
			t.classList.add("tab");
			t.innerHTML=tab.label;
			if(!tab.disabled){  t.addEventListener("click", ui.clickTab); }
			if(tab.callback && !tab.disabled){  t.addEventListener("click", tab.callback); }
			let tb=document.createElement("div");
			tb.classList.add("tabbody");
			tb.classList.add(skin["bodyicontheme"]);
			if(tab.disabled){
				t.classList.add("disabledtab");
			} else {
				t.classList.add("enabledtab");
			}
			let content='';
			if(tab.url){
				content='Loading...';
				tb.dataset.apiurl=tab.url;
				tb.dataset.pagesize=tab.pageSize || ui.defaultPageSize;
				tb.dataset.pagenumber="1";
				if(tab.sortBy){ 
					tb.dataset.sortby=tab.sortBy;
					if(tab.sortDescending){
						tb.dataset.sortdescending=tab.sortDescending;
					}
				}
				
			} else if(tab.renderer){
				content='Loading...';
				tb.dataset.apiurl=tab.url;
				tb.dataset.pagesize=tab.pageSize || ui.defaultPageSize;
				tb.dataset.pagenumber="1";
				tb.renderer=tab.renderer;
			} else if(tab.content){
				content=tab.content;
			}
			tb.innerHTML=content;
			if(tab.id){
				t.id=tab.id;
				tb.id=tab.id+"_body";
			}
			if(null!=parent){ 
				parent.appendChild(t);
				parent.appendChild(tb);
				if(!parent.querySelector("h2.current") || t.id===parent.startTab){ t.click(); }
			}
			t.table=function(tbl,data){ return ui.table(tbl,data,tb); };
			t.form=function(frm){ return ui.form(frm,tb); };
			t.treeItem=function(item){ return ui.treeItem(item,tb); };
			t.refresh=function(){ return ui.refreshTab(tb); };
			tb.table=function(tbl,data){ return ui.table(tbl,data,tb); };
			tb.form=function(frm){ return ui.form(frm,tb); };
			tb.treeItem=function(item){ return ui.treeItem(item,tb); };
			tb.refresh=function(){ return ui.refreshTab(tb); };

			t.warn=function(text) { return ui.addTabWarning(t, text)};
			tb.warn=function(text) { return ui.addTabWarning(t, text)};
			t.unwarn=function() { return ui.removeTabWarning(t)};
			tb.unwarn=function() { return ui.removeTabWarning(t)};

			if(tb.renderer){
				tb.renderer(tb);
			} else if(tab.url){
				tb.successHandler=function(transport){
					t.table({ headers:tab.headers, cellTemplates:tab.cellTemplates, contentBefore:tab.contentBefore, sortOrders:tab.sortOrders }, transport.responseJSON);
				};
				if(tab.successHandler){ tb.successHandler=tab.successHandler; }
				tb.failureHandler=function(transport){ ui.defaultFailureHandler(transport, tb)};
				if(tab.failureHandler){ tb.failureHandler=tab.failureHandler; }
				if(tab.url.indexOf("?")>0){
					tab.url+="&";
				} else {
					tab.url+="?";
				}
				tab.url+="pagenumber=1&pagesize="+tb.dataset.pagesize;
				if(tab.sortBy){
					tab.url+="&sortby="+tab.sortBy;
					if(tab.sortDescending){
						tab.url+="&sortdescending=1";
					}
				}
				tb.url=tab.url;
				ui.refreshTab(t);
			}
			return t;
		},

		addTabWarning:function(tabHeader, warningText){
			tabHeader.classList.add("warning");
			tabHeader.title=warningText;
		},

		removeTabWarning:function(tabHeader){
			tabHeader.classList.remove("warning");
			tabHeader.title="";
		},

	refreshTab:function(tab){
			if(!tab.classList.contains("tabbody")){
				tab=tab.nextElementSibling;
				if(!tab.classList.contains("tabbody")){
					alert("refreshTab called on something that was not a tab");
					return false;
				}
			}
			if(tab.renderer){
				tab.innerHTML="Loading...";
				tab.renderer();
			} else if(tab.url){
				tab.innerHTML="Loading...";
				new Ajax.Request(tab.url,{
					method:'get',
					onSuccess:function(transport){ tab.successHandler(transport, tab)},
					onFailure:function(transport){ tab.failureHandler(transport, tab)}
				});
			} else {
				return false;
			}
		},
		
		clickTab:function(evt){
			let t=evt.target;
			ui.selectTab(t);
		},
		selectTab:function(t){
			if(t.classList.contains("disabledtab")){ return; }
			let ts=t.closest(".tabset");
			let tabs=ts.querySelectorAll(".tab");
			tabs.forEach(function(tab){ 
				tab.classList.remove("current");
			});
			t.classList.add("current");
		},
		
		filesTab: function(ts, relatedObjectIds){
			if(data["projectname"] && 'Default Project'===data["projectname"]){
				//Not a project view because data["projectname"] is present
				ts.tab({
					'id':'files',
					'label':'Files',
					'content':'Set the protein first',
				});
				return false; 
			}

			ui.fileTabHeaders=['File','Description','Size'];
			ui.fileTabTemplates=[ '<a class="filelink" target="_blank" href="/api/file/{{id}}/{{filename}}">{{filename}}</a>','{{description}}','{{bytes}}'];
			let afterFilesTab=function(){
				let canWrite=canEdit || canWriteInProject;
				let fb=document.getElementById("files_body");
				if(!canWrite){
					if(!fb.querySelector("a.filelink")){
						fb.querySelector("table").innerHTML+='<tr><td colspan="'+ui.fileTabHeaders.length+'">No files</td></tr>';
					}
					return;
				}
				fb.querySelector("table").innerHTML+='<tr>'+
					'<td><input type="file" name="file"></td>'+
					'<td><input type="text" name="description" placeholder="Description"></td>'+
					'<td><input type="button" name="addfile" id="addfile" value="Add file" onclick="if(0!==this.closest(\'form\').querySelector(\'[type=file]\').files.length){ ui.submitForm(this) }"></td>'+
					'</tr>';
				let hiddenFields='<input type="hidden" name="csrfToken" value="'+csrfToken+'" /><input type="hidden" name="parentid" value="'+data.id+'" />';
				if("project"===data["objecttype"]){
					hiddenFields='<input type="hidden" name="csrfToken" value="'+csrfToken+'" />'+
						'<input type="hidden" name="parentid" value="'+nullValue+'" />'+
						'<input type="hidden" name="projectid" value="'+data.id+'" />';
				}
				fb.innerHTML+='<form class="noprint" action="/api/file" id="files_form" method="post" enctype="multipart/formdata" onsubmit="return false;">'+
						hiddenFields+'</form>';
				document.getElementById("addfile").options={
					afterSuccess:function(){
						fb.refresh();
					}
				};
				document.getElementById("files_form").appendChild(fb.querySelector("table"));

				/*
				 * Get files for any related object IDs that were passed in
				 */
				let relatedIds=document.getElementById("files").relatedObjectIds;
				if(!relatedIds){ relatedIds=[]; }
				relatedIds=[0].concat(relatedIds);
				for(let i=0;i<relatedIds.length;i++){
					let relatedId=parseInt(relatedIds[i]);
					if(0===relatedId){ continue; }
					new Ajax.Request('/api/baseobject/'+relatedId+'/file', {
						method:'get',
						onSuccess:function(transport){
							transport.responseJSON.rows.forEach(function(f){
								if(""===f.name && ""!==f.filename){ f.name=f.filename; }
								let row='<tr><td>'+ui.fileTabTemplates.join('</td><td>')+'</td></tr>';
								row=row.replace("{{id}}",f.id);
								row=row.replaceAll("{{filename}}",f.filename);
								row=row.replace("{{description}}",f.description);
								row=row.replace("{{bytes}}",f["bytes"]);
								document.getElementById("files_body").querySelector("tr").innerHTML+=row;
							});
						},
						onFailure:function(transport){
							//nothing to do
						}
					});
				}
			};

			let filesUrl='/api/baseobject/'+data.id+'/file';
			if("project"===data['objecttype']){
				filesUrl='/api/project/'+data.id+'/file';
			}
			let t=ts.tab({
				'id':'files',
				'label':'Files',
				'url':filesUrl,
				'pageSize':10000,
				'headers':ui.fileTabHeaders,
				'cellTemplates':ui.fileTabTemplates,
				'successHandler':function(transport){
					document.getElementById("files_body").table({ headers:ui.fileTabHeaders, cellTemplates:ui.fileTabTemplates }, transport.responseJSON);
					afterFilesTab();
				},
				'failureHandler':function(){
					//Failure is almost certainly "No files" so just render an empty table
					let tr=document.createElement("tr");
					tr.innerHTML="<th>"+ui.fileTabHeaders.join("</th><th>")+"</th>";
					let tbl=document.createElement("table");
					tbl.appendChild(tr);
					let fb=document.getElementById("files_body");
					fb.classList.add("hastable");
					fb.innerHTML="";
					fb.appendChild(tbl);
					afterFilesTab();
				}
			});
			t.relatedObjectIds=relatedObjectIds;
			return t;
		},
		
		noteFormTemplate:'<form id="notesform" method="post" class="noprint">'+
			'<input type="hidden" name="projectid" value="{{projectid}}"/>'+
			'<input type="hidden" name="parentid" value="{{parentid}}"/>'+
			'<input type="hidden" name="csrfToken" value="{{csrfToken}}"/>'+
			'<label style="position:relative;top:0;padding:0.25em 0.5em;margin-bottom:0.5em"><textarea style="width:100%;height:5em" name="text" id="text" placeholder="Add a note..."></textarea><input type="button" onclick="ui.addNote(this)" value="Add note"/><div style="clear:both"></div></label></form>',

		noteTemplate:'<a href="/user/{{userid}}">{{username}}</a>, {{createtime}}:<br/><div style="line-height:1.25em;margin-bottom:0.5em">{{text}}</div>',

		notesTab:function(ts, parentId){
			let notesUrl='';
			let projectId=nullValue;
			if('project'!==data['objecttype'] && (!data["projectname"] || 'Default Project'===data["projectname"])){
				ts.tab({
					'id':'notes',
					'label':'Notes',
					'content':'This item is in the default project, so notes cannot be added. If you have permission to do so, you should move it to a real working project.',
				});
				return false; 
			}
			if('project'===data['objecttype']){
				parentId=nullValue;
				projectId=data['id'];
				notesUrl='/api/project/'+projectId+'/note';
			} else if(!parentId){
				parentId=data['id'];
			}

			if(''===notesUrl){
				notesUrl='/api/baseobject/'+parentId+'/note';
			}

			let noteForm=ui.noteFormTemplate.replace('{{projectid}}', projectId).replace('{{parentid}}', parentId).replace('{{csrfToken}}',csrfToken);
			let canWrite=canEdit || canWriteInProject;

			let t=ts.tab({
				'id':'notes',
				'label':'Notes',
				'url':notesUrl,
				'pageSize':100000,
				'cellTemplates':[ [ui.processNoteTemplate,'id'] ],
				'contentBefore': canWrite ? noteForm : '',
				'failureHandler':function(){ t.nextElementSibling.innerHTML=canWrite ? noteForm : 'No notes'; }
			});
			return t;
		},
		processNoteTemplate: function(note){
			let t=""+ui.noteTemplate;
			t=t.replace("{{createtime}}", ui.friendlyDate(note["createtime"]) );
			note.text=ui.urlifyAndBreakNoteText(note.text);
			let regex=/{{[().a-zA-Z0-9_-]+}}/g;
			let found=t.match(regex);
			if(found){
				found.forEach(function(f){
					let prop=f.slice(2,-2);
					t=t.replace(f,note[prop]);
				});
			}
			return t +"";
		},
		urlifyAndBreakNoteText:function(txt){
			txt=txt.replace(/(http[s]?:[^\s]+[^.\s,!?]+)/g,'<a href="$&">$&</a>');
			txt=txt.replace(/(?:\r\n|\r|\n)/g,"<br/>");
			return txt;
		},
		addNote: function(btn){
			let nf=btn.closest("form");
			if(""===nf.querySelector("[name=text]").value.trim()){
				//Note is blank
				return false;
			}
			btn.closest("label").classList.add("updating");
			btn.options={
				afterSuccess:function(){
					btn.closest(".tabbody").refresh();
				}
			};
			nf.action='/api/note';
			nf.method='post';
			nf.querySelector('[name=csrfToken]').value=csrfToken;
			ui.submitForm(btn);
		},
		
		/**
		 * Writes a table template into the parent element and populates it with the supplied data.
		 * @param tbl An object describing the table, with some of the following properties:
		 * - contentBefore HTML to insert at the top of the table
		 * - headers An array of column headers (required)
		 * - cellTemplates An array of templates for each cell in a row (required). A function can be passed, see below.
		 * - showFilters An array of booleans, whether to show a filter box for each column.
		 * - sortOrders An array, if present must be same length as headers. "" is non-sortable column, "name" sorts by name ascending on first click, "-name" sorts by name descending on first click.
		 * Passing functions into cell templates: Pass an array of function name and (optionally) the property, for example [ui.checkmark, 'isactive']. When
		 * defining custom functions for use in this way, the function should take the data row and (optionally) the field name as arguments. It should return the HTML to insert into the table cell.
		 * @param tableData The JSON data to be rendered
		 * @param parent The parent element of the new table
		 * @return the table element
		 */
		table:function(tbl,tableData,parent){
			if("string"===typeof parent){ parent=document.getElementById(parent); }
			if(parent.querySelector(".boxbody")){ parent=parent.querySelector(".boxbody"); }
			if(parent.classList.contains("tab")){ parent=parent.nextElementSibling; }
			let t=document.createElement("table");
			if(tbl.id){
				t.id=tbl.id; 
			} else if(null!=parent){
				t.id=parent.id+"_table";
			} else {
				t.id="table"+Math.floor(1000000*Math.random());
			}
			t.className="uitable";
			t.cellTemplates=tbl.cellTemplates;
			t.hasNoMore=false;

			if(tbl.contentBefore){
				let rowBefore=document.createElement("tr");
				rowBefore.className="beforetable headerrow";
				let tdBefore=document.createElement("td");
				tdBefore.colSpan=tbl.cellTemplates.length;
				if(tbl.headers){ tdBefore.colSpan=tbl.headers.length; }
				tdBefore.innerHTML=tbl.contentBefore;
				rowBefore.appendChild(tdBefore);
				t.appendChild(rowBefore);
			}

			if(null!=tbl.headers && 0!==tbl.headers.length){
				let tr=document.createElement("tr");
				tr.className="headerrow";
				let hasSortOrders=false;
				if(null!=tbl.sortOrders && 0!==tbl.sortOrders.length){
					if(tbl.sortOrders.length!==tbl.headers.length){
						let rowBefore=document.createElement("tr");
						rowBefore.className="beforetable headerrow";
						let tdBefore=document.createElement("td");
						tdBefore.colSpan=tbl.headers.length;
						tdBefore.innerHTML='<div class="warning">Warning: Header and sort-order array are not the same length</div>';
						rowBefore.appendChild(tdBefore);
						t.appendChild(rowBefore);
					} else {
						hasSortOrders=true;
					}
				}

				let count=0;
				let showSort=hasSortOrders;
				if(tableData.rows && 1===tableData.rows.length){ showSort=false; }
				if(tableData.data && 1===tableData.data.length){ showSort=false; }
				tbl.headers.forEach(function(h){
					let th=document.createElement("th");
					if(showSort&& ''!==tbl.sortOrders[count]){
						let so=tbl.sortOrders[count];
						th.classList.add("sortable");
						if(0===so.indexOf("-")){
							//first click should sort descending
							th.dataset.sortby=so.substr(1);
							th.dataset.sortdescending="1";
							th.innerHTML='<span>'+h+'</span>';
						} else {
							//first click should sort ascending
							th.dataset.sortby=so;
							th.dataset.sortdescending="0";
							th.innerHTML='<span>'+h+'</span>';
						}
						if(parent.dataset.sortby===th.dataset.sortby){
							if(1*parent.dataset.sortdescending){
								th.classList.add("sorteddescending");
							} else {
								th.classList.add("sortedascending");
							}
						}
						th.onclick=ui.sortTable;
					} else {
						th.innerHTML='<span>'+h+'</span>';
					}
					count++;
					tr.appendChild(th);
				});
				t.appendChild(tr);
			}

			if(null!=tbl.showFilters && 0!==tbl.showFilters.length){
				let tr=document.createElement("tr");
				tr.className="filterrow";
				for (let i=0; i<tbl.cellTemplates.length; i++){
					let td=document.createElement("td");
					if(tbl.showFilters[i]){
						let fb=document.createElement("input");
						fb.type="text";
						fb.placeholder="Filter...";
						fb.onkeyup=ui.filterTable;
						fb.onblur=ui.filterTable;
						fb.dataset.tdIndex=""+i;
						td.appendChild(fb);
					}
					tr.appendChild(td);
				}
				t.appendChild(tr);
			}


			let moreTr=document.createElement("tr");
			moreTr.className="listmore noprint";
			moreTr.id=t.id+"_more";
			let moreTd=document.createElement("td");
			moreTd.colSpan=t.cellTemplates.length;
			if(ui.isSmallScreen){
				moreTd.innerHTML='<a href="#" onclick="ui.lazyLoad(this.closest(\'table\'));return false">See more</a>';
			} else {
				moreTd.innerHTML="Loading...";
			}
			moreTr.appendChild(moreTd);
			t.appendChild(moreTr);
			if(null!=parent){
				parent.innerHTML="";
				parent.appendChild(t);
				parent.classList.add("hastable");
				parent.tableHeaders=tbl.headers;
				parent.tableCellTemplates=tbl.cellTemplates;
				parent.tableSortOrders=tbl.sortOrders;
				parent.tableShowFilters=tbl.showFilters;
				parent.tableContentBefore=tbl.contentBefore;
			}
			
			if(tableData.rows){
				tableData=tableData.rows;
			} else if(tableData.data) {
				tableData=tableData.data;
			}
			ui.renderTableRows(t, tableData);

			if(null!=parent && tableData.length>=parent.dataset.pagesize){
				if(ui.isSmallScreen){
					
				} else {
					window[parent.id+"_lazyload"]=function(){ ui.lazyLoad(t) };
					window.setInterval(window[parent.id+"_lazyload"], 1000);
				}
			}
			t.updating=false;
			return t;
		},

		/**
		 * Adds the specified items to an existing table as table rows, using the table's row templates.
		 * @param tbl The table
		 * @param items The items to add.
		 */
		renderTableRows:function(tbl, items){
			let loadRow=tbl.querySelector("tr.listmore");
			let regex=/{{[().a-zA-Z0-9_-]+}}/g;
			let container=tbl.parentElement;
			let newRows=[];
			let numItems=items.length;
			for(let i=0;i<numItems;i++){
				let row=items[i];
				if("object"!==(typeof row).toLowerCase()){ continue; }
				let cells=[];
				tbl.cellTemplates.forEach(function(ct){
					if(ct instanceof Array && 2===ct.length){
						if(typeof(ct[0])!=='function'){
							cells.push('[Array]');
						} else {
							//call the function, with object and property name as args
							cells.push( ct[0](row, ct[1]) )
						}
					} else {
						cells.push(ct.trim());
					}
				});
				let tr=document.createElement("tr");
				tr.className="datarow";
				cells.forEach(function(c){
					let td=document.createElement("td");
					let found=c.match(regex);
					if(found){
						found.forEach(function(f){
							let prop=f.slice(2,-2);
							c=c.replace(f,row[prop]);
						});
					}
					td.innerHTML=c;
					tr.appendChild(td);
				});
				tr.rowData=row;
				newRows.push(tr);
				tbl.appendChild(tr);
				tbl.appendChild(loadRow);
			}
			let filters=ui.getTableFilters(tbl);
			newRows.forEach(function(tr){
				ui.filterTableRow(tr,filters);
			});

			if(!container.dataset || !container.dataset.pagesize || items.length<container.dataset.pagesize){
				//there won't be another page, so
				tbl.hasNoMore=true;
				loadRow.remove();
			}
			tbl.updating=false;
		},

		sortTable:function(evt){
			let header=evt.target.closest("th");
			let container=header.closest(".boxbody,.tabbody");
			container.dataset.pagenumber="1";
			if(container.dataset.sortby===header.dataset.sortby){
				container.dataset.sortdescending=""+Math.abs(container.dataset.sortdescending-1); //toggle between 0 and 1
			} else {
				container.dataset.sortby=header.dataset.sortby;
				container.dataset.sortdescending=header.dataset.sortdescending;
			}
			let uri=container.dataset.apiurl;
			if(uri.indexOf("?")>1){
				uri+="&";
			} else {
				uri+="?";
			}
			uri+="pagenumber="+container.dataset.pagenumber+"&pagesize="+container.dataset.pagesize;
			uri+="&sortby="+container.dataset.sortby+"&sortdescending="+container.dataset.sortdescending;
			container.tableFilters=ui.getTableFilters(header.closest("table"));
			container.innerHTML="Loading...";
			new Ajax.Request(uri,{
				method:"get",
				onSuccess:function(transport){
					let tbl=container.table({
						headers:container.tableHeaders, 
						cellTemplates:container.tableCellTemplates, 
						sortOrders:container.tableSortOrders,
						showFilters:container.tableShowFilters,
						contentBefore:container.tableContentBefore
					},
					transport.responseJSON);
					let filterRow=tbl.querySelector("tr.filterrow");
					let filtered=false;
					if(container.tableFilters && filterRow){
						let count=0;
						filterRow.querySelectorAll("th,td").forEach(function(cell){
							let inp=cell.querySelector("input");
							if(inp){
								inp.value=container.tableFilters[count];
								if(""!==inp.value){
									filtered=true;
								}
							}
							count++;
						});
					}
					container.filters=null;
					if(filtered){
						window.setTimeout(function(){
							ui._doFilterTable(filterRow.querySelector("input"));
						},50);
					}
				},
				onFailure:function(transport){
					container.innerHTML='Could not get data from server.';
					AjaxUtils.checkResponse(transport);
				}
			})
		},

		filterTimeout:null,

		filterTable:function(evt) {
			window.clearTimeout(ui.filterTimeout);
			let inp = evt.target;
			ui.filterTimeout=window.setTimeout(function(){
				ui._doFilterTable(inp);
			}, 500);
		},
		_doFilterTable:function(inp){
			let tbl=inp.closest("table");
			let rows=tbl.querySelectorAll("tr.datarow");
			let filters=ui.getTableFilters(tbl);
			rows.forEach(function(tr){
				ui.filterTableRow(tr,filters);
			});
		},
		getTableFilters:function(tbl){
			let filters=[];
			let filterRow=tbl.querySelector("tr.filterrow");
			if(!filterRow){ return false; }
			filterRow.querySelectorAll("th,td").forEach(function(cell){
				let box=cell.querySelector("input");
				if(box) {
					filters.push(box.value);
				} else {
					filters.push("");
				}
			});
			return filters;
		},
		filterTableRow:function(tr,filters){
			let numFilters=filters.length;
			if(!filters){ numFilters=0; }
			for(let i=0; i<numFilters; i++) {
				let filter = filters[i].toLowerCase();
				if ("" === filter) {
					continue;
				}
				let cell = tr.querySelectorAll("th,td")[i];
				if(cell.innerText.toLowerCase().indexOf(filter)===-1){
					tr.hide();
					return;
				}
			}
			tr.show();
		},

		lazyLoad:function(tbl){
			let pixelBuffer=100; //start lazy load when "loading" row is this many pixels below bottom edge of container
			if(!document.getElementById(tbl.id) || !tbl.parentElement || tbl.updating || tbl.hasNoMore || !tbl.querySelector("tr.listmore")){ return false; }
			if(tbl.closest(".tabwrapper") && !tbl.closest(".tabwrapper").previousElementSibling.classList.contains("current")){
				//Table is in a tab but tab is not current, so...
				return false; 
			}
			if(tbl.querySelector("tr.listmore").viewportOffset().top-pixelBuffer>(tbl.parentElement.viewportOffset().top+tbl.parentElement.getHeight())){
				//loading row not visible, so...
				return false;
			}
			tbl.updating=true;
			let container=tbl.parentElement;

			container.dataset.pagenumber=((1*container.dataset.pagenumber)+1)+"";
			let pageNumber=1*container.dataset.pagenumber;
			let pageSize=1*container.dataset.pagesize;
			let url=container.dataset.apiurl;
			if(url.indexOf("?")>0){
				url+="&";
			} else {
				url+="?";
			}
			url+="pagesize="+pageSize+"&pagenumber="+pageNumber;
			if(container.dataset.sortby){
				url+="&sortby="+container.dataset.sortby+"&sortdescending="+container.dataset.sortdescending;
			}
			new Ajax.Request(url,{
				method:"get",
				onSuccess:function(transport){ ui.lazyLoad_onSuccess(tbl,transport); },
				onFailure:function(transport){ ui.lazyLoad_onFailure(tbl,transport); },
			});
		},
		lazyLoad_onSuccess:function(tbl,transport){
			ui.renderTableRows(tbl, transport.responseJSON.rows);
		},
		lazyLoad_onFailure:function(tbl,transport){
			tbl.hasNoMore=true;
			let lastRow=tbl.querySelector("tr.listmore");
			if(404===transport.status){
				lastRow.remove();
			} else if(401===transport.status){
				ui.handleSessionExpired();
			} else if(transport.responseJSON && transport.responseJSON.error){
				lastRow.innerHTML=transport.responseJSON.error;
			} else {
				lastRow.innerHTML="There was an error. The server said:\n\n"+transport.responseText;
			}
		},
		
		/**
		 * Generates a grid wrapper inside the document body.
		 * @param showSlots Whether to generate light boxes in the background to show empty spaces in the grid. Default false. 
		 * @param gridId The HTML id of the grid wrapper. Default "grid".
		 * @return the grid wrapper element.
		 */
		grid:function(showSlots, gridId){
			let slots='';
			if(!gridId){ gridId="grid"; }
			if(showSlots){
				slots=ui.gridSlots();
			}
			let out='<div class="grid" id="'+gridId+'">'+slots+'</div>';
			document.getElementById("content").innerHTML+=out;
			let grid=document.getElementById(gridId);
			grid.box=function(box){ return ui.box(box,grid); };
			grid.tabSet=function(tabSet){ return ui.tabSet(tabSet,grid); };
			return grid;
		},
		gridSlots:function(){
			let slots="";
			for(let r=1;r<=3;r++){
				for(let c=1;c<=3;c++){
					slots+='<div class="noprint boxslot r'+r+' c'+c+'" data-gridrow="'+r+'" data-gridcol="'+c+'"></div>';
				}	
			}
			return slots;
		},


		/**
		 * Writes a tree node. 
		 * {
		 * 	id: The id of the header. The body will have the same ID plus "_body".
		 *  record: The object represented by this tree item. May be used by the updater, for example.
		 *  updater: A function to generate and insert the body content. It should expect the tree item header as a parameter.
		 *  header: The title shown on the tree node.
		 *  content: Static HTML content to use instead of an updater function.
		 *  url: Optional URL for AJAX request, by default writes table
		 *  headers: Array of table headers after AJAX request
		 *  cellTemplates: Array of table cell templates after AJAX request
		 *  successHandler: Optional, success handler function(transport, treeItem) for AJAX request
		 *  requestHeaders: Optional, key-value pairs for AJAX request headers
		 * }
		 */
		treeItem:function(item,parent){
			if(null!=parent && parent.querySelector(".boxbody")){ parent=parent.querySelector(".boxbody"); }
			let ti=document.createElement("div");
			ti.classList.add("treeitem","closed");
			let head=document.createElement("h3");
			head.classList.add("treehead",skin["treeheadericontheme"]);
			let toggle=document.createElement("span")
			toggle.classList.add("toggleitem");
			head.appendChild(toggle);
			ti.appendChild(head);
			head.innerHTML+=item.header;
			let tb=document.createElement("div");
			tb.classList.add("treebody");
			if(item.content){ 
				tb.innerHTML=item.content; 
			} else if(item.updater){
				tb.innerHTML='Loading...'; 
				ti.updater=item.updater;
			}
			ti.appendChild(tb);
			if(item.id){
				ti.id=item.id;
				head.id=item.id+"_head";
				tb.id=item.id+"_body";
			}
			ti.form=function(frm){ return ui.form(frm,tb) };
			tb.form=function(frm){ return ui.form(frm,tb) };
			ti.treeItem=function(item){ return ui.treeItem(item,tb) };
			tb.treeItem=function(item){ return ui.treeItem(item,tb) };
			ti.table=function(tbl,data){ return ui.table(tbl,data,tb); };
			tb.table=function(tbl,data){ return ui.table(tbl,data,tb); };
			ti.warn=function(text) { return ui.addTabWarning(head, text)};
			tb.warn=function(text) { return ui.addTabWarning(head, text)};
			ti.unwarn=function() { return ui.removeTabWarning(head)};
			tb.unwarn=function() { return ui.removeTabWarning(head)};
			if(item.url && !item.updater){
				ti.url=item.url;
				let successHandler=function(transport){
					tb.table({ headers:item.headers, cellTemplates:item.cellTemplates }, transport.responseJSON);
				};
				if(item.successHandler){ successHandler=item.successHandler; }
				if(item.url.indexOf("?")>1){
					ti.url+="&";
				} else {
					ti.url+="?";
				}
				if(!tb.dataset.pagesize){ tb.dataset.pagesize="25"; }
				ti.url+="pagenumber=1&pagesize="+tb.dataset.pagesize;
				if(-1!==ti.url.indexOf(window.location.host)){
					new Ajax.Request(ti.url,{
						method:'get',
						onSuccess:function(transport){ successHandler(transport, ti)},
						onFailure:function(transport){ ui.defaultFailureHandler(transport, ti)}
					});
				} else {
					ti.requestHeaders=item.requestHeaders;
					AjaxUtils.remoteAjax(
							ti.url,
							'get',
							{},
							function(transport){ successHandler(transport, ti)},
							function(transport){ ui.defaultFailureHandler(transport, ti)},
							ti.requestHeaders
					);
				}
			}

			ti.record=item.record;
			if(null!=parent){
				parent.appendChild(ti);
			}
			head.addEventListener("click",ui.toggleTreeItem);
			return ti;
		},
		
		toggleTreeItem:function(evt){
			let ctrl=evt.target;
			ui.doToggleTreeItem(ctrl.closest(".treeitem"));
		},
		doToggleTreeItem:function(treeItem){
			let toOpen=treeItem.classList.contains("closed");
			if(toOpen){
				treeItem.classList.remove("closed");
				let tb=treeItem.querySelector(".treebody");
				if(treeItem.updater){
					treeItem.updater(tb);
				}
			} else {
				treeItem.classList.add("closed");
			}
		},

		defaultSuccessHandler:function(transport,containerData){
			ui.table(containerData,transport.responseJSON,containerData.id);
		},

		defaultFailureHandler:function(transport,parent){
			let err=transport.responseText;
			if(transport.responseJSON && transport.responseJSON.error){
				err=transport.responseJSON.error;
			}
			if(parent.querySelector(".boxbody")){
				parent=parent.querySelector(".boxbody");
			}
			parent.innerHTML=err;
		},
		
		handleSessionExpired:function(){
			alert("Your session has expired, or you logged out in another tab. When you click OK, you can log in again.");
			ui.forceReload();
		},
		
		form:function(frm,parent){
			if(!frm.id){ frm.id='frm_'+Math.floor(1000000*Math.random()); }
			if(undefined===frm.readonly && undefined!==canEdit){ frm.readonly=!canEdit; }
			let f=document.createElement("form");
			f.id=frm.id;
			f.action=frm.action;
			if(undefined!==frm.readonly){ f.dataset.readonly= ""+(frm.readonly===true ? 1 : 0); }
			if(undefined!==frm.autosubmit && frm.autosubmit===false){ f.classList.add("suppressautoupdate"); }
			f.dataset.ajaxmethod=(frm.method) ? frm.method : "post";
			if(frm.classes){ f.classList.add(...frm.classes.split(" ")); }
			if(null!=parent){
				if(parent.querySelector(".boxbody")){ parent=parent.querySelector(".boxbody") }
				parent.appendChild(f);
			}
			f.hiddenField=function(fieldName,fieldValue){ return ui.hiddenField(fieldName,fieldValue,f); };
			f.textField=function(field){ return ui.textField(field,f); };
			f.textArea=function(field){ return ui.textArea(field,f); };
			f.passwordField=function(field){ return ui.passwordField(field,f); };
			f.fileField=function(field){ return ui.fileField(field,f); };
			f.formField=function(field){ return ui.formField(field,f); };
			f.roleField=function(field){ return ui.roleField(field,f); };
			f.dropdown   =function(field){ return ui.dropdown(field,f); };
			f.checkbox   =function(field){ return ui.checkbox(field,f); };
			f.createButton=function(options){ return ui.createButton(f,options); };
			f.buttonField=function(field){ return ui.buttonField(field,f); };
			f.submitButton=function(field){ return ui.submitButton(field,f); };
			f.datePicker=function(field){ return ui.datePicker(field,f); };
			f.dateTimePicker=function(field){ return ui.dateTimePicker(field,f); };
			f.dateField=function(field){ return ui.dateField(field,f); };
			f.dateTimeField=function(field){ return ui.dateTimeField(field,f); };
			f.radioButtons=function(field){ return ui.radioButtons(field,f); };
			f.audioField=function (field) { return ui.audioField(field,f); };
			if('get'!==f.dataset.ajaxmethod){
				f.hiddenField("csrfToken",csrfToken);
			}
			return f;
		},

	/**
	 * @param field Details of the form field. Options include name, id, content, afterUpdate.
	 * @param parent
	 * @returns HTMLElement
	 */
		formField:function(field,parent){
			let lbl=document.createElement("label");
			lbl.htmlFor=field.name;
			if(field.id){ lbl.id=field.id+"_label"; }
			let s=document.createElement("span");
			s.classList.add("label");
			s.innerHTML=field.label;
			lbl.appendChild(s);
			if(field.content){ lbl.innerHTML+=field.content; }
			if(field.afterUpdate){ lbl.afterUpdate=field.afterUpdate; }
			if(null!=parent){ parent.appendChild(lbl); }
			return lbl;
		},
		addHelpText:function(label,fieldName){
			if(helpTexts && helpTexts[fieldName]){
				let h=document.createElement("div");
				h.classList.add("helptext");
				h.innerHTML=helpTexts[fieldName];
				label.appendChild(h);
			}
		},
		addSuppliedHelpText:function(label,suppliedText){
			let h=document.createElement("div");
			h.classList.add("helptext");
			h.innerHTML=suppliedText;
			label.appendChild(h);
		},
		createButton:function(parent,options){
			if(!options){ options={}; }
			let lbl=document.createElement("label");
			let cb=document.createElement("input");
			cb.type="button";
			cb.value="Create";
			cb.options=options;
			if(options.beforeSubmit){
				cb.onclick=function(){ options.beforeSubmit(); ui.submitForm(cb); }
			} else {
				cb.onclick=function(){ ui.submitForm(cb); }
			}
			if(options.tabAfterCreate){
				cb.dataset.tabOnViewPage=options.tabAfterCreate;
			}
			lbl.appendChild(cb);
			if(null!=parent){ 
				parent.appendChild(lbl);
				lbl.closest("form").classList.add("suppressautoupdate");
			}
			return lbl;
		},
		buttonField:function(field,parent){
			let lbl=document.createElement("label");
			let b=document.createElement("input");
			if(field.id){ b.id=field.id; }
			b.type="button";
			b.value=field.label;
			b.onclick=field.onclick;
			lbl.appendChild(b);
			if(null!=parent){ 
				parent.appendChild(lbl);
				if(lbl.closest("form")){
					lbl.closest("form").classList.add("suppressautoupdate");
				}
			}
			return lbl;
		},
		submitButton:function(field,parent){
			let lbl=document.createElement("label");
			let b=document.createElement("input");
			if(field.id){ b.id=field.id; }
			b.type="submit";
			b.value=field.label;
			lbl.appendChild(b);
			if(null!=parent){ 
				parent.appendChild(lbl);
				lbl.closest("form").classList.add("suppressautoupdate");
			}
			return lbl;
		},
		passwordField:function(field,parent){
			field.type="password";
			return ui.textField(field,parent);
		},
		hiddenField:function(fieldName,fieldValue,parent){
			let f=document.createElement("input");
			f.type="hidden";
			f.name=fieldName;
			f.id=fieldName;
			f.value=fieldValue;
			if(null!=parent){
				parent.appendChild(f);
			}
			return f;
			
		},
		
		/**
		 * Writes a text input field with its label.
		 * Parameters for field:
		 * label The user-friendly ame for the field
		 * name The form field name that goes to the server
		 * value The default value if the field. If not specified, and this is a View page for a record, defaults to the value of field.name for that record.
		 * readonly Whether the field can be edited. If not specified, inherits from parent.
		 */
		textField:function(field,parent){
			let lbl=ui.formField(field,parent);
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.value && data && data[field.name]!==null){ field.value=data[field.name]; }
			if(!field.value){ field.value=""; }
			if(field.readonly){
				if(""===field.value||!field.value){ field.value="&nbsp;"; }
				lbl.innerHTML+=field.value;
			} else {
				ui.textBox(field, lbl);
			}
			if(field.helpText){
				ui.addSuppliedHelpText(lbl,field.helpText);
			} else {
				ui.addHelpText(lbl,field.name);
			}
			if(null!=parent){
				parent.appendChild(lbl);
			}
			return lbl;
		},

		textBox:function(field,parent){
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.value && data && data[field.name]!==null){ field.value=data[field.name]; }
			if(!field.value){ field.value=""; }
			let tb;
			if(field.readonly){
				if(""===field.value||!field.value){ field.value="&nbsp;"; }
				tb=document.createElement("span");
				tb.innerHTML=ui.decodeHtmlEntities(field.value);
			} else {
				tb=document.createElement("input");
				tb.type="text";
				if(field.type){ tb.type=field.type; }
				tb.name=field.name;
				if(field.id){ 
					tb.id=field.id;
				} else {
					tb.id=tb.name;
				}
				tb.value=ui.decodeHtmlEntities(field.value);
				tb.dataset.oldValue=ui.decodeHtmlEntities(field.value);
				if(field.apiUrl){
					tb.dataset.apiurl=field.apiUrl;
				}
				tb.addEventListener("keyup",function(){ ui.updateFormField(tb); });
				tb.addEventListener("click",function(){ ui.updateFormField(tb); });
				tb.addEventListener("blur",function(){ ui.doUpdateFormField(tb); });
			}
			if(null!=parent){
				parent.appendChild(tb);
			}
			return tb;
		},

		textArea:function(field,parent){
			let lbl=ui.formField(field,parent);
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.value && data && undefined!==data[field.name]){ field.value=data[field.name]; }
			if(!field.value){ field.value=""; }
			if(field.readonly){
				if(""===field.value||!field.value){ field.value="&nbsp;"; }
				lbl.innerHTML+=field.value;
			} else {
				let tb=document.createElement("textarea");
				tb.name=field.name;
				if(field.id){ 
					tb.id=field.id;
				} else {
					tb.id=tb.name;
				}
				if(!field.value){ field.value=""; }
				tb.innerHTML=ui.decodeHtmlEntities(field.value);
				tb.dataset.oldValue=ui.decodeHtmlEntities(field.value);
				lbl.appendChild(tb);
				if(field.helpText){
					ui.addSuppliedHelpText(lbl,field.helpText);
				} else {
					ui.addHelpText(lbl,field.name);
				}
				lbl.querySelector("textarea").addEventListener("keyup",function(){ ui.updateFormField(lbl.querySelector("textarea")); });
				lbl.querySelector("textarea").addEventListener("click",function(){ ui.updateFormField(lbl.querySelector("textarea")); });
				lbl.querySelector("textarea").addEventListener("blur",function(){ ui.doUpdateFormField(lbl.querySelector("textarea")); });
			}
			if(null!=parent){
				parent.appendChild(lbl);
			}
			return lbl;
		},
		
		radioButtons:function(field,parent){
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.defaultValue && data && undefined!==data[field.name]){ field.defaultValue=data[field.name]; }
			if(!field.defaultValue){ field.defaultValue=""; }
			let lbl=ui.formField(field,parent);
			if(field.readonly){
				let s=document.createElement("span");
				field.options.forEach(function(o){
					if(o.value===field.value){
						s.innerHTML+=field.label;
					}
				});
				lbl.appendChild(s);
			} else {
				field.options.forEach(function(o){
					let l=document.createElement("label");
					l.classList.add("radiolabel");
					let b=document.createElement("input");
					b.type="radio";
					b.name=field.name;
					b.value=o.value;
					l.appendChild(b);
					lbl.appendChild(l);
					l.innerHTML+=o.label;
				});
				lbl.innerHTML+='<div class="shim">&nbsp;</div>';
				if(null!=parent){
					parent.appendChild(lbl);
				}
				lbl.querySelectorAll("label").forEach(function(l){
					l.addEventListener("click", ui.onRadioSelect);
					l.querySelector("input").addEventListener("click", ui.onRadioSelect);
				});
				window.setTimeout(function(){
					lbl.querySelector("input[value="+field.defaultValue+"]").click();
				},50);
			}
			return lbl;
		},
		onRadioSelect:function(evt){
			let elem=evt.target;
			if(elem.closest("label.radiolabel")){ elem=elem.closest("label.radiolabel"); }
			elem=elem.closest("label");
			ui.doRadioSelect(elem);
		},
		doRadioSelect:function(fieldLabelElement){
			fieldLabelElement.querySelectorAll("label.radiolabel").forEach(function(lbl){
				if(lbl.querySelector("input").checked){
					lbl.classList.add("selected");
				} else {
					lbl.classList.remove("selected");
				}
			})
			//TODO autosubmit
		},
		
		
		/**
		 * Returns aSELECT element with its label.
		 *
		 * @param field Object Describes the field. Parameters include:
		 * @param parent Element|null  An HTML element into which the SELECT should be inserted.
		 * @see ui.dropdownElement for parameters in field.
		 */
		dropdown:function(field,parent){
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.value && data && undefined!==data[field.name]){ field.value=data[field.name]; }
			if(!field.value){ field.value=""; }
			let lbl=ui.formField(field,parent);
			ui.dropdownElement(field,lbl);
			ui.addHelpText(lbl,field.name);
			if(null!=parent){
				parent.appendChild(lbl);
			}
			return lbl;
		},
		/**
		 * Returns an unwrapped SELECT element for insertion into other elements. 
		 * 
		 * @param {Object} field Describes the field. Parameters include:
		 * 			- name Required. The name that will be sent to the server, e.g., an object property name.
		 * 			- options Required. An array of objects containing at minimum "value" and "label" properties.
		 * 			- readonly Optional. If specified, overrides the readonly attribute of any parent form. Default false.
		 * 			- value Optional. The value that should be pre-selected.
		 * 			- id Optional An HTML ID for the SELECT element.
		 * 			- apiUrl Optional If specified, the URL to which any updates should be submitted.
		 * 			- showOptionLabelOnReadOnly Optional if specified and true, the text shown in the read-only case will be the "label", not the "value"
		 * @param {Element} parent An HTML element into which the SELECT should be inserted.
		 */
		dropdownElement:function(field,parent){
			if(undefined===field.readonly && null!=parent && parent.dataset && undefined!==parent.dataset.readonly){
				field.readonly=parseInt(parent.dataset.readonly);
			}
			if(!field.value && data && undefined!==data[field.name]){ field.value=data[field.name]; }
			if(!field.value){ field.value=""; }
			let s;
			if(field.readonly){
				s=document.createElement("span");
				if(!field["showOptionLabelOnReadOnly"]){
					s.innerHTML+=field.value;
				} else {
					for(let i=0;i<field["options"].length;i++){
						let o=field["options"][i];
						if(o["value"]===field["value"]){
							s.innerHTML+=o["label"];
							break;
						}
					}
					if(""===s.innerHTML){
						s.innerHTML="&nbsp;";
					}
				}
			} else {
				s=document.createElement("select");
				s.name=field.name;
				s.dataset.oldValue=field.value;
				if(field.id){ 
					s.id=field.id;
				} else {
					s.id=s.name;
				}
				field.options.forEach(function(o){
					let opt=document.createElement("option");
					opt.value=o.value;
					if(o.value===field.value) {	opt.selected=true; }
					opt.innerHTML=o.label;
					s.appendChild(opt);
				});
				if(field.apiUrl){
					s.dataset.apiurl=field.apiUrl;
				}
				s.addEventListener("change",function(){ ui.updateFormField(s); });
				s.addEventListener("blur",function(){ ui.doUpdateFormField(s); });
			}
			if(null!=parent){
				parent.appendChild(s);
			}
			return s;
		},

		/**
		 * Returns a checkbox field. If parent specified, also appends the checkbox field to the parent.
		 * @param {Object} field A description of the form field. Parameters can include:
		 * 						- readonly Whether the field is read-only. Default is parent form's readonly setting.
		 * 						- name The name to be submitted to the server
		 * 						- label The user-friendly label text for the form field.
		 * 						- handler An optional function to handle changes in state. Function receives the hidden input in the label element as a parameter.
		 * @param {Element} parent The parent element (usually a form)
		 */
		checkbox:function(field,parent){
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.value && data && undefined!==data[field.name]){ field.value=data[field.name]; }
			if(!field.value){ field.value=""; }
			let lbl=ui.formField(field,parent);


			let img=document.createElement("img");
			let checked="no";
			let prefix="";
			if(field.checked){ checked="yes"; field.value=1; }
			if(field.value && 1===parseInt(field.value)){ checked="yes"; }
			if(!field.readonly){ prefix="btn_"; }
			img.src="/images/icons/"+skin["bodyicontheme"]+"/"+prefix+checked+".gif";
			img.setStyle({ marginBottom:0, lineHeight:"1em" });
			lbl.appendChild(img);
			if(!field.readonly){
				let cb=document.createElement("input");
				cb.type="hidden";
				cb.name=field.name;
				if(field.value && 1===1*field.value){ cb.value="1"; }
				if(field.readonly){ cb.disabled=true; }
				if(field.handler){
					lbl.handler=field.handler;
				} else {
					lbl.handler=ui.updateFormField;
				}
				lbl.appendChild(cb);

				img.addEventListener("click",function(evt){
					let img=evt.target;
					let lbl=img.closest("label");
					let inp=lbl.querySelector("input");
					if(img.src.indexOf("no.gif")>0){
						img.src=img.src.replace("no.gif","yes.gif");
						inp.value="1";
					} else {
						img.src=img.src.replace("yes.gif","no.gif");
						inp.value="0";
					}
					lbl.handler(inp);
				});
			}
			
			if(field.helpText){
				ui.addSuppliedHelpText(lbl,field.helpText);
			} else {
				ui.addHelpText(lbl,field.name);
			}
			if(null!=parent){
				parent.appendChild(lbl);
			}
			return lbl;
		},

		/**
		 * @param field Details of the field.
		 * @param parent The parent element, typically a form.
		 * @returns HTMLElement The label element surrounding the form field
		 */
		fileField:function(field,parent){
			let lbl=ui.formField(field,parent);
			let ff=document.createElement("input");
			ff.type="file";
			ff.name=field.name;
			lbl.appendChild(ff);
			if(null!=parent){
				parent.appendChild(lbl);
				lbl.closest("form").enctype="multipart/form-data";
			}
			return lbl;
		},

		audioField:function(field,parent){
			if(!field){ field={}; }
			let lbl=ui.formField(field,parent);
			if(null!=parent){
				parent.appendChild(lbl);
			}
			AudioRecording.init(lbl,field);
			return lbl;
		},

		roleField:function(field,parent){
			//	frm.roleField({ label:"Owner", name:'owner', parentObject:data, otherType:'user', idField:'owner', labelField:'ownername', readonly:(!isAdmin &&!isOwner) });
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.value && data && undefined!==data[field.name]){ field.value=data[field.name]; }
			if(!field.value){ field.value=""; }
			let lbl=ui.formField(field,parent);
			let hi=document.createElement("input");
			if(!field.otherId){
				field.otherId="";
				field.otherName="None set";
			}
			hi.type="hidden";
			hi.name=field.name;
			hi.value=field.otherId;
			hi.dataset.oldValue=field.otherId;
			lbl.appendChild(hi);
			let a=document.createElement("a");
			a.href='/'+field.otherType+'/'+field.otherId;
			a.innerHTML=field.otherName;
			lbl.appendChild(a);
			if(!field.readonly){
				let b=document.createElement("input");
				b.type="button";
				b.value="Change...";
				b.style.marginLeft="0.5em";
				b.onclick=function(){ 
					document.querySelectorAll(".currentrolefield").forEach(function(elem){ elem.classList.remove("currentrolefield") });
					b.closest("label").classList.add("currentrolefield");
					ui.findRole(field); 
				};
				lbl.appendChild(b);
			}
			ui.addHelpText(lbl,field.name);
			if(null!=parent){
				parent.appendChild(lbl);
			}
			lbl.fieldData=field;
			return lbl;
		},
		
		findRole:function(field){
			let headers=field.headers.slice();
			headers.push('&nbsp;');
			let cells=field.cellTemplates.slice();
			cells.push('<input type="button" value="Choose" onclick="ui.setRole(this)" />');
			let constraint="";
			if(field.constraint){
				let k=(Object.keys(field.constraint))[0];
				let v=field.constraint[k];
				constraint="/"+k+"/"+v;
			}
			ui.modalBox({
				'url':'/api/'+field.otherType+constraint,
				'title':'Find '+field.otherType+'s',
				'headers':headers,
				'cellTemplates':cells
			});
		},
		
		setRole:function(btn){
			let parentRole=document.body.querySelector(".currentrolefield");
			let newRole=btn.closest("tr").rowData;
			parentRole.classList.remove("currentrolefield");
			let link=parentRole.querySelector("a");
			let nameField=parentRole.fieldData.labelField || 'name';
			let idField='id';
			link.innerHTML=newRole[nameField];
			link.href='/'+parentRole.fieldData.otherType+'/'+newRole[idField];
			ui.closeModalBox();
			let hi=parentRole.querySelector("input");
			hi.value=newRole[idField];
			parentRole.roleRecord=newRole;
			ui.updateFormField(hi);
		},
		
		updateFormField:function(field){
			window.clearTimeout(submitTimer);
			if(field.tagName==="input" && ("hidden"===field.type ||"text"===field.type || "password"===field.type) && !validator.validate(field)){
				return false;
			}
			if(field.closest("label,td")){ field.closest("label,td").classList.remove("invalidfield"); }
			if(field.closest(".suppressautoupdate") && !field.dataset.apiurl){ return false; }
			window.submitTimer=setTimeout(function(){ ui.doUpdateFormField(field) },1000);
		},
		
		doUpdateFormField:function(field){
			if(field.dataset.oldValue===field.value){ return false; }
			if(field.closest(".suppressautoupdate") && !field.dataset.apiurl){ return false; }
			if(field.closest("label,td")){ field.closest("label,td").classList.add("updating"); }
			let body;
			let apiUrl='';
			if(field.dataset.apiurl){
				apiUrl=field.dataset.apiurl;
			} else if(field.closest("form")){
				apiUrl=field.closest("form").action;
			}
			if(field.type && field.type==="checkbox"){
				body=field.name+"="+(field.checked ? "1" : "0")+"&csrfToken="+csrfToken;
				field.dataset.oldValue=field.checked ? "0" : "1";
			} else {
				field.dataset.oldValue=field.value;
				body=field.name+"="+encodeURIComponent(field.value)+"&csrfToken="+csrfToken
			}
			window.setTimeout(function(){
				new Ajax.Request(apiUrl,{
					method:'patch',
					postBody:body,
					onSuccess:function(transport){ ui.updateFormField_onSuccess(transport,field) },
					onFailure:function(transport){ ui.updateFormField_onFailure(transport,field) }
				});
			},250);
		},
		
		updateFormField_onSuccess:function(transport,field){
			field.closest("label,td").classList.remove('updating');
			field.dataset.oldValue=field.value;
			let afterUpdate=field.closest("label,td").afterUpdate;
			if(field.closest("label")){
				field.closest("label").classList.remove('invalidfield');
			} else {
				field.classList.remove('invalidfield');
			}
			if(afterUpdate){ afterUpdate(field); }
		},
		updateFormField_onFailure:function(transport,field){
			field.closest("label,td").classList.remove('updating');
			if(401===transport.status){
            	ui.handleSessionExpired();
            	return;
            }
			if(field.closest("label")){
				field.closest("label").classList.add('invalidfield');
			} else {
				field.classList.add('invalidfield');
			}
			if(transport.responseJSON && transport.responseJSON.error){
				alert(transport.responseJSON.error);
			} else {
				alert(transport.responseText);
			}
		},
		
		submitForm:function(submitButton){
			let frm=submitButton.closest("form");
			if(frm.querySelector(".invalidfield")){ return false; }
			let fields=frm.querySelectorAll("input[type=hidden], input[type=text], input[type=password], input[type=file], select, textarea");
			let isValid=true;
			let formData=new FormData();
			fields.forEach(function(f){
				if(!validator.validate(f)){
					isValid=false;
				} else if("file"===f.type){
					formData.append(f.name, f.files[0], f.files[0].name)
				} else {
					formData.append(f.name, encodeURIComponent(f.value));
				}
			});
			if(!isValid){return false; }
			submitButton.closest("label,tr,div").classList.add("updating");
			let xhr=new XMLHttpRequest();
			let method=frm.method;
			if(frm.dataset.ajaxmethod){ method=frm.dataset.ajaxmethod; }
	        xhr.open(method, frm.action, true);
	        xhr.onload=function(){
	        	try{
	        		xhr.responseJSON=JSON.parse(xhr.responseText);
	        	} catch(ex) {
	        		//just eat it
	        	}
	            if(200===xhr.status || 201===xhr.status){
	                ui.submitForm_onSuccess(xhr,submitButton);
	            } else if(401===xhr.status){
	            	ui.handleSessionExpired();
	            } else {
	                ui.submitForm_onFailure(xhr,submitButton);
	            }
	        };
			xhr.send(formData);
		},
		submitForm_onSuccess:function(transport,submitButton){
			if(!transport.responseJSON || transport.responseJSON.error){
				return ui.submitForm_onFailure(transport,submitButton);
			}
			submitButton.closest("label,tr,div").classList.remove("updating");
			if(transport.responseJSON.created){
				if(submitButton.options && submitButton.options.afterSuccess){
					return submitButton.options.afterSuccess(transport.responseJSON);
				}
				let loc='/'+transport.responseJSON.type+'/'+transport.responseJSON.created.id;
				if(submitButton.dataset.tabOnViewPage){
					loc+='#'+submitButton.dataset.tabOnViewPage;
				}
				window.location=loc;
			}
		},
		submitForm_onFailure:function(transport,submitButton){
			submitButton.closest("label,tr,div").classList.remove("updating");
			if(transport.responseJSON && transport.responseJSON.error){
				alert(transport.responseJSON.error);
			} else {
				alert(transport.responseText);
			}
		},
		
		checkmark:function(obj, field){
			let str=obj[field];
			str=str.toLowerCase();
			if("1"===str || "yes"===str || "true"===str){
				return '<img alt="Yes" src="/images/icons/yes.gif" />';
			}
			return '&nbsp;';
		},
		
		/** 
		 * Writes a date picker field with its label, with the time fields enabled. 
		 * @see datePicker for documentation.
		 */
		dateTimePicker:function(field, parent){
			field['showTime']=true;
			return ui.datePicker(field, parent);
		},
		dateField:function(field,parent){
			return ui.datePicker(field, parent);
		},
		dateTimeField:function(field,parent){
			return ui.datePicker(field, parent);
		},
		
		/**
		 * Writes a date picker field with its label. 
		 * Sets and sends a GMT date string (YYYY-MM-DD HH:MM:SS), but displays in LOCAL time.
		 * 
		 * Common parameters for field:
		 * 
		 * label The user-friendly mame for the field
		 * name The form field name that goes to the server
		 * value The default value if the field. If not specified, and this is a View page for a record, defaults to the value of field.name for that record.
		 * readonly Whether the field can be edited. If not specified, inherits from parent.
		 * 
		 * Date picker parameters:
		 * 
		 * showTime: if true, hour and minute dropdowns will be shown under the calendar. Seconds will be unchanged.
		 * minuteStep: Show only minutes divisible by minuteStep. If undefined, same as 1 (all minutes).
		 *             Example: if 5, minutes will be 00, 05 ... 50, 55.
		 *             If the existing value does not correspond to one of those shown, the next lowest will be selected.
		 */
		datePicker:function(field, parent){
			let now=new Date();
			let offsetMins=now.getTimezoneOffset();
			let lbl=ui.formField(field,parent);
			if(undefined===field.readonly && null!=parent && undefined!==parent.dataset.readonly){ field.readonly=parseInt(parent.dataset.readonly); }
			if(!field.value && data && data[field.name]!==null){ field.value=data[field.name]; }
			if(!field.value){ 
				field.value=now.toISOString().replace("T"," ").substr(0,19);
			}
			if(field.readonly){
				lbl.innerHTML+='<span class="datepickerfriendlydate">'+ui.friendlyDate(field.value)+'</span>';
			} else {
				lbl.dataset.gmtOffset=""+offsetMins;
				lbl.dpDate=new Date(field.value);
				lbl.selectedDate=new Date(field.value);
				lbl.dpDate.setMinutes(lbl.dpDate.getMinutes()-offsetMins); //Correct from GMT to local
				lbl.selectedDate.setMinutes(lbl.dpDate.getMinutes()-offsetMins); //Correct from GMT to local for display
				let dp='<input type="hidden" name="'+field.name+'" id="'+field.name+'" value="'+field.value+'" />';
				dp+='<span class="datepickerfriendlydate">'+ui.friendlyDate(field.value)+'</span> <input type="button" value="Change..." onclick="ui.datePickerShow(this);return false"/>';
				dp+='<div class="datepicker" style="display:none;">';
				dp+='<div class="datepickercalendar" style="width:20em">';
				
				dp+='</div>';
				if(field.showTime){
					dp+='<span style="display:inline-block;width:21em;border-top:1px solid #666">';

					if(!field.minuteStep){ field.minuteStep=1; }
					let step=field.minuteStep;
					let selectedHour=lbl.dpDate.getHours();
					let selectedMinute=lbl.dpDate.getMinutes();
					if(1!==step){ selectedMinute=(Math.floor(selectedMinute/step))*step; }
					dp+='Time: <select class="datepickerhour" name="'+field.name+'_hour" onchange="ui.datePickerSet(this)">';
					for(let h=0;h<24;h++){
						let selected='';
						if(h===selectedHour){ selected='selected="selected"'; }
						dp+='<option '+selected+' value="'+(h<10?'0'+h:h)+'">'+(h<10?'0'+h:h)+'</option>';
					}
					dp+='</select> : <select class="datepickerminute" name="'+field.name+'_minute" onchange="ui.datePickerSet(this)">';

					for(let i=0;i<60;i+=step){
						let selected='';
						if(i===selectedMinute){ selected='selected="selected"'; }
						dp+='<option '+selected+' value="'+(i<10?'0'+i:i)+'">'+(i<10?'0'+i:i)+'</option>';
					}
					dp+='</select>';
					dp+='</soan>';
				}
				dp+='</div>';
				lbl.innerHTML+=dp;
				ui.datePickerMoveCalendar(lbl,0);
			}
			if(null!=parent){
				parent.appendChild(lbl);
			}
			return lbl;
		},
		
		datePickerShow: function(btn){
			btn.closest("label").querySelector("div.datepicker").style.display="block";
			btn.remove();
		},
		
		datePickerMoveCalendar: function(label, offset){
			if(0!==parseInt(offset)){
				label.dpDate.setMonth(label.dpDate.getMonth()+offset);
			}
			label.querySelector(".datepickercalendar").innerHTML='<input type="button" class="unselected" onclick="ui.datePickerMoveCalendar(this.closest(\'label\'),-1);return false" value="&lt;&lt;" /> ' +
				'<span style="display:inline-block;text-align:center;width:13.1em"><strong>' +
				ui.monthsOfYear[label.dpDate.getMonth()] + ' ' + label.dpDate.getFullYear() +
				'</strong></span>' +
				' <input type="button" class="unselected" onclick="ui.datePickerMoveCalendar(this.closest(\'label\'),1);return false" value="&gt;&gt;" /><br/>';

			let tempDate=new Date();
			tempDate.setFullYear(label.dpDate.getFullYear());
			tempDate.setMonth(label.dpDate.getMonth()+1);
			tempDate.setDate(0);
			let daysInMonth=tempDate.getDate();
			tempDate.setDate(1);
			let dayOfFirst=tempDate.getDay(); //0=Sunday, 6=Sat
			
			let thisMonth=label.selectedDate.getMonth();
			let thisYear=label.selectedDate.getFullYear();
			let thisDay=label.selectedDate.getDate();
			let isThisMonthCalendar=(thisMonth===tempDate.getMonth() && thisYear===tempDate.getFullYear());

			let count=1;
			let dow=0;
			while(count<=dayOfFirst){
				let btn=document.createElement("input");
				btn.type="button";
				btn.value="00";
				btn.classList.add("unselected");
				btn.style.marginLeft='0.25em';
				btn.style.width='2.25em';
				btn.style.opacity="0.3";
				btn.style.color="transparent";
				label.querySelector(".datepickercalendar").appendChild(btn);
				count++;
				dow++;
			}
			count=1;
			while(count<=daysInMonth){
				let btn=document.createElement("input");
				btn.type="button";
				btn.value=(count<10?"0"+count:count);
				if(!isThisMonthCalendar || count!==thisDay){
					btn.classList.add("unselected");
				}
				btn.classList.add("datepickerday");
				btn.style.marginLeft='0.25em';
				btn.style.width='2.25em';
				btn.dataset.year=""+label.dpDate.getFullYear();
				btn.dataset.month=""+label.dpDate.getMonth();
				btn.dataset.day=""+count;
				btn.onclick=function(evt){ let elem=evt.target; ui.datePickerSet(elem); };
				if(0===dow || 6===dow){ btn.classList.add("weekend"); }
				label.querySelector(".datepickercalendar").appendChild(btn);
				count++;
				dow++;
				if(dow%7===0){
					label.querySelector(".datepickercalendar").appendChild(document.createElement("br"));
					dow=0;
				}
			}
			while(dow!==0 && dow<=6){
				let btn=document.createElement("input");
				btn.type="button";
				btn.value="00";
				btn.classList.add("unselected");
				btn.style.opacity="0.3";
				btn.style.color="transparent";
				btn.style.marginLeft='0.25em';
				btn.style.width='2.25em';
				label.querySelector(".datepickercalendar").appendChild(btn);
				count++;
				dow++;
			}
			label.querySelector(".datepickercalendar").style="display:block";
		},
		
		datePickerSet:function(elem){
			let lbl=elem.closest("label");
			let d=lbl.dpDate;
			let s=lbl.selectedDate;
			if(lbl.querySelector(".datepickerminute")){ 
				d.setMinutes(lbl.querySelector(".datepickerminute").value); 
				s.setMinutes(lbl.querySelector(".datepickerminute").value); 
			}
			if(lbl.querySelector(".datepickerhour")){ 
				d.setHours(lbl.querySelector(".datepickerhour").value); 
				s.setHours(lbl.querySelector(".datepickerhour").value); 
			}
			if(elem.classList.contains("datepickerday")){ 
				d.setDate(parseInt(elem.dataset.day));
				d.setMonth(parseInt(elem.dataset.month));
				d.setFullYear(parseInt(elem.dataset.year));
				s.setDate(parseInt(elem.dataset.day));
				s.setMonth(parseInt(elem.dataset.month));
				s.setFullYear(parseInt(elem.dataset.year));
				elem.closest(".datepickercalendar").querySelectorAll("input").forEach(function(b){
					b.classList.add("unselected");
				});
				elem.classList.remove("unselected");
			}
			let utcMonth=s.getUTCMonth()+1;
			let utcDay=s.getUTCDate();
			let utcHours=s.getUTCHours();
			let utcMinutes=s.getUTCMinutes();
			let utcSeconds=s.getUTCSeconds();
			if(utcMonth<10){ utcMonth="0"+utcMonth; }
			if(utcDay<10){ utcDay="0"+utcDay; }
			if(utcHours<10){ utcHours="0"+utcHours; }
			if(utcMinutes<10){ utcMinutes="0"+utcMinutes; }
			if(utcSeconds<10){ utcSeconds="0"+utcSeconds; }
			let utcDateString=s.getUTCFullYear()+"-"+utcMonth+"-"+utcDay+" "+utcHours+":"+utcMinutes+":"+utcSeconds;
			document.getElementById(lbl.htmlFor).value=utcDateString;
			lbl.querySelector(".datepickerfriendlydate").innerHTML=ui.friendlyDate(utcDateString);
			ui.updateFormField(lbl.querySelector("input"));
		},
		
		dateRegex:/^\d\d\d\d-\d\d-\d\d$/,
		dateTimeRegex:/^\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d$/,
		friendlyDate:function(dateString){
			if(""===dateString){
				return "-"; 
			} else if(dateString.match(ui.dateTimeRegex)){
				return ui.friendlyDateTime(dateString);
			} else if(!dateString.match(ui.dateRegex)){
				return dateString;
			}
			let parts=dateString.split("-");
			let now =new Date(); //In local time
			let offsetMins=now.getTimezoneOffset();
			let d= new Date(parts[0], parts[1]-1, parts[2], 0, 0-offsetMins, 0); //In GMT
			//we always show the time:
			let dateStr='';
			//Now set both to 0 and work out the difference, so we know ow to write the day part
			d.setMinutes(0);
			d.setHours(0);
			d.setMilliseconds(0);
			now.setMinutes(0);
			now.setHours(0);
			now.setMilliseconds(0);

			let diffDays=(now.getTime()-d.getTime())/86400000; //milliseconds to days
			if(-3>diffDays){
				if(d.getFullYear()===now.getFullYear()){
					//23 September
					dateStr+=d.getDate()+" "+ui.monthsOfYear[d.getMonth()];
				} else {
					//23 Sep 2012
					dateStr+=d.getDate()+" "+ui.monthsOfYear[d.getMonth()].substr(0,3)+" "+d.getFullYear();
				}	
			} else if(-1>diffDays){
				//Tuesday, 08:54
				dateStr+=ui.daysOfWeek[d.getDay()];
			} else if(0>diffDays){
				dateStr="Tomorrow";
			} else if(1>diffDays){
				dateStr="Today";
			} else if(2>diffDays){
				dateStr="Yesterday";
			} else if(4>diffDays){
				//Tuesday
				dateStr=ui.daysOfWeek[d.getDay()];
			} else if(d.getFullYear()===now.getFullYear()){
				//23 September
				dateStr=d.getDate()+" "+ui.monthsOfYear[d.getMonth()];
			} else {
				//23 Sep 2012
				dateStr=d.getDate()+" "+ui.monthsOfYear[d.getMonth()].substr(0,3)+" "+d.getFullYear();
			}
			return dateStr;
		},
		
		/**
		 * Formats a date string from the server as follows:
		 * If today, "hh:mm"
		 * If yesterday, "Yesterday, hh:mm"
		 * If 2 or 3 days ago, "Friday, hh:mm"
		 * If longer ago, "12 Jan 2015, hh:mm"
		 */
		friendlyDateTime:function(dateString){
			if(""===dateString){
				return "-";
			} else if(dateString.match(ui.dateRegex)){
				return ui.friendlyDate(dateString);
			} else if(!dateString.match(ui.dateTimeRegex)){
				return dateString;
			}
			let regex=/[-:\s]/g;
			let parts=dateString.split(regex);
			let now =new Date(); //In local time
			let offsetMins=now.getTimezoneOffset();
			let d= new Date(parts[0], parts[1]-1, parts[2], parts[3], (1*parts[4])-offsetMins, 0); //In GMT
			//we always show the time:
			let dateStr=('0'+d.getHours()).slice(-2)+':'+('0'+d.getMinutes()).slice(-2);
			//Now set both to 0 and work out the difference, so we know ow to write the day part
			d.setMinutes(0);
			d.setHours(0);
			d.setMilliseconds(0);
			now.setMinutes(0);
			now.setHours(0);
			now.setMilliseconds(0);

			let diffDays=(now.getTime()-d.getTime())/86400000; //milliseconds to days
			if(-3>diffDays){
				if(d.getFullYear()===now.getFullYear()){
					//23 September, 08:54
					dateStr=d.getDate()+" "+ui.monthsOfYear[d.getMonth()]+", "+dateStr;
				} else {
					//23 Sep 2012, 08:54
					dateStr=d.getDate()+" "+ui.monthsOfYear[d.getMonth()].substr(0,3)+" "+d.getFullYear()+", "+dateStr;
				}	
			} else if(-1>diffDays){
				//Tuesday, 08:54
				dateStr=ui.daysOfWeek[d.getDay()]+", "+dateStr;
			} else if(0>diffDays){
				dateStr="Tomorrow, "+dateStr;
			} else if(1>diffDays){
				dateStr="Today, "+dateStr;
			} else if(2>diffDays){
				dateStr="Yesterday, "+dateStr;
			} else if(4>diffDays){
				//Tuesday, 08:54
				dateStr=ui.daysOfWeek[d.getDay()]+", "+dateStr;
			} else if(d.getFullYear()===now.getFullYear()){
				//23 September, 08:54
				dateStr=d.getDate()+" "+ui.monthsOfYear[d.getMonth()]+", "+dateStr;
			} else {
				//23 Sep 2012, 08:54
				dateStr=d.getDate()+" "+ui.monthsOfYear[d.getMonth()].substr(0,3)+" "+d.getFullYear()+", "+dateStr;
			}
			return dateStr;
		},
		fieldToFriendlyDate:function(obj,field){
			let str=obj[field];
			return ui.friendlyDate(str);
		},
		
		/**
		 * Returns a representation of the interval in a sensible unit. 
		 * If under 60s, returns "X sec"; under 1hr, "X min"; under 48hr, "x hr"; else "x days"
		 */
		secondsToFriendlyUnits:function(seconds){
			if(isNaN(seconds)){ return "??"; }
			if(seconds<60){ return Math.floor(seconds)+" sec"; }
			if(seconds<7200){ return Math.floor(seconds/60)+" min"; }
			if(seconds<172800){ return Math.floor(seconds/3600)+" hr"; }
			return Math.floor(seconds/86400)+" days";
		},
		
		
		decodeHtmlEntities:function(str){
			//See http://stackoverflow.com/questions/7394748/whats-the-right-way-to-decode-a-string-that-has-special-html-entities-in-it
			let ta=document.createElement("textarea");
			ta.innerHTML=str;
			return ta.value;
		},

		
		/* 
		 * SMALL SCREEN / MOBILE function
		 */

		/**
		 * Whether the current screen sizes trigger the "small screen" CSS. This relies on a custom --icebear-smallscreen property
		 * being set to 0 by default and to 1 in the small-screen CSS (as applied by media query). See :root in base.css.
		 */
		isSmallScreen:false,
		
		checkForSmallScreen:function(){
			ui.isSmallScreen=(1===parseInt(window.getComputedStyle(document.body).getPropertyValue('--icebear-smallscreen').trim()));
		},
		
		smallScreenThresholdCrossed:function(){
			if(undefined===ui.wasSmallScreen){ return false; }
			return ui.isSmallScreen!==ui.wasSmallScreen;
		},
		
		smallScreenInit:function(){
			let b=document.body;
			if(b.querySelector(".tabset .current")){
				b.querySelector(".tabset .current").classList.add("smallscreen_open");
			} else if(b.querySelector(".box h2, .tabset h2")){
				b.querySelector(".box h2, .tabset h2").classList.add("smallscreen_open");
			}
			document.querySelectorAll(".box h2, .tabset h2").forEach(function(h){
				h.addEventListener("click",ui.smallScreenToggleOpen);
			});
			ui.checkForSmallScreen();
			ui.wasSmallScreen=ui.isSmallScreen;
			window.addEventListener("resize",function(){
				ui.checkForSmallScreen();
			});
		},
		
		smallScreenToggleOpen:function(evt){
			let header=evt.target;
			if(!ui.isSmallScreen){ return false; }
			let wasOpen=false;
			let itemBody;
			if(header.closest(".box")){
				itemBody=header.closest(".box").querySelector(".boxbody");
				if(itemBody.style.display==="block"){ wasOpen=true; }
			}
			if(header.closest(".tabset")){
				itemBody=header.nextElementSibling;
				if(itemBody.style.display==="block"){ wasOpen=true; }
			}
			document.querySelectorAll(".boxbody, .tabbody").forEach(function(elem){
				elem.style.display="none";
			});
			if(itemBody && !wasOpen){
				itemBody.style.display="block";
				if(ui.isSmallScreen){
					header.scrollIntoView();
				}
			}
		},

		/**
		 * Makes regular AJAX requests throughout the lifetime of the page, to keep the 
		 * server-side session alive. It doesn't matter what we request, as long as
		 * we request something.
		 * 
		 * This should be used sparingly, as it overrides the session timeout mechanism.
		 * A good use case is where the user is doing other things and intermittently 
		 * updating the system over a long period, for example crystal fishing. 
		 */
		keepAlive: function(){
			let delaySeconds=30;
			window.setInterval(function(){
				new Ajax.Request('/api/',{
					method:'get',
					onSuccess:function(xhr){},
					onFailure:function(xhr){}
				});
			}, 1000*delaySeconds);
		},
		
};

let validator={

		validate:function(field){
			let fieldName=field.name;
			let isValid=true;
			let err="";
			if(!fieldValidations || !fieldValidations[fieldName]){
				return true;
			}
			let validations=fieldValidations[fieldName];
			if(!(validations instanceof Array)){
				if(!validator.isValid(validations,field.value)){
					isValid=false;
					err="This "+validationPatterns[validations]["message"];
				}
			} else {
				for(let i=0;i<validations.length;i++){
					if(!validator.isValid(validations[i],field.value)){
						isValid=false;
						err="This "+validationPatterns[validations[i]]["message"];
					}
				}
			}
			if(field.closest("label")){
				let lbl=field.closest("label");
				if(!isValid){
					lbl.classList.add("invalidfield");
					if(lbl.querySelector(".helptext")){ lbl.querySelector(".helptext").hide(); }
					if(lbl.querySelector(".errortext")){
						lbl.querySelector(".errortext").remove();
					}
					let et=document.createElement("div");
					et.classList.add("errortext");
					et.innerHTML=err;
					lbl.appendChild(et);
				} else {
					lbl.classList.remove("invalidfield");
					if(lbl.querySelector(".errortext")){
						lbl.querySelector(".errortext").remove();	
						if(lbl.querySelector(".helptext")){ lbl.querySelector(".helptext").show(); }
					}
				}
			}
			return isValid;
		},
		isValid:function(validationType,fieldValue){
			let vType=validationPatterns[validationType];
			if(!vType){ return true; } //no validation for this type, assume true and let the server sort it
			if(vType["helper"]){
				if(validator[vType["helper"]]){ return validator[vType["helper"]](fieldValue); }
				return vType["helper"](fieldValue);
			} else if(vType.pattern){
				let re=new RegExp("^"+vType.pattern+"$");
				if(!re.test(fieldValue)){
					return false;
				}
			}
			return true;
		},
		isValidEmailAddress:function(str){
			return !!str.match(/^.*@.*$/);

		},
		isValidDnaSequence:function(str){
			str=str.replace(/\s/g,'');
			return !(str.length % 3 !== 0 || !str.match(/^[acgtACGT]*$/));
		},
		
};

/*********************************************
 * Drag and drop
 *********************************************/

let DragDrop={

	initialized:false,
	dragging:false,
	draggedElement:null,
	startX:null,
	startY:null,
	offsetX:null,
	offsetY:null,
	oldZIndex:null,
	
	initialize:function(){
		DragDrop.initialized=true;
		document.addEventListener("mousedown", DragDrop.mouseDown);
		document.addEventListener("mousemove", DragDrop.mouseMove);
		document.addEventListener("mouseup", DragDrop.mouseUp);
	},
	
	setup:function(draggables, droppables, doneCallback, abortCallback){
		if(!DragDrop.initialized){
			DragDrop.initialize();
		}
		if(!draggables || 0===draggables.length){ return false; }
		if(!droppables || 0===droppables.length){ return false; }
		draggables.forEach(function(draggable){
			draggable.classList.add("draggable");
			draggable.droppables=droppables;
			draggable.dragDoneCallback=doneCallback;
			draggable.dragAbortedCallback=abortCallback;
		});
	},

	
	
	mouseDown:function(e){
		let elem=e.target;
		if(!elem.classList.contains("draggable") && !elem.classList.contains("handle")){ return false; }
		if(elem.classList.contains("handle")){
			elem=elem.closest(".draggable");
		}
		DragDrop.dragging=true;
		DragDrop.draggedElement=elem;
		DragDrop.draggedElement.classList.add("dragging");
		let posX, posY;
		if(elem.closest(".boxbody")){
			let oldParent=elem.closest(".boxbody");
			posX=ui.cumulativeOffset(elem).left-ui.cumulativeOffset(oldParent.parentElement.parentElement).left;
			posY=ui.cumulativeOffset(elem).top-ui.cumulativeOffset(oldParent.parentElement.parentElement).top;

			elem.oldParent=oldParent;
			if(elem.nextSibling){ elem.oldNextSibling=elem.nextSibling; }
			if("absolute"!==elem.style.position){
				elem.dataset.wasrelative="1";
			}
			elem.dataset.wastop=ui.positionedOffset(elem).top+"";
			elem.dataset.wasleft=ui.positionedOffset(elem).left+"";
			elem.setStyle({
				width:elem.measure("width")+"px",
				height:elem.measure("height")+"px"
			});
			elem.closest(".box").parentElement.appendChild(elem.remove());
		} else {
			posX=ui.positionedOffset(elem).left;
			posY=ui.positionedOffset(elem).top;
		}
		DragDrop.startX=e.clientX;
		DragDrop.startY=e.clientY;
		DragDrop.endX=null;
		DragDrop.endY=null;
		DragDrop.offsetX=posX;
		DragDrop.offsetY=posY;
		DragDrop.oldZIndex=elem.style.zIndex;
		if(!elem.droppables){ return false; }
		elem.style.zIndex="10000";
		elem.droppables.forEach(function(droppable){
			droppable.classList.add("droppable");
			droppable.leftEdge=ui.cumulativeOffset(droppable).left;
			droppable.rightEdge=droppable.leftEdge+droppable.getWidth();
			droppable.topEdge=ui.cumulativeOffset(droppable).top;
			droppable.bottomEdge=droppable.topEdge+droppable.getHeight();
		});
		document.body.focus();
		DragDrop.mouseMove(e);
		document.onselectstart=function(){ return false; }; //IE: Don't select text
		elem.ondragstart = function(){ return false; }; //IE: Don't drag images
		return false; //Non-IE: don't select text
	},
	
	mouseMove:function(e){
		if(!DragDrop.dragging || !DragDrop.draggedElement){
			return;
		}
		let elem=e.target;
		let de=DragDrop.draggedElement;
		de.style.left=(DragDrop.offsetX + e.clientX - DragDrop.startX)+"px";
		de.style.top =(DragDrop.offsetY + e.clientY - DragDrop.startY)+"px";
		document.querySelectorAll(".droppable").forEach(function(droppable){
			if(droppable.leftEdge<e.clientX && droppable.rightEdge>e.clientX && droppable.topEdge<e.clientY && droppable.bottomEdge>e.clientY){
				droppable.classList.add("activedroppable");
				DragDrop.activeDroppable=droppable;
			} else {
				droppable.classList.remove("activedroppable");
			}
		});
		document.body.focus();
		document.onselectstart=function(){ return false; }; //IE: Don't select text
		elem.ondragstart = function(){ return false; }; //IE: Don't drag images
		return false; //Non-IE: don't select text
	},
	
	mouseUp:function(e){
		if(!DragDrop.dragging || !DragDrop.draggedElement){
			return;
		}
		DragDrop.endX=e.clientX;
		DragDrop.endY=e.clientY;
		if(!DragDrop.activeDroppable){
			DragDrop.abortDrop();
			return false;
		}
		document.querySelectorAll(".droppable").forEach(function(droppable){
			droppable.classList.remove("droppable");
			droppable.classList.remove("activedroppable");
		});
		
		window.setTimeout(function(){ DragDrop.draggedElement.dragDoneCallback(DragDrop.draggedElement, DragDrop.activeDroppable); DragDrop.finishDrop(); },50);
		DragDrop.draggedElement.style.zIndex=DragDrop.oldZIndex;
	},

	abortDrop:function(){
		document.querySelectorAll(".droppable").forEach(function(droppable){
			droppable.classList.remove("droppable");
			droppable.classList.remove("activedroppable");
		});
		let dragged=DragDrop.draggedElement;
		dragged.style.left=(DragDrop.offsetX)+"px";
		dragged.style.top =(DragDrop.offsetY)+"px";
		dragged.offsetX=DragDrop.offsetX;
		dragged.offsetY=DragDrop.offsetY;
		if(dragged.oldParent){
			if(dragged.oldNextSibling){
				dragged.before(dragged.oldNextSibling);
			} else {
				dragged.oldParent.appendChild(dragged);
			}
		}
		DragDrop.dragging=false;
		DragDrop.draggedElement.classList.remove("dragging");
		if(dragged.dragAbortedCallback){
			dragged.dragAbortedCallback(dragged);
		}
		DragDrop.draggedElement=null;
		DragDrop.activeDroppable=null;
	},
	
	defaultOnDrop:function(){
		DragDrop.draggedElement.style.top="0";
		DragDrop.draggedElement.style.left="0";
		DragDrop.activeDroppable.appendChild(DragDrop.draggedElement);
	},
	
	finishDrop:function(){
		DragDrop.dragging=false;
		DragDrop.draggedElement.classList.remove("dragging");
		DragDrop.draggedElement=null;
		DragDrop.activeDroppable=null;
	}

};

/*********************************************
 * AJAX utilities
 *********************************************/


let AjaxUtils={

	request:function(uri, options){
		let xhr=new XMLHttpRequest();
		let method=options["method"] || "get";
		let postBody=options['postBody'] || "";
		if(options["parameters"]){
			if("get"!==method && undefined===options["parameters"]["csrfToken"]){
				options["parameters"]["csrfToken"]=csrfToken;
			}
			Object.keys(options["parameters"]).forEach(function(key){
				postBody+=key+"="+encodeURIComponent(parameters[key])+"&";
			});
		}
		if(options["requestHeaders"]){
			// requestHeaders:{ 'Authorization':'Bearer '+SynchwebShippingHandler.token }
		}
		xhr.open(method, uri, true);
		xhr.onload=function(){
			try{
				xhr.responseJSON=JSON.parse(xhr.responseText);
			} catch(ex) {
				//just eat it. Handler should fail it.
			}
			if(200===xhr.status || 201===xhr.status){
				options.onSuccess(xhr);
			} else if(401===xhr.status){
				ui.handleSessionExpired();
			} else {
				options.onFailure(xhr);
			}
		};
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.send(postBody);

	},

	//call this as the first line of any onSuccess handler. 
	checkResponse:function(transport){
		try {
			let json=JSON.parse(transport.responseText);
			if(json["notLoggedIn"]){
				document.location.href='/Login';
				return false;
			} else if(json.error){ 
				alert(json.error);
				return false; 
			}
		} catch(err) {
			//transport.status===0 is likely "request cancelled", e.g., page reload fired while
			//request was in progress (Chrome does this)
			if(0!==transport.status){
				alert("Something went wrong. The server said:\n\n"+transport.responseText);
			}
			return false;
		}
		return true;
	},
	
	/**
	 * Whether a previous request has failed the browser's cross-origin check. If true, the remote service does not
	 * send an Access-Control-Allow-Origin header allowing us to use it through AJAX, and we need to use the IceBear
	 * server as a proxy.
	 */
	remoteAjaxNeedsProxy:false,

	/**
	 * Submits the AJAX request to the remote server. If this request fails the cross-origin check, or a previous 
	 * request has failed it, the request is forwarded to remoteAjaxWithProxy. Note that this does not distinguish
	 * between domains: If one request from a given IceBear page fails CORS, all subsequent requests will be routed
	 * via the IceBear proxy regardless of whether they are for the domain that failed.
	 */
	remoteAjax:function(uri, method, parameters, onSuccess, onFailure, headers){
		if(AjaxUtils.remoteAjaxNeedsProxy){
			AjaxUtils.remoteAjaxWithProxy(uri, method, parameters, onSuccess, onFailure, headers);
			return;
		}
		let request={
			method:method,
			onSuccess:function(transport){
				if(0===transport.status){
					AjaxUtils.remoteAjaxNeedsProxy=true;
					AjaxUtils.remoteAjaxWithProxy(uri, method, parameters, onSuccess, onFailure, headers);
					return false;
				}
				onSuccess(transport);
			},
			onFailure:function(transport){
				if(0===transport.status){
					AjaxUtils.remoteAjaxNeedsProxy=true;
					AjaxUtils.remoteAjaxWithProxy(uri, method, parameters, onSuccess, onFailure, headers);
					return false;
				}
				onFailure(transport);
			},
		};
		if("object"===(typeof parameters).toLowerCase()){
			request.parameters=parameters;
		} else {
			request.postBody=parameters;
		}
		if(headers){
			request.requestHeaders=headers;
		}
		new Ajax.Request(uri, request);
	},
	
	/**
	 * Submits an AJAX request to IceBear, which will forward it to the supplied URI if the user is logged into
	 * IceBear. This is to bypass CORS restrictions in browsers under controlled circumstances.
	 * see remoteAjax above.
	 */
	remoteAjaxWithProxy:function(uri, method, parameters, onSuccess, onFailure, headers){
		if(!parameters){ parameters={}; }
		parameters['url']=uri;
		let request={
			method:method,
			onSuccess:function(transport){
				if(!transport.responseJSON){
					try {
						transport.responseJSON=JSON.parse(transport.responseText);
					} catch (e) {
						//Not JSON. Ignore it.
					}
				}
				onSuccess(transport);
			},
			onFailure:function(transport){
				if(!transport.responseJSON){
					try {
						transport.responseJSON=JSON.parse(transport.responseText);
					} catch (e) {
						//Not JSON. Ignore it.
					}
				}
				onFailure(transport);
			}
		};
		if("object"===(typeof parameters).toLowerCase()){
			request.parameters=parameters;
			if("get"!==method.toLowerCase()){
				parameters['csrfToken']=csrfToken;
				parameters['url']=uri;
			}
		} else {
			let params={};
			if("get"!==method.toLowerCase()){
				params['csrfToken']=csrfToken;
				params['rawPostBody']=parameters;
			}
			params['url']=uri;
			request.parameters=params;
		}
		if(headers){
			request.requestHeaders=headers;
		}
		new Ajax.Request('/api/corsproxy/',request);
	},
		
};


let Cookies= {
		
		set:function(cName, cValue, expiryDays) {
			if(!expiryDays){ expiryDays=180; }
		    let d = new Date();
		    d.setTime(d.getTime() + (expiryDays*24*60*60*1000));
		    let expires = "expires="+d.toUTCString();
		    document.cookie = cName + "=" + cValue + "; " + expires;
		},
		
		get:function(cname) {
		    let name = cname + "=";
		    let ca = document.cookie.split(';');
		    for(let i=0; i<ca.length; i++) {
		        let c = ca[i];
		        while (c.charAt(0)===' ') c = c.substring(1);
		        if (c.indexOf(name) === 0) return c.substring(name.length,c.length);
		    }
		    return null;
		}
};

let UserConfig={
		
		items:{},
		
		get:function(name, defaultValue){
			if(!userId){ return defaultValue; }
			if(!UserConfig.items[name]){
				UserConfig.items[name]=defaultValue;
				window.setTimeout(function(){ UserConfig.set(name, defaultValue); }, 50);
				return defaultValue;
			}
			return UserConfig.items[name];
		},
		
		set:function(name, newValue){
			UserConfig.items[name]=newValue;
			new Ajax.Request('/api/userconfig/'+name,{
				method:'patch',
				postBody:'csrfToken='+csrfToken+'&'+name+'='+newValue
			});
		},

};


let Login={

		 doLogin: function(){
			let box=document.getElementById("loginbox");
			let username=document.getElementById('username').value;
			let password=document.getElementById('password').value;
			/* DISABLE RFID LOGIN - 20180319
			if(username.match(rfid) && ""==password){
				document.getElementById("username").blur();
				box.rfid=username;
				document.getElementById("username").value="";
				document.getElementById("username").focus();
				doRfidLogin();
				return;
			}
			*/
			if(""===username || ""===password){
				box.querySelector("h2").innerHTML="Username and password required";
				return false;
			}
			box.querySelector("input[type=submit]").closest("label").classList.add("updating");
			if(box.rfid){
				Login.doRfidRegister();
				return;
			}
			new Ajax.Request('/api/Login',{
				method:'post',
				parameters:{
					username:username,
					password:password,
				},
				onSuccess:Login.doLogin_onSuccess,
				onFailure:Login.doLogin_onFailure
			});
			return false; //don't submit the form as well.
		},
		doLogin_onSuccess: function(transport){
			if(!codeAndDbMatch){
				let isAdmin=1*transport.responseJSON["isadmin"];
				if(!isAdmin){
					transport.responseJSON.error=("That account is not an administrator");
					return Login.doLogin_onFailure(transport);
				}
				requestedUri="/config/#version";
			}
			if(""===requestedUri){ requestedUri="/"; }
			window.location.href=requestedUri;
			ui.forceReload();
		},
		doLogin_onFailure: function(transport){
		 	let box=document.getElementById("loginbox");
			box.querySelector(".updating").classList.remove("updating");
			if(transport.responseJSON && transport.responseJSON.error){
				box.querySelector("h2").innerHTML=transport.responseJSON.error;
			} else {
				alert("There was an error\n\n"+transport.responseText);
			}
		},

		doRfidLogin: function(){
			let box=document.getElementById("loginbox");
			let usernameBox=document.getElementById('username');
			if(8>usernameBox.value.length){
				window.setTimeout(Login.doRfidLogin, 100);
				return;
			}
			box.querySelector("input[type=submit]").closest("label").classList.add("updating");
			usernameBox.value="";
			document.getElementById('password').value="";
			new Ajax.Request('/api/Login',{
				method:'post',
				parameters:{
					rfid:box.rfid,
				},
				onSuccess:Login.doRfidLogin_onSuccess,
				onFailure:Login.doRfidLogin_onFailure
			});
			return false; //don't submit the form as well.
		},
		doRfidLogin_onSuccess: function(transport){
			Login.doLogin_onSuccess(transport);
		},
		doRfidLogin_onFailure: function(transport){
			let box=document.getElementById("loginbox");
			box.querySelector(".updating").classList.remove("updating");
			if(401===transport.status && transport.responseJSON && transport.responseJSON.error){
				box.querySelector("h2").innerHTML='Card not known. Sign in to register it.';
			} else {
				alert("There was an error\n\n"+transport.responseText);
			}
		},

		doRfidRegister: function(){
			let box=document.getElementById("loginbox");
			let userField=document.getElementById('username');
			let passField=document.getElementById('password');
			let username=userField.value;
			let password=passField.value;
			let rfid=box.rfid;
			box.querySelector("input[type=submit]").closest("label").classList.add("updating");
			userField.value="";
			passField.value="";
			new Ajax.Request('/api/Login',{
				method:'post',
				parameters:{
					username:username,
					password:password,
					rfid:rfid,
				},
				onSuccess:Login.doRfidRegister_onSuccess,
				onFailure:Login.doLogin_onFailure
			});
			return false; //don't submit the form as well.
		},
		doRfidRegister_onSuccess: function(){
			let box=document.getElementById("loginbox");
			box.rfid=null;
			box.querySelector(".updating").classList.remove("updating");
			box.querySelector("h2").innerHTML="Now touch your card again to log in";
			window.setTimeout(function(){ document.getElementById("username").focus(); },50);
		},
		doRfidRegister_onFailure: function(transport){
			document.getElementById("loginbox").querySelector(".updating").classList.remove("updating");
			if(401===transport.status && transport.responseJSON && transport.responseJSON.error){
				document.getElementById("rfidbox_body").innerHTML='<p>'+transport.responseJSON.error+'</p>';
				window.setTimeout(function(){ document.getElementById("username").focus(); },50);
			} else {
				alert("There was an error\n\n"+transport.responseText);
			}
			
		},

		maskRfidLogin: function(){
			let field=document.getElementById("username");
			if(field.value.match(rfid)){
				field.type="password";
			} else {
				field.type="text";
			}
		},
		
		logOut: function(){
			if(!confirm("Really log out?")){ return false; }
			new Ajax.Request("/api/Logout",{
				method:'post',
				onSuccess:ui.forceReload,
				onFailure:function(transport){
					let msg="The server reported an error.";
					if(transport.responseJSON && transport.responseJSON.error){
						msg+="\n\n"+transport.responseJSON.error;
					}
					alert(msg);
					ui.forceReload();
				}
			});
		},
						
};

/**
 * Functions for rendering and updating the header search box.
 */
let HeaderSearchBox={

		regex:/^[A-Za-z0-9?*_-]*$/g,
		
		onUpdate:function(elem,event){
			if(null!=event && event.keyCode){
				let k=event.keyCode;
				if(37===k || 39===k){ return; } //left/right arrow
				if(38===k){ HeaderSearchBox.selectPrevious(); return; } //Up arrow
				if(40===k){ HeaderSearchBox.selectNext(); return; } //Down arrow
				if(13===k){ HeaderSearchBox.goToSelected(); return; } //Enter
				if(27===k){ HeaderSearchBox.stop(); return; } //Escape
			}
			let terms=elem.value.trim();
			if(""===terms || !terms.match(HeaderSearchBox.regex)){ return false; }
			if(2>=terms.length){
				HeaderSearchBox.stop(elem);
			} else if(elem.searchresults && 0<elem.searchresults.length && 0===elem.value.indexOf(elem.searchresults.searchterms)){
				HeaderSearchBox.updateResults(elem);
			} else {
				HeaderSearchBox.search(elem,terms);
			}
		},
		
		search:function(elem,terms){
			elem.searchterms='';
			elem.searchresults=[];
			if(!elem.dataset.classlist){
				alert("Cannot search - no list of types to search for. See an admin."); 
				return false;
			}
			elem.classList.add("updating");
			new Ajax.Request("/api/search/"+encodeURIComponent(terms)+"?pagenumber=1&pagesize=50&classes="+elem.dataset.classlist,{
				method:"get",
				onSuccess:function(transport){ HeaderSearchBox.search_onSuccess(transport,elem); },
				onFailure:function(transport){ HeaderSearchBox.search_onFailure(transport,elem); },
			});
		},
		
		search_onSuccess:function(transport,elem){
			elem.classList.remove("updating");
			//are these results still valid?
			if(0!==elem.value.toLowerCase().indexOf(transport.responseJSON.searchterms.toLowerCase())){
				return _doAjaxSearch(elem);
			}
			elem.searchterms=transport.responseJSON.searchterms;
			elem.searchresults=transport.responseJSON.rows;
			HeaderSearchBox.makeResultsBox(elem);
			HeaderSearchBox.updateResults(elem);
			document.getElementById("searchboxresults").style.display="block";
		},
		
		search_onFailure:function(transport,elem){
			let r=document.getElementById("searchboxresults");
			if(401===transport.status){
				r.style.display="none";
	        	ui.handleSessionExpired();
				return;
			}
			HeaderSearchBox.makeResultsBox(elem);
			elem.searchresults=[];
			HeaderSearchBox.updateResults(elem);
			r.style.display="none";
		},

		makeResultsBox:function(elem){
			if(!document.getElementById("searchboxresults")){
				let rect=elem.getBoundingClientRect();
				let sb=document.createElement("div");
				sb.id="searchboxresults";
				sb.className="box hastable";
				document.body.appendChild(sb);
				sb.style.top=rect.bottom+"px";
				sb.style.right=(document.getElementById("header").getWidth()-(rect.left+rect.width))+"px";
				sb.style.width="0";
				sb.style.minWidth=elem.getWidth()+"px";
			}
		},
		
		updateResults:function(elem){
			let rows=elem.searchresults;
			let rect=elem.getBoundingClientRect();
			let sb=document.getElementById("searchboxresults");
			sb.style.top=rect.bottom+"px";
			sb.style.right=(document.getElementById("header").getWidth()-(rect.left+rect.width))+"px";
			sb.style.width="0";
			sb.style.minWidth=elem.getWidth()+"px";
			sb.innerHTML="<table></table>";
			let t=sb.querySelector("table");
			while(t.firstElementChild){ t=t.firstElementChild; }

			let pattern=elem.value.toLowerCase().replace("?",".?").replace("*",".*");
			rows.forEach(function(r){
				if(!r.name.toLowerCase().match(pattern)){ return; /*from this iteration of the loop*/ }
				let tr=document.createElement("tr");
				t.appendChild(tr);
				let imageTitle=r["objecttype"].charAt(0).toUpperCase() + r["objecttype"].slice(1);
				tr.innerHTML+='<td><a href="/'+r["objecttype"]+'/'+r.id+'"><img alt="" title="'+imageTitle+'" src="/images/icons/'+skin["bodyicontheme"]+'/header/bc_'+r["objecttype"]+'.png" style="height:1.5em;margin-right:0.5em"/>'+r.name.replace(/\s/g, "&nbsp;")+'</a></td>';
			});
			sb.querySelector("tr").classList.add("selected");
			
			window.setTimeout(function(){
				sb.style.width=(16+Math.max(t.getWidth(),elem.getWidth()))+"px";
			},10);
			
		},
		
		selectPrevious:function(){
			let sb=document.getElementById("searchboxresults");
			if(!sb){ return false; }
			let sel=sb.querySelector(".selected");
			if(sel.previousElementSibling){
				sel.classList.remove("selected");
				sel.previousElementSibling.classList.add("selected");
				sel.previousElementSibling.scrollIntoView({ behavior:"smooth" });
			}
		},
		
		selectNext:function(){
			let sb=document.getElementById("searchboxresults");
			if(!sb){ return false; }
			let sel=sb.querySelector(".selected");
			if(sel.nextElementSibling){
				sel.classList.remove("selected");
				sel.nextElementSibling.classList.add("selected");
				sel.nextElementSibling.scrollIntoView({ behavior:"smooth" });
			}
		},

		goToSelected:function(){
			let sb=document.getElementById("searchboxresults");
			if(!sb){ return false; }
			let sel=sb.querySelector(".selected");
			sel.classList.remove("selected");
			sel.classList.add("updating");
			document.location.href=sel.querySelector("a").href;
		},
		
		stop:function(elem){
			elem.classList.remove("updating");
			if(document.getElementById("searchboxresults")){
				window.setTimeout(function(){
					document.getElementById("searchboxresults").style.display="none";
				}, 100);
			}
		}
		
};


/*********************************************
 * Note functionality
 *********************************************/

let Note={

	/**
	 *
	 * @param parentElement The element into which the buttons should be written.
	 * @param noteBoxId The ID of the note text box that these buttons should update. This need not exist yet when calling
	 * 					this function, but must exist when the button is clicked.
	 * @param buttonDescriptions An array of objects, each having two properties:
	 * 					- "label", used for the button text
	 * 					- "note", the text to be inserted into the note box when this button is clicked
	 * @param buttonStyle Any extra CSS needed to style the buttons
	 * @returns {boolean}
	 */
	writeQuickNoteButtons:function(parentElement, noteBoxId, buttonDescriptions,  buttonStyle){
		if(!buttonStyle){ buttonStyle=""; }
		if(!parentElement){ return false; }
		buttonDescriptions.forEach(function(desc){
			let btn=document.createElement("input");
			btn.type="button";
			btn.dataset.noteText=desc.note;
			btn.dataset.noteBoxId=noteBoxId;
			btn.value=desc.label;
			btn.style=buttonStyle;
			btn.style.cursor="pointer";
			btn.addEventListener("click", Note.toggleQuickNote);
			parentElement.appendChild(btn);
		});
		return true;
	},

	/**
	 * Handles a click on a "quick note" button. The button must have dataset.noteText and dataset.noteBoxId.
	 * If the supplied text is present and followed by a newline (\n), it will be removed; if not, it will be added at the
	 * beginning of the textarea followed by a newline.
	 * @param evt The click event on the note button.
	 */
	toggleQuickNote:function(evt){
		let btn=evt.target;
		let notesBox=document.getElementById(btn.dataset.noteBoxId);
		let noteText=btn.dataset.noteText+"\n";
		if(!notesBox || !noteText){ return false; }
		if(-1===notesBox.value.indexOf(noteText)){
			//Quick note not present. Add it.
			notesBox.value=noteText+notesBox.value;
		} else {
			//Quick note is present. Remove it.
			notesBox.value=notesBox.value.replace(noteText,"");
		}
	}

};


/*********************************************
 * Audio recording functionality
 *********************************************/
let AudioRecording={

	recorder:null,

	/**
	 * Initialises the supplied element as an audio field. Typically this will be a label element in a form, as written
	 * by ui.audioField.
	 * @param elem The element to initialize.
	 * @param options
	 *  - baseObjectId: The ID of the object to which recordings should be attached. Defaults to data.id
	 *  - maxPrevious: Show no more than this many previous recordings
	 *  - readonly: If true, don't render recording controls
	 */
	init: function(elem,options){
		if(!options){ options={}; }
		elem.options=options;
		elem.classList.add("audiofield");
		if(elem.querySelector("span.label")){
			elem.querySelector("span.label").remove();
		}
		let baseObjectId=options['baseObjectId'];
		if(!baseObjectId && data && data.id){
			baseObjectId=data.id;
		}
		if(elem.querySelector(".recordingcontrols")){
			//Resetting after making a recording, so re-use the baseObjectId
			baseObjectId=elem.querySelector(".recordingcontrols").dataset.parentObjectId;
			//and nuke the innerHTML
		}
		elem.innerHTML="";
		if(!baseObjectId){
			elem.innerHTML='Could not write audio field. No baseObjectId supplied and no data.id in page.';
			return false;
		}
		elem.dataset.parentObjectId=baseObjectId;
		if(undefined===options.readonly || 1!==1*options.readonly){
			//write recording controls
			let recordingControls=document.createElement("div");
			recordingControls.dataset.parentObjectId=baseObjectId;
			recordingControls.className="recordingcontrols";
			let img=document.createElement("img");
			img.src="/images/icons/"+skin["bodyicontheme"]+"/btn_mic.gif";
			recordingControls.appendChild(img);
			let msg=document.createElement("span");
			msg.className="recordingmessage";
			recordingControls.appendChild(msg);
			recordingControls.chunks=[];
			if(!window.MediaRecorder){
				msg.innerHTML+="Your browser doesn't support recording audio.";
				recordingControls.classList.add("recordingerror");
			} else if(!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia){
				msg.innerHTML+="Can't record audio. Ask your IceBear administrator about this.";
				recordingControls.classList.add("recordingerror");
			} else {
				msg.innerHTML+="Click to record audio notes";
				recordingControls.onclick=AudioRecording.start;
			}
			elem.appendChild(recordingControls);
		}
		let previousRecordingsDiv=document.createElement("div");
		previousRecordingsDiv.className="recordings";
		elem.appendChild(previousRecordingsDiv);
		AudioRecording.getPreviousRecordings(elem);
	},

	getPreviousRecordings:function (elem, successHandler, failureHandler) {
		if(!successHandler){ successHandler=AudioRecording.getPreviousRecordings_onSuccess; }
		if(!failureHandler){ failureHandler=AudioRecording.getPreviousRecordings_onFailure; }
		new Ajax.Request('/api/baseobject/'+elem.dataset.parentObjectId+'/recording?sortby=id&sortdescending=yes',{
			method:'get',
			onSuccess:function (transport) { successHandler(transport.responseJSON, elem); },
			onFailure:function (transport) { failureHandler(transport, elem); }
		});
	},

	getPreviousRecordings_onSuccess:function(recordings, elem){
		let previousRecordingsDiv=elem.querySelector('.recordings');
		previousRecordingsDiv.innerHTML="";
		if(recordings["rows"]){
			recordings=recordings["rows"];
			let counter=0;
			let options=elem.options;
			recordings.forEach(function(r){
				if(!options || !options["maxPrevious"] || counter<options["maxPrevious"]){
					previousRecordingsDiv.innerHTML+='<div><audio controls="controls" src="/api/audiorecordingfile/'+r.id+'"></audio> By <a href="/user/'+r.userid+'">'+r["userfullname"]+'</a> '+ui.friendlyDateTime(r["datetime"])+'</div>';
				}
				counter++;
			});
		}
	},

	getPreviousRecordings_onFailure:function(transport, elem){
		let previousRecordingsDiv=elem.querySelector('.recordings');
		let controlsDiv=elem.querySelector('.recordingcontrols');
		previousRecordingsDiv.innerHTML='';
		if(404===transport.status) {
			if(!controlsDiv || ""===controlsDiv.innerHTML){
				elem.remove();
			}
		} else {
			previousRecordingsDiv.innerHTML='Could not fetch previous recordings';
		}
	},

	start:function(evt){
		let recordingDiv=evt.target.closest(".recordingcontrols");
		let msg=recordingDiv.querySelector(".recordingmessage");
		if(AudioRecording.recorder){
			return false;
		}
		msg.innerHTML="Waiting for microphone permissions...";
		let constraints={ audio:true };
		navigator.mediaDevices.getUserMedia(constraints)
			.then(function(stream) {
				let options={
					mimeType:'audio/webm;codecs=opus'
				};
				AudioRecording.recorder=new MediaRecorder(stream,options);
				AudioRecording.recorder.ondataavailable = function(e) {
					recordingDiv.chunks.push(e.data);
				};
				recordingDiv.onclick=AudioRecording.stop;
				AudioRecording.recorder.start();
				recordingDiv.classList.add("recording");
				msg.innerHTML="Recording...";
			})
			.catch(function(err) {
				recordingDiv.style.backgroundColor="#f99";
				recordingDiv.innerHTML=err.message+" ("+err.name+")";
				recordingDiv.classList.add("recordingerror");
			});
	},

	stop:function(evt) {
		AudioRecording.recorder.stop();
		let recordingDiv = evt.target.closest(".recordingcontrols");
		window.setTimeout(function(){
			AudioRecording.afterStop(recordingDiv);
		},50);
	},
	afterStop:function(recordingDiv){
		recordingDiv.classList.remove("recording");
		recordingDiv.querySelector(".recordingmessage").innerHTML="Saving, please wait...";
		recordingDiv.closest("label").classList.add("updating");
		window.setTimeout(function(){
			AudioRecording.save(recordingDiv);
		},1000)
	},

	save:function(recordingDiv){
		let formData=new FormData();
		formData.append("csrfToken",csrfToken);
		formData.append("parentid",recordingDiv.dataset.parentObjectId);
		formData.append("audiodata", new Blob(recordingDiv.chunks), 'audio.ogg');
		let xhr=new XMLHttpRequest();
		xhr.open('post', '/api/audiorecording/', true);
		xhr.onload=function(){
			try{
				xhr.responseJSON=JSON.parse(xhr.responseText);
			} catch(ex) {
				//just eat it
			}
			if(400>xhr.status){
				AudioRecording.onUploadSuccess(xhr,recordingDiv);
			} else if(401===xhr.status){
				ui.handleSessionExpired();
			} else {
				AudioRecording.onUploadFailure(xhr,recordingDiv);
			}
		};
		xhr.send(formData);
	},

	onUploadSuccess:function(xhr,recordingDiv){
		recordingDiv.chunks=[];
		recordingDiv.onclick=AudioRecording.start;
		AudioRecording.recorder=null;
		recordingDiv.closest("label").classList.remove("updating");
		//wipe recordings list and reload
		let audioField=recordingDiv.closest("label");
		AudioRecording.init(audioField, audioField.options);
	},

	onUploadFailure:function(xhr, recordingDiv){
		recordingDiv.closest("label").classList.remove("updating");
		alert("There was a problem uploading the audio to the server.");
		let msg;
		if(xhr.responseJSON && xhr.responseJSON.error){
			msg=xhr.responseJSON.error;
		} else {
			msg=xhr.responseText;
		}
		alert("There was a problem uploading the audio to the server.\n\n"+msg);
	},

};


/*********************************************
 * Homepage functionality
 * - brick parsing and rendering
 * - drag-drop actions
 *********************************************/

let Homepage={
	toggleConfig:function(){
		if(document.getElementById("configbutton").isActive){
			Homepage.stopConfig();
		} else {
			Homepage.startConfig();
		}
	},
	startConfig:function(){
		document.body.style.overflow="hidden";
		document.getElementById("configbutton").isActive=true;
		document.querySelectorAll(".box").forEach(function(box){
			let h2=box.querySelector("h2");
			h2.innerHTML='<span class="closeicon" >&nbsp;</span>'+h2.innerHTML;
			h2.classList.add("handle");
		});
		DragDrop.setup(document.querySelectorAll(".box"),document.querySelectorAll(".boxslot"),Homepage.onDrop);
		document.querySelectorAll(".closeicon").forEach(function(ci){
			ci.addEventListener("click",Homepage.removeBrick);
		});
		document.querySelectorAll(".boxslot").forEach(function(s){
			s.addEventListener("mouseover",function(){ s.classList.add("activedroppable"); });
			s.addEventListener("mouseout",function(){ s.classList.remove("activedroppable"); });
			s.addEventListener("click",function(){ Homepage.startAdd(s) });
		});
	},
	stopConfig:function(){
		document.getElementById("configbutton").isActive=false;
		document.querySelectorAll(".closeicon").forEach(function(ci){
			ci.remove();
		});
	},

	onDrop:function(box, slot){
		let boxWidth = 1;
		let boxHeight = 1;
		let slotRow = 1;
		let slotCol = 1;
		if(box.classList.contains("w2")){ boxWidth=2; }
		if(box.classList.contains("w3")){ boxWidth=3; }
		if(box.classList.contains("h2")){ boxHeight=2; }
		if(box.classList.contains("h3")){ boxHeight=3; }
		if(slot.classList.contains("r2")){ slotRow=2; }
		if(slot.classList.contains("r3")){ slotRow=3; }
		if(slot.classList.contains("c2")){ slotCol=2; }
		if(slot.classList.contains("c3")){ slotCol=3; }
		const bottomEdge = slotRow + boxHeight - 1;
		const rightEdge = slotCol + boxWidth - 1;
		if(bottomEdge>3 || rightEdge>3){
			DragDrop.abortDrop();
			return false;
		}

		//Don't allow bricks to overlap
		let occupied = [];
		occupied.push([-1,-1,-1,-1]);
		occupied.push([-1,0,0,0]);
		occupied.push([-1,0,0,0]);
		occupied.push([-1,0,0,0]);
		document.querySelectorAll(".box").forEach(function(b){
			if(b.id!==box.id) {
				const h = 1 * b.dataset.h;
				const w = 1 * b.dataset.w;
				const r = 1 * b.dataset.r;
				const c = 1 * b.dataset.c;
				for (let row = r; row < r + h; row++) {
					for (let col = c; col < c + w; col++) {
						occupied[row][col] = 1;
					}
				}
			}
		});
		for(let r=slotRow;r<slotRow+boxHeight;r++){
			for(let c=slotCol;c<slotCol+boxWidth;c++){
				if(1===occupied[r][c]){
					DragDrop.abortDrop();
					return false;
				}
			}
		}

		box.classList.remove("r1","r2","r3");
		box.classList.remove("c1","c2","c3");
		if(slot.classList.contains("r1")){ box.classList.add("r1"); box.dataset.r="1"; }
		if(slot.classList.contains("c1")){ box.classList.add("c1"); box.dataset.c="1"; }
		if(slot.classList.contains("r2")){ box.classList.add("r2"); box.dataset.r="2"; }
		if(slot.classList.contains("c2")){ box.classList.add("c2"); box.dataset.c="2"; }
		if(slot.classList.contains("r3")){ box.classList.add("r3"); box.dataset.r="3"; }
		if(slot.classList.contains("c3")){ box.classList.add("c3"); box.dataset.c="3"; }
		box.style.left=null;
		box.style.top=null;
		let patchUrl;
		if(null!=box.dataset.homepageuserbrickid){
			patchUrl='/api/homepageuserbrick/'+box.dataset.homepageuserbrickid;
		} else {
			patchUrl='/api/homepagedefaultbrick/'+box.dataset.homepagedefaultbrickid;
		}
		new Ajax.Request(patchUrl, {
			method:"patch",
			postBody:"csrfToken="+csrfToken+"&row="+slotRow+"&col="+slotCol,
			onSuccess:Homepage.drop_onSuccess,
			onFailure:Homepage.drop_onFailure
		});
	},
	drop_onSuccess:function(transport){
		AjaxUtils.checkResponse(transport);
	},
	drop_onFailure:function(transport){
		AjaxUtils.checkResponse(transport);
	},

	removeBrick:function(evt){
		const closeIcon = evt.target;
		const box = closeIcon.closest(".box");
		if(!confirm("Remove the brick?")){
			return false;
		}
		let deleteUrl;
		if(null!=box.dataset.homepageuserbrickid){
			deleteUrl='/api/homepageuserbrick/'+box.dataset.homepageuserbrickid;
		} else {
			deleteUrl='/api/homepagedefaultbrick/'+box.dataset.homepagedefaultbrickid;
		}
		new Ajax.Request(deleteUrl, {
			method:"delete",
			postBody:"csrfToken="+csrfToken,
			onSuccess:function(transport){ Homepage.remove_onSuccess(transport,box) },
			onFailure:Homepage.remove_onFailure
		});
	},
	remove_onSuccess:function(transport,box){
		AjaxUtils.checkResponse(transport);
		box.remove();
	},
	remove_onFailure:function(transport){
		AjaxUtils.checkResponse(transport);
	},


	startAdd:function(slot){
		slot.classList.remove("activedroppable");
		ui.modalBox({
			title: "Add brick to homepage",
			content: "Loading..."
		});
		new Ajax.Request("/api/homepagebrick",{
			method:'get',
			onSuccess:function(transport){ Homepage.startAdd_onSuccess(transport, slot); },
			onFailure:Homepage.startAdd_onFailure
		});
	},

	startAdd_onSuccess:function(transport, destinationSlot){
		if(!AjaxUtils.checkResponse(transport)){
			return false;
		}
		const addRow = 1 * destinationSlot.dataset.gridrow;
		const addCol = 1 * destinationSlot.dataset.gridcol;
		//calculate fit/non-fit sizes, then:
		let fittingBricks = [];
		let nonFittingBricks = [];
		let fittingSizes = [];
		let nonFittingSizes = [];
		fittingSizes.push("1x1"); //they clicked on this square, so it's open
		if(addRow>=3){ //double height won't fit on bottom
			nonFittingSizes.push("2x1");
			nonFittingSizes.push("2x2");
			nonFittingSizes.push("2x3");
		}
		if(addRow>=2){ //triple height won't fit in middle row
			nonFittingSizes.push("3x1");
			nonFittingSizes.push("3x2");
			nonFittingSizes.push("3x3");
		}
		if(addCol>=3){ //double width won't fit in right-hand column
			nonFittingSizes.push("1x2");
			nonFittingSizes.push("2x2");
			nonFittingSizes.push("3x2");
		}
		if(addRow>=2){ //triple width won't fit in middle column
			nonFittingSizes.push("1x3");
			nonFittingSizes.push("2x3");
			nonFittingSizes.push("3x3");
		}
		let occupied=[];
		occupied.push([-1,-1,-1,-1]);
		occupied.push([-1,0,0,0]);
		occupied.push([-1,0,0,0]);
		occupied.push([-1,0,0,0]);
		document.querySelectorAll(".homepagebrick").forEach(function(b){
			const h = 1 * b.dataset.h;
			const w = 1 * b.dataset.w;
			const r = 1 * b.dataset.r;
			const c = 1 * b.dataset.c;
			for(let row=r;row<r+h;row++){
				for(let col=c;col<c+w;col++){
					occupied[row][col]=1;
				}
			}
		});
		transport.responseJSON.rows.forEach(function(brick){
			if(!document.getElementById(brick.name)){
				//not already in the layout
				const h = brick.height * 1;
				const w = brick.width * 1;
				const brickSize = h + "x" + w;
				if(fittingSizes.indexOf(brickSize)>-1){
					fittingBricks.push(brick);
				} else if(nonFittingSizes.indexOf(brickSize)>-1){
					nonFittingBricks.push(brick);
				} else {
					//is brick going to overlap another if added at chosen spot? non-fitting. else fitting.
					let brickFits = true;
					for(let r=addRow;r<=addRow+h-1;r++){
						for(let c=addCol;c<=addCol+w-1;c++){
							if(1===occupied[r][c]){
								brickFits=false;
								break;
							}
						}
						if(!brickFits){ break; }
					}
					if(brickFits){
						fittingBricks.push(brick);
						fittingSizes.push(brickSize);
					} else {
						nonFittingBricks.push(brick);
						nonFittingSizes.push(brickSize);
					}
				}
			}
		});
		let mb=document.getElementById("modalBox");
		if(0===fittingBricks.length && 0===nonFittingBricks.length){
			mb.querySelector(".boxbody").innerHTML="No bricks are available to add to your homepage.";
			return;
		}
		mb.querySelector(".boxbody").classList.add("hastable");
		let out='<table>';
		if(0===fittingBricks.length){
			out+='<tr><th colspan="2" style="text-align:center;">No bricks will fit in that slot. These are available but won\'t fit:</th></tr>';
		} else {
			out+='<tr><th colspan="2" style="text-align:center;">Available bricks:</th></tr>';
			fittingBricks.forEach(function(brick){
				let icon='<span title="'+brick.height+"x"+brick.width+' brick" class="bricksizeicon h'+brick.height+"w"+brick.width+'">&nbsp;</span>';
				out+='<tr class="bricklist" id="add_'+brick.name+'"><th>'+icon+'&nbsp;'+brick.title+'</th><td>'+brick.description+'</td></tr>';
			});
			if(0!==nonFittingBricks.length){
				out+='<tr><th colspan="2" style="text-align:center;">These bricks are available but won\'t fit in that slot:</th></tr>';
			}
		}
		nonFittingBricks.forEach(function(brick){
			let icon='<span title="'+brick.height+"x"+brick.width+' brick" class="bricksizeicon h'+brick.height+"w"+brick.width+'">&nbsp;</span>';
			out+='<tr class="bricklist" id="add_'+brick.name+'"><th>'+icon+'&nbsp;'+brick.title+'</th><td>'+brick.description+'</td></tr>';
		});
		out+='</table>';
		mb.querySelector(".boxbody").innerHTML=out;
		fittingBricks.forEach(function(brick){
			let addBrick=document.getElementById('add_'+brick.name);
			addBrick.brick=brick;
			addBrick.style.cursor="pointer";
			addBrick.addEventListener("click", function(){ Homepage.addHomepageBrick(this); } );
			addBrick.addEventListener("mouseover", function(){ this.classList.add("activedroppable"); } );
			addBrick.addEventListener("mouseout", function(){ this.classList.remove("activedroppable"); } );
		});
		mb.activeSlot=destinationSlot;
	},

	startAdd_onFailure:function(boxId,transport){
		let msg=transport.responseText;
		if(transport.responseJSON && transport.responseJSON.error){
			msg=transport.responseJSON.error;
		}
		alert("Could not add brick to homepage. The server said:\n\n"+msg+"\n\n\When you click OK, the page will reload.");
		ui.forceReload();
	},

	addHomepageBrick: function(tr){
		tr.innerHTML='<th style="text-align:center;" colspan="2">Adding brick to homepage...</th>';
		const brick = tr.brick;
		const addDestination = document.getElementById("modalBox").activeSlot;
		const addRow = addDestination.dataset.gridrow;
		const addCol = addDestination.dataset.gridcol;
		new Ajax.Request(apiUrl,{
			method:'post',
			postBody:'homepagebrickid='+brick.id+'&row='+addRow+'&col='+addCol+'&csrfToken='+csrfToken,
			onSuccess:Homepage.addHomepageBrick_onSuccess,
			onFailure:Homepage.addHomepageBrick_onFailure
		});
	},
	addHomepageBrick_onSuccess: function(transport){
		if(!transport.responseJSON || !transport.responseJSON.created){
			return Homepage.addHomepageBrick_onFailure(transport);
		}
		Homepage.renderBrick(transport.responseJSON.created);
		Homepage.stopConfig();
		Homepage.startConfig();
		ui.closeModalBox();
	},
	addHomepageBrick_onFailure: function(transport){
		let msg=transport.responseText;
		if(transport.responseJSON && transport.responseJSON.error){
			msg=transport.responseJSON.error;
		}
		alert("Server reported an error:\n\n"+msg+"\n\nThe page will reload when you click OK.");
		ui.forceReload();
	},

	init:function(){
		new Ajax.Request(apiUrl,{
			method:"get",
			onSuccess:Homepage.init_onSuccess,
			onFailure:Homepage.init_onFailure
		});
	},
	init_onSuccess:function(transport){
		AjaxUtils.checkResponse(transport);
		transport.responseJSON.rows.forEach(function(b){
			b.headertemplates=eval(b.headertemplates);
			b.rowtemplates=eval(b.rowtemplates);
			Homepage.renderBrick(b);
		});
		if(isDefaultHomepage){ Homepage.startConfig(); }
		ui.smallScreenInit();
	},
	init_onFailure:function(transport){
		AjaxUtils.checkResponse(transport);
	},

	renderBrick:function(b){
		/** @namespace isAdmin **//* Defined in page header, IDE warnings hack */
		let box;
		let classes="homepagebrick r"+b.row+" c"+b.col+" w"+b.width+" h"+b.height;
		if(1===1*b["adminonly"] && !isAdmin){
			box = grid.box({
				id: b.name,
				classes: classes,
				title: b.title,
				content: '<h3>Admin-only brick</h3><p>This brick is useless because you\'re not an administrator.</p><input type="button" id="" value="Remove brick" class="removebutton"/>',
			});
			box=box.closest(".box");
			box.dataset.r=b.row;
			box.dataset.c=b.col;
			box.dataset.h=b.height;
			box.dataset.w=b.width;
			box.dataset.homepagebrickid=b.homepagebrickid;
			box.dataset.homepageuserbrickid=b.id;
			box.querySelector(".removebutton").addEventListener("click",Homepage.removeBrick);
			return;
		}
		let unescapedTemplates;
		if(b.rowtemplates){
			//For XSS prevention, all server responses are escaped. Brick templates are assumed safe, they should be
			//reviewed manually to ensure that this is the case. Unescape them here:
			unescapedTemplates=[];
			if('string'==typeof(b.rowtemplates)){
				b.rowtemplates=eval(b.rowtemplates);
			}
			b.rowtemplates.forEach(function(rt){
				if(typeof(rt)=="string"){
					let ta=document.createElement("textarea");
					ta.innerHTML=rt;
					rt=ta.textContent.trim();
				} else if(rt.length===2){
					rt=[ rt[0], rt[1] ];
				}
				unescapedTemplates.push(rt);
			});
		}
		if(b.headertemplates){
			b.headertemplates=eval(b.headertemplates);
		}
		//Script supplied in a homepage brick template is assumed to have been checked manually for safety.
		//Have to eval it to use it.
		let successHandler = null;
		if(b["scriptblock"]){
			let ta=document.createElement("textarea");
			ta.innerHTML=b["scriptblock"];
			eval(ta.textContent);
			if(document[b.name+"_functions"]!==undefined && document[b.name+"_functions"].onSuccess!==undefined){
				successHandler=document[b.name+"_functions"].onSuccess;
			}
		}
		box = grid.box({
			id: b.name,
			classes: classes,
			title: b.title,
			content: ui.unescapeHTML(b.content),
			url: ui.unescapeHTML(b.apiurl).replace('{{userid}}', currentUser.id),
			headers: b.headertemplates,
			cellTemplates: unescapedTemplates,
			successHandler: successHandler
		});
		box=box.closest(".box");
		box.dataset.r=b.row;
		box.dataset.c=b.col;
		box.dataset.h=b.height;
		box.dataset.w=b.width;
		box.dataset.homepagebrickid=b.homepagebrickid;
		if(isDefaultHomepage){
			box.dataset.homepagedefaultbrickid=b.id;
		} else {
			box.dataset.homepageuserbrickid=b.id;
		}
	}

}
