/**
 * Default shipment handler for synchrotrons without automated data submission, or where
 * submission is not (yet) supported by IceBear.
 * Generates the shipment manifest and marks the shipment as sent, but does not submit the shipment
 * to the synchrotron.
 */
window.DefaultShippingHandler={
		
		
		/**
		 * Returns the URL of this shipment at the remote synchrotron, or false if the shipment has not been submitted.
		 * Strips /api(/) from base API and appends /shipment/sid/[REMOTE ID].
		 */
		getShipmentUrlAtFacility:function(/* shipmentDestination, shipmentIdAtFacility */){
			return false;
		},
		
		/**
		 * Returns the URL of this crystal at the remote synchrotron, or false if the crystal does not have a remote ID.
		 * Strips /api(/) from base API and appends /samples/sid/[REMOTE ID].
		 */
		getCrystalUrlAtFacility:function(/* shipmentDestination, crystalIdAtFacility */){
			return false;
		},
		
		/**
		 * Begins the process of marking the shipment as sent.
		 * 
		 * It is assumed that local validation of the shipment has already been done! This includes 
		 * basic checks such as: at least one dewar; each dewar has at least one puck; all crystals
		 * have protein acronyms. Some validation can only be done at the synchrotron, but we should
		 * not be sending them shipments that fail these basic checks.
		 */
		begin:function(){
			if(data.dateshipped){
				alert("Shipment has already been sent.");
				return false;
			}
			if(!window.shipmentDestination){ 
				alert("No shipment destination set.");
				return false;
			}
			//Check still logged into IceBear, reset session clock - don't want to fail at the end.
			new Ajax.Request("/api/homepagebrick", {
				"method":"get",
				"onSuccess":DefaultShippingHandler.openShippingDialog,
				"onFailure":function(transport){
					if(401===transport.status){
						//IceBear session timed out. Reload page to show login form.
						ui.forceReload();
					} else {
						DefaultShippingHandler.openShippingDialog();
					}
				}
			});
			
		},

		openShippingDialog:function(){
			let out="<h3>IceBear can't submit shipments to "+window.shipmentDestination.name+".</h3>";
			out+="<p>You will need to enter the shipment into their systems, taking care to ensure that the shipment meets all their safety and other requirements.</p>";
			out+="<p>Click the button below to mark the shipment as \"Sent\" in IceBear and generate a shipping manifest.</p>";
			out+="<p><input type=\"button\" onclick=\"DefaultShippingHandler.completeShipment()\" value=\"Send shipment\" /></p>";
			ui.modalBox({ title:"Send shipment to "+window.shipmentDestination.name, content:out });
		},

		
		completeShipment:function(){
			//TODO Add a "Shipped" note to each crystal. Do it server side, see SynchwebShippingHandler.addNote
			let shippedDate=new Date().toISOString().split("T")[0];
			new Ajax.Request('/api/shipment/'+data.id,{
				'method':'patch',
				'parameters':{
					'csrfToken':csrfToken,
					'dateshipped':shippedDate
				},
				onSuccess:DefaultShippingHandler.completeShipment_onSuccess,
				onFailure:DefaultShippingHandler.completeShipment_onFailure,
			});
		},
		completeShipment_onSuccess:function(){
			ui.logToDialog("IceBear updated successfully.","success");
			ui.logToDialog("The page will reload in a moment. Please wait...");
			window.setTimeout(ui.forceReload, 2500);
		},
		completeShipment_onFailure:function(transport){
			ui.logToDialog("Could not update IceBear.","error");
			if(transport.responseJSON && transport.responseJSON.error){				
				ui.logToDialog(transport.responseJSON.error, "error");
			}			
			ui.logToDialog("The page will reload in a moment. Please wait...");
			window.setTimeout(ui.forceReload, 5000);
		},
		
};