<?php
include_once($_SERVER['DOCUMENT_ROOT'] . '/client/help/_common/helphead.php');
?>
<h1>Users</h1>
<p>Anyone who wants to use IceBear will need an account. Users can be put into usergroups. Usergroups, in turn, can be
    given permissions on projects.</p>

<h2>Creating a user account</h2>
<p>Only administrators can create new users in IceBear. If you integrate automated imagers with IceBear, user accounts may be
    created automatically.</p>
<p>From the main menu, select <strong>Create a user</strong>. Or, from the list of users, click the <strong>Create new...</strong>
    link in the page header.</p>
<figure>
    <img alt="" src="create.png" />
    <figcaption>The usergroup creation page.</figcaption>
</figure>
<p><strong>Username</strong> is the account name, used for logging in. This must be unique to your IceBear installation. Later
    versions of IceBear will integrate with your organization's LDAP or Active Directory systems, so you should put the new
    user's LDAP/AD username here if possible.</p>
<p><strong>Full name</strong> is the user's name, like "John Smith". This is how they will be shown throughout IceBear.</p>
<p><strong>Email address</strong> is self-explanatory. However, please note that this is how IceBear's imager integration identifies
    which user owns a particular plate; it's important that the email address you give here exactly matches the one in your imaging
    system's database. If you change this in the imaging system, you will also need to change it in IceBear, and vice versa.</p>
<p><strong>Password</strong> must be entered twice. Note that, at present, the password is NOT emailed to the user; you will need to
    notify them of this password manually, recommending that they change it immediately.</p>
<p>Click <strong>Create</strong> to create the user account. You will see the new user's page.</p>

<h2>Viewing and managing a user</h2>
<p>Depending on your permissions, some or all of this view may be editable.</p>
<figure>
    <img alt="" src="view_plates.png" />
    <figcaption>The user page, showing the user's basic details and plates.</figcaption>
</figure>
<h3>Basic details</h3>
<p>These are as described in "Creating a user" above.</p>
<p>Additionally, administrators can activate and de-activate the account. If the account is de-activated, the user cannot log in
    to IceBear.</p>
<p>Administrators can also set the user's supervisor. At the moment, this doesn't do anything; in a later version of IceBear,
    supervisors will automatically be given permission to view their supervisees' work.</p>
<h3>Changing the user's password</h3>
<p>Administrators can change a user's password at any time. Note that the new password is NOT emailed to the user.</p>
<p>Users can also change their own password at any time. However, they will need the old password. If they've forgotten it, they'll
    need to ask an administrator to reset it for them. Passwords cannot be recovered.</p>

<h3>The Plates tab</h3>
<p>This tab shows plates owned by the user, along with their associated project.</p>
<p>Depending on your own permissions, there may be more plates in projects that you can't see.</p>

<h3>The Groups tab</h3>
<figure>
    <img alt="" src="view_projects.png" />
    <figcaption>The user page, showing the user's project permissions.</figcaption>
</figure>
<p>This tab shows which projects the user has permission to see and to work in. Depending on your own privileges, the user may have permissions
    on additional projects that you aren't allowed to see.</p>
<p>These permissions are derived from the user's group memberships and those groups' project permissions. Where the user owns a project, they
    will have all permissions on that project.</p>
<p>Mouse over any of the green checkmarks to see where the permission came from.</p>
<p>These permissions cannot be edited here. To change the user's permissions, add the user to a group, remove them from a group, or change the
    project permissions on one of the user's existing groups.</p>

<h3>The Groups tab</h3>
<figure>
    <img alt="" src="view_groups.png" />
    <figcaption>The user page, showing the user's group memberships.</figcaption>
</figure>
<p>This tab shows all the usergroups that you are allowed to see, and whether this user belongs to them and has group admin privileges.
    Depending on your own permissions, you may be able to add the user to or remove them from a group, or grant or revoke their group
    admin privileges.</p>

<?php
include_once($_SERVER['DOCUMENT_ROOT'] . '/client/help/_common/helpfoot.php');
?>