<?php
include_once($_SERVER['DOCUMENT_ROOT'].'/client/help/_common/helphead.php');
?>

<h1>Shipments</h1>
<p>IceBear integrates with the ISPyB system at some synchrotrons to submit your shipment data automatically. The only thing
    you have to type is your synchrotron username and password.</p>
<p>The shipment page not only lets you assemble and send the shipment, but also gives you a convenient place to record notes
    during data collection and to manage the returned containers.</p>

<h2>Creating the shipment</h2>
<p>To create a shipment, select <strong>New shipment</strong> from the main menu.</p>
<p>You can also create a shipment from the Crystal Fishing page. Once you have fished your crystals and packaged them into
    dewars, click the "Ship this dewar" or "Ship these dewars" link in the bottom right of the page.</p>
<p>You will see the shipment creation form.</p>
<figure>
	<img alt="" src="create.png" />
	<figcaption>Creating a shipment.</figcaption>
</figure>

<p>Give the shipment a name, and set the destination synchrotron, then click <strong>Create</strong>.</p>

<h3>Permissions</h3>
<p>Typically, you will need to be in the Shippers or Administrators usergroup to create and send shipments.</p>

<h2>Assembling the shipment</h2>

<figure>
    <img alt="" src="beforeship.png" />
    <figcaption>Basic shipment details, with one dewar in the shipment.</figcaption>
</figure>
<p>The shipment view contains a details tab, plus one tab for every dewar in the shipment. If you created the shipment
    from the Crystal Fishing page, you will see your dewars here immediately after creating the shipment.</p>

<h3>Adding a dewar</h3>
<p>Click in the "Scan a barcode" box and scan your dewar barcode. (IceBear works best if your barcode scanner is configured
    to send Enter after a successful scan. See your scanner's user manual for details.) If it doesn't have a barcode, type
    a name (which must be unique within the shipment) and press Enter.</p>
<p>Your dewar will appear as a new tab. Click the tab to view and edit the dewar contents.</p>

<h3>Adding pins and pucks</h3>

<figure>
    <img alt="" src="beforeship_dewar.png" />
    <figcaption>A dewar, containing a single puck and pin.</figcaption>
</figure>

<p>Scan a puck barcode into the <strong>Add a puck</strong> box at the top of the tab to add a puck to this dewar. If IceBear
    knows about the contents of the puck, these will be shown.</p>
<p>Scan a pin barcode into the box at the relevant puck position. The contents of the pin will appear in the table.</p>

<h3>Moving a pin within a puck</h3>
<p>You can move a pin to a different puck position. Simply scan or type its barcode into the new position. The pin will be
    removed from the old position and put into the new position.</p>

<h3>Removing pins, pucks, and dewars</h3>
<p>Click the X beside a pin's barcode to remove it from the shipment. This does not unlink the crystal from the pin, so
    you can put the pin into a storage dewar and scan it into a later shipment.</p>
<p>Click the <strong>Remove puck</strong> button to remove a puck from the dewar and the shipment. IceBear remembers the
    contents of the puck, so you can add the whole puck to a later shipment.</p>
<p>Click the <strong>Remove dewar</strong> button to remove a dewar from the shipment. As with pucks, IceBear remembers
    the contents of the dewar, so you can easily add the dewar to a later shipment.</p>

<h2>Submitting the shipment</h2>

<p>IceBear will attempt to submit the shipment automatically where this is possible, but you must be aware of the synchrotron's
    requirements. For example, in ISPyB systems it's typical that each sample must be identified by a "protein acronym"
    that is already defined in the proposal and approved by the synchrotron. If any samples in the shipment don't have a
    protein acronym, or have one that isn't on the proposal, the shipment will not submit.</p>

<p>When you are happy with the contents of the shipment, click the <strong>Send shipment...</strong> button on the Shipment
    tab to begin.</p>
<p>From here, the process varies slightly depending on where you are sending the shipment.</p>
<p>For synchrotrons where IceBear can't submit the data automatically, the shipment status is simply updated; you will need
    to submit the shipment data to the synchrotron yourself.</p>
<p>Where IceBear can submit the data, there are some variations, but typically the process will look something like this
    (submitting to Diamond Light Source):</p>

<figure>
    <img alt="" src="authenticate.png" />
<figcaption>Authenticating with the synchrotron.</figcaption>
</figure>
<p>Provide your synchrotron username and password. This is needed to authenticate you at the synchrotron. IceBear does not
    store your credentials.</p>

<figure>
    <img alt="" src="proposals.png" />
    <figcaption>Choosing the proposal and session.</figcaption>
</figure>
<p>After authenticating, you will see all the proposals to which you have access. Click to open the right proposal. You
        will see a list of sessions (or visits) on that proposal. Click "Use this visit" to select the session.</p>

<figure>
    <img alt="" src="labcontact.png" />
    <figcaption>Choosing the lab contact.</figcaption>
</figure>
<p>Next choose the lab contact for this shipment. Note that the lab contact must already be defined in the synchrotron's
        ISPyB system.</p>

<figure>
    <img alt="" src="safetylevel.png" />
    <figcaption>Choosing the safety level.</figcaption>
</figure>
<p>Next choose the safety level for this shipment.</p>

<figure>
    <img alt="" src="review.png" />
    <figcaption>Reviewing the shipment before sending.</figcaption>
</figure>
<p>Finally, review the shipment details. When you are happy, click <strong>Send shipment</strong> to submit the details to
    the synchrotron. Click OK to confirm.</p>

<figure>
    <img alt="" src="sending.png" />
    <figcaption>Submitting the shipment.</figcaption>
</figure>
<p>You will see the shipment being submitted to the synchrotron, hopefully without errors. If there are errors, you will
    need to fix these before re-submitting.</p>

<h2>Dewar shipping</h2>
<figure>
    <img alt="" src="sent.png" />
    <figcaption>After submitting the shipment.</figcaption>
</figure>
<p>After submitting the data, you will need to arrange for the dewars to be collected by the courier.</p>
<p>The shipping page now has a link to the shipment record in the synchrotron's systems. Click this link to be taken to
    the synchrotron's shipment record, where you can arrange for dewar collection and print labels, etc.</p>

<h2>Data collection</h2>
<p>Once the shipment has been submitted, there is a new <strong>Data collection</strong> tab on the shipping page:</p>
<figure>
    <img alt="" src="datacollection.png" />
    <figcaption>The Data collection tab.</figcaption>
</figure>
<p>The Data collection tab lets you take notes, and decide whether to wash the pin on return or retain the crystal for a
    later shipment.</p>
<p>There is a large button for each puck. As the puck is loaded onto the sample changer, click its button to open a set of
    tabs, one for each position in the puck.</p>
<p>You can type notes, which will be attached to the crystal. The "Quick notes" buttons let you add commonly-written notes
    with a single click.</p>
<p>Select "Wash the pin" or "Keep the crystal" as appropriate.</p>
<p>Click <strong>Save</strong>. IceBear will automatically advance to the next tab, so you can make notes on the next pin.
    Tabs for pins where you have already made notes will be highlighted with a green checkmark, as will completed pucks.</p>

<p>If you prefer to make hand-written notes and transcribe them later, you might find IceBear's printable shipment manifest
    helpful. It has space to write notes for every sample in the shipment. A link to this can be found on the Shipment tab.
    Note that the Data collection tab will disappear when the shipment is marked Returned, so don't wait too long to transcribe
    your notes. You can always add notes to the individual crystals, but the Data collection tab puts all those notes boxes
    in the same place.</p>

<h2>Container return</h2>
<p>When your dewars come back to the lab, you'll need to unpack them, wash some pins, put others into storage... and tell
    IceBear what you did, so the pins, pucks, and dewars are correct for next time.</p>
<p>On the Shipment tab, click <strong>Return shipment</strong> to begin. The Data collection tab will be replaced with a
    Shipment return tab:</p>
<figure>
    <img alt="" src="return.png" />
    <figcaption>The Shipment return tab.</figcaption>
</figure>
<p>Each dewar in the shipment is shown as a heading bar, along with the number of pucks remaining inside it. Click on the
    dewar to open it and see the pucks inside.</p>
<p>Each dewar in the puck is shown as a heading bar, with a summary of the actions needed on the pins inside it. These are
    "Keep crystal", "Wash pin", or in the case where the pin owner has not specified an action, "Check with owner".</p>

<h3>Removing pins from the puck</h3>
<p>Click the puck header to see a list of all puck positions, along with the pins in them.</p>
<p>For each pin, you will see its barcode, crystal name, protein, and what the pin owner wants to happen to it ("Keep crystal"
    or "Wash pin"). If the pin owner did not make a choice, "Check with owner" is shown.</p>
<p>Clicking <strong>Keep crystal</strong> will remove the pin from the puck, but will keep the association between pin and
    crystal. You can then add the crystal to a future shipment by scanning the pin barcode. "Keep crystal" is not available
    if a non-barcoded pin was used.</p>
<p>Clicking <strong>Wash pin</strong> will remove the pin from the puck, and will break the association between pin and
    crystal. In the case of a barcoded pin, this makes it available for use with another crystal in a future shipment.</p>

<h3>Removing pucks from the dewar</h3>
<p>Click the <strong>Remove puck from dewar</strong> button on the puck header to remove it from the dewar and make it available
    for future shipments.</p>
<p>Note that removing the puck <strong>does not</strong> empty the pins from inside it! IceBear will assume that you are
    putting the whole puck back into a storage dewar with all its pins and crystals still inside. If this isn't what you're
    doing, remove the pins from the puck first.</p>

<?php
include_once($_SERVER['DOCUMENT_ROOT'].'/client/help/_common/helpfoot.php');
?>