<?php include_once($_SERVER['DOCUMENT_ROOT'].'/client/help/_common/helphead.php'); ?>

<h1>Crystals</h1>

<h2>Creating a crystal in IceBear</h2>

<p>You can create a crystal in the Drop Viewer, by switching to the Crystal Selection mode and clicking the drop image.</p>
<p>During crystal fishing, you can also mark the image, or simply drag from the well to the pin or puck. Either of these
    actions will create a crystal.</p>

<h2>Crystal view</h2>

<p>This page shows you all the information about your crystal, pulled in from all over IceBear. You can see the details
    of the plate, the screen, the protein, and any attached PDB codes or datasets, as well as links to any shipments
    containing the crystal.</p>

<figure>
    <img alt="" src="view_proteins.png"/>
    <figcaption>The crystal view, showing the basic details and the Protein tab.</figcaption>
</figure>

<h3>Basic details</h3>

<p>On the left of the screen, you will see the drop image with the position of the crystal marked. There is a link to the
    drop viewer, where the imaging history and the surrounding plate can be viewed. The plate, well and drop are shown,
    along with the screen and crystallization conditions.</p>

<h3>The Protein tab</h3>

<p>This tab shows you the project, protein, and construct, and allows you to manage PDB depositions associated with the
    crystal.</p>

<h4>Linking a PDB code to your crystal</h4>
<p>Type the PDB code into the box, and click Link. Your PDB code will appear in the "Deposited structures" list.</p>
<p>Linking a PDB to a crystal automatically creates a PDB deposition page in IceBear, from which you can jump straight
    to the PDB record in the various data banks.</p>
<p>Clicking the PDB code in this list will take you to the PDB deposition page. You can also find this page by searching
    for the PDB code in the "Find by name..." box in the page header.</p>
<h4>Unlinking a PDB code from your crystal</h4>
<p>Click the red and white X button beside the PDB code that you want to unlink. It will be removed from the "Deposited
    Structures" list.</p>
<p>Unlinking a PDB code from the crystal does not remove its PDB deposition page.</p>

<h3>The Datasets tab</h3>

<figure>
    <img alt="" src="view_datasets.png"/>
    <figcaption>The crystal view, showing the Datasets tab.</figcaption>
</figure>

<p>The Datasets tab shows all datasets for this crystal, grouped under the shipments where they were generated. You can
    also attach datasets to the crystal without having a record of the shipment in IceBear.</p>

<h4>Adding a dataset</h4>
<p>Click the <strong>Add dataset...</strong> button under the relevant shipment, or in the "no associated shipment"
    box. A new form will appear.</p>
<figure>
    <img alt="" src="..dataset/create.png"/>
    <figcaption>Creating a dataset.</figcaption>
</figure>
<p>In the <strong>Dataset location</strong> field, enter a URL, DOI, or other location where the raw data is stored.</p>
<p>In the <strong>Description</strong> field, enter a short description of why the dataset is important.</p>
<p>The <strong>Associated PDB code</strong> field lets you link this dataset to a PDB deposition. You must first have
    linked the PDB code to the crystal.</p>
<p>In the <strong>Beamline</strong> field, choose the synchrotron and beamline. The detector details will be filled in
    automatically, but you can edit or delete these if you wish.</p>
<p>Lastly, click the <strong>Create dataset</strong> button.</p>

<h4>Viewing a dataset</h4>
<p>In the <strong>Click the View...</strong> button beside your dataset. The dataset will appear - see above for details
    of what the fields mean.</p>
<p>You can also add notes to the dataset.</p>

<h4>Deleting a dataset</h4>
<p>Click the <strong>Delete</strong> button next to the dataset. This deletes IceBear's record of the dataset, and
    any files or notes attached to that record. IceBear will not attempt to delete the raw data itself.</p>

<?php include '../_common/filesnotestabs.php';?>

<?php include_once($_SERVER['DOCUMENT_ROOT'].'/client/help/_common/helpfoot.php');
