<?php
include_once($_SERVER['DOCUMENT_ROOT'].'/client/help/_common/helphead.php');
?>

<h1>Crystal fishing</h1>

<p>The crystal fishing page allows you to record the selection of crystals, 
mounting onto pins, and packing into pucks and dewars.</p>
<p>This page works best if you use barcoded pins, but will also work if you use
 non-barcoded pins.</p>
<p>To begin crystal fishing, choose "Crystal fishing" from the Fishing &amp; 
Shipping section of the main menu.</p>
<figure>
	<img alt="The crystal fishing page" src="blankui.png"/>
	<figcaption>The crystal fishing page.</figcaption>
</figure>

<h2 id="configuring">Configuring IceBear to your liking</h2>
<p>There are a number of configuration options that you can set, to make the fishing page suit the way you work.</p>
<p>Click the gear wheel icon at the top right to open the fishing configuration box.</p>
<figure>
	<img alt="Fishing config" src="fishingconfig.png"/>
	<figcaption>The fishing configuration box.</figcaption>
</figure>
<p>From here, you can choose whether to:</p><ul>
<!-- Commented out because of notes box error. Uncomment, delete below, and uncomment notes help near bottom of page.
<li>move a pin automatically into the first empty slot of the first puck, after you fish a crystal onto the pin;</li>
<li>move a puck automatically to the first dewar, as soon as it becomes full; and</li>
<li>show a details box after fishing a crystal, where you can record cryo/treatment and other information.</li>
 -->
<li>move a pin automatically into the first empty slot of the first puck, after you fish a crystal onto the pin; and</li>
<li>move a puck automatically to the first dewar, as soon as it becomes full.</li>
</ul>
<p>When you are happy with your choices, click the close icon at the top right. IceBear will remember your choices
for next time.</p>

<h2>Setting up your workspace</h2>

<p>Ensure that the cursor is in the "Barcode entry" text box; it should go there 
when the page is first loaded. Scan all the pins, pucks and dewars you plan to 
use during this session. Having a few extra pins is probably a good idea. It 
helps to lay out the pins as they appear on screen, in a line, with the 
first-scanned toward the back of the bench and the last-scanned toward the front. 
If you are not using barcoded pins, don't worry; IceBear can handle this.</p>
<p>You can add full, or part-full, containers - for example, if you want to fish 
crystals and store them in a puck that already has some pins in it, or if you have 
already-frozen crystals on pins that you would like to add to a shipment. If any 
containers are not empty, IceBear will show you this. Pucks and dewars show the
number of containers inside them, while pins will show a crystal icon if they 
are not empty.</p>
<figure>
	<img alt="After scanning containers" src="containersscanned.png"/>
	<figcaption>After scanning containers. Note that the second pin already contains a crystal.</figcaption>
</figure>

<h2>Scanning your plate</h2>

<p>Once you have all the containers you need, scan the first crystallization plate 
that you want to fish from. It will appear in the plate area, below the barcode 
scanning field:</p>
<figure>
	<img alt="Plate in fishing view" src="plateinfishing.png"/>
	<figcaption>A 3-drop crystallization plate shown on the fishing page. In well A1, 
	drop 3 contains two previously-marked crystals; in well A8, it has three.</figcaption>
</figure>
<p>For plates with more than one drop position per well, <strong>remember to choose the correct drop
position</strong> using the selector to the left.</p>

<h2>Fishing crystals</h2>

<p>Now that you have containers and plate on the page, you can start fishing crystals.</p>
<p>This is a simple drag-and-drop operation. However, you can do it in several ways, depending on how you work.</p>

<h3>Fish to the pin, or to the puck?</h3>
<p>If you use barcoded pins, we recommend that you scan them and drag your crystals to the pin. If you have the option
set, the pin will automatically be moved to the first empty position of the first puck.</p>
<p>If your pins are not barcoded, you will need to drag your crystals directly to the puck. IceBear will create a
dummy pin, mount your crystal onto it, and put it into the first empty position in the puck.</p>
<p>We recommend the use of barcoded pins. This greatly reduces the impact of any mishandling that causes the pins to
fall out of the pucks, or of the wrong puck being loaded at the synchrotron beamline.</p>


<h3>Directly from the well</h3>

<p>If you have not already identified which crystal you want to fish from a given well, and you don't care, you can fish directly from the plate well.</p>
<p><strong>Remember to choose the correct drop position</strong> if the plate has more than one drop per well.
<p>Position your mouse cursor over the well, and press and hold the left mouse button. You will see a crystal icon appear. At the
same time, any pins or pucks that are not full will be highlighted in green.</p>
<p>Move the mouse until the crystal is over the pin or puck you want to put it into. The pin or puck will turn yellow. 
Release the mouse button.</p>
<figure>
	<img alt="Fish from well" src="fishfromwell.png"/>
	<figcaption>Fishing directly from a well.</figcaption>
</figure>

<h3>From the drop image</h3>

<p>If you want to record fishing a specific crystal, you can open the last image of that drop.</p>
<p>Click the drop you want, <strong>remembering to choose the correct drop
position</strong> if the plate has more than one drop per well. The drop image will appear, with any previously-marked crystals shown
as crosshairs.</p>
<p>If the crystal you want to fish is not marked already, click on it to mark it with a new crosshair.</p>
<p>Position your mouse cursor over the image, and press and hold the left mouse button. You will see a crystal icon appear. At the
same time, any pins or pucks that are not full will be highlighted in green.</p>
<p>Move the mouse until the crystal is over the pin or puck you want to put it into. The pin or puck will turn yellow. 
Release the mouse button.</p>
<figure>
	<img alt="Fish from image" src="fishfromimage.png"/>
	<figcaption>Fishing from the drop image.</figcaption>
</figure>
<p>After you have finished with this drop, click the close icon at the top right of the image.</p>

<!-- Commented out due notes box errors. If uncommenting, don't forget to check the config section above. 
<h2>Adding notes</h2>
<p>If you enabled it in your <a href="#configuring">configuration</a>, IceBear will give you a box to record details of each crystal fished.</p>
<p>A default note is added. You might want to edit the note to record cryo or treatment information.</p>
<p>In addition, you can provide space group and unit cell information about the crystal, if known, and a brief comment that will be sent to
the synchrotron along with the crystal.</p>
<p>If you don't edit anything in the box, it will close automatically after some time.</p>
 -->

<h2>Fishing from several plates</h2>

<p>If you need to fish crystals from another plate, just scan its barcode into the barcode box. It will replace your current plate.</p>

<h2>Assembling containers</h2>

<p>To move a pin to a puck, or a puck to a dewar, simply drag it to its destination and release the mouse button.</p>
<p>The page won't let you do things that don't make sense, like putting a dewar into a pin.</p> 
<p>IceBear does have configuration options to do some of this automatically. See <a href="#configuring">Configuring IceBear to your liking</a> for more details.</p>

<h2>Shipping your dewars</h2>

<p>After fishing your crystals and placing the pins and pucks into shipping dewars, you can create a shipment containing these dewars.</p>
<p>Click the "Ship these dewars..." link underneath the dewars to go to the shipping page.</p>

<?php
include_once($_SERVER['DOCUMENT_ROOT'].'/client/help/_common/helpfoot.php');
?>