<?php class welldrop extends baseobject { 
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'platewellid'=>array(validator::REQUIRED, validator::INTEGER),
			'constructid'=>validator::INTEGER,
			'dropnumber'=>array(validator::REQUIRED, validator::INTEGER),
			'proteinconcentrationamount'=>validator::FLOAT,
			'proteinconcentrationunit'=>validator::ANY,
			'proteinbuffer'=>validator::ANY,
			'proteinsolutionamount'=>validator::FLOAT,
			'proteinsolutionunit'=>validator::ANY,
			'wellsolutionamount'=>validator::FLOAT,
			'wellsolutionunit'=>validator::ANY,
	);
	
	protected static $helpTexts=array(
			'name'=>'A unique name for this drop',
			'platewellid'=>'The parent well',
			'constructid'=>'The protein construct in this drop',
			'dropnumber'=>'Number of the drop within the well'
	);
		
	protected static $adminSelect='SELECT SQL_CALC_FOUND_ROWS welldrop.*, construct.name AS constructname, protein.id AS proteinid, protein.name AS proteinname
			FROM welldrop  LEFT JOIN construct ON construct.id=welldrop.constructid LEFT JOIN protein ON protein.id=construct.proteinid
			WHERE 1=1';
	protected static $normalSelect='SELECT SQL_CALC_FOUND_ROWS welldrop.*, construct.name AS constructname, protein.id AS proteinid, protein.name AS proteinname
			FROM welldrop LEFT JOIN construct ON construct.id=welldrop.constructid LEFT JOIN protein ON protein.id=construct.proteinid 
			LEFT JOIN project ON project.id=welldrop.projectid
			WHERE 1=1';

    /**
     * @param int $id The ID of the well drop.
     * @param array $request The request parameters, e.g., pagination.
     * @return array
     * @noinspection PhpUnusedParameterInspection
     */
	public static function gettimecourseimages($id,$request=array()){
        return database::queryGetAll(dropimage::getSelectClause().' AND welldropid=:wd
                ORDER BY imagingsession.imageddatetime ASC',
                array(':wd'=>$id));
	}

    /**
     * @param int $id The ID of the well drop.
     * @param array $request The request parameters, e.g., pagination.
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function getcrystals($id, $request=array()){
		return crystal::getByProperty('welldropid', $id, $request);
	}
}