<?php /** @noinspection PhpUnused */

class task implements crudable {
	
	public static function getAll($request=array()){
		$parts=array();
		$params=array();
		if(session::isAdmin()){
			//plate types with default drop mapping
			//users with name starting AUTO
			$parts[]="SELECT 'user' AS type, 1 AS priority, id, name, 'Set username and activate' AS description FROM user WHERE name LIKE 'AUTO%'";
			//plates with owner unknownuser
			$defaultOwner=user::getByName(user::UNKNOWNUSER_USERNAME);
			$parts[]="SELECT 'plate' AS type, 2 AS priority, id, name, 'Set the plate owner' AS description FROM plate WHERE ownerid=:ownerid";
			$params[':ownerid']=$defaultOwner['id'];
		}

		//Expired plates - zero (but not null) inspections remaining
		$expiredSql="SELECT 'plate' as type, 3 AS priority, plate.id AS id, plate.name AS name, CONCAT('Remove expired plate from ', imager.friendlyname) AS description
					FROM plate, imager where imager.id=plate.locationid AND plate.inspectionsremaining=0 ";
		if(!session::isAdmin()){
			$expiredSql.=" AND plate.ownerid=:ownerid2";
			$params[':ownerid2']=session::getUserId();
		}
		$parts[]=$expiredSql;
		
		//Zombie plates - have at least one inspection remaining, but final one scheduled for over a week ago
		$zombieSql="SELECT 'plate' as type, 3 AS priority, plate.id AS id, plate.name AS name, CONCAT('Remove zombie plate from ', imager.friendlyname) AS description
					FROM plate, imager 
					WHERE imager.id=plate.locationid AND plate.finalinspectiontime<NOW() - INTERVAL 1 WEEK AND plate.inspectionsremaining>0";
		if(!session::isAdmin()){
			$zombieSql.=" AND plate.ownerid=:ownerid3";
			$params[':ownerid3']=session::getUserId();
		}
		$parts[]=$zombieSql;
		
		//plates owned by userid with screenid=null and/or hasconstructs=false
		$parts[]="SELECT 'plate' AS type, 5 AS priority, id, name,
				CASE 
					WHEN screenid IS NULL AND plate.hasconstructs=FALSE THEN 'Set the protein and screen' 
					WHEN screenid IS NULL THEN 'Set the screen' 
					ELSE 'Set the protein'
				END AS description 
				FROM plate WHERE (screenid IS NULL OR plate.hasconstructs=FALSE) AND ownerid=:ownerid4";
		$params[':ownerid4']=session::getUserId();

		
		$query="(" .implode(") UNION (", $parts) .") ORDER BY priority, id";
		//$query.=database::getProjectClause("read");
		$query.=database::getLimitClause($request);
		return database::queryGetAll($query, $params);
	}
	
	/* "Implement" remaining methods in crudable to ensure clean failure */

    /**
     * @throws BadRequestException
     */
	public static function getFieldValidations(){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @throws BadRequestException
     */
	public static function getFieldHelpTexts(){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param $id
     * @throws BadRequestException
     */
	public static function getById($id){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param $name
     * @throws BadRequestException
     */
	public static function getByName($name){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param $name
     * @param $value
     * @param array $request
     * @throws BadRequestException
     */
	public static function getByProperty($name, $value, $request=array()){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @throws BadRequestException
     */
	public static function canCreate(){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param $id
     * @throws BadRequestException
     */
	public static function canUpdate($id){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param array $request
     * @throws BadRequestException
     */
	public static function create($request=array()){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param $id
     * @param array $request
     * @throws BadRequestException
     */
	public static function update($id,$request=array()){
		throw new BadRequestException('Not implemented');
	}

    /**
     * @param $id
     * @throws BadRequestException
     */
	public static function delete($id){
		throw new BadRequestException('Not implemented');
	}
	
}