<?php class shipmentdestination extends baseobject { 
	
	protected static $fields=array(
		'name'=>validator::REQUIRED,
	    'shipmenthandler'=>validator::ANY,
	    'baseuri'=>validator::ANY
	);
	
	protected static $helpTexts=array(
		'name'=>'The name of the shipment destination',
	    'shipmenthandler'=>'Name of the Javascript shipment handler object',
	    'baseuri'=>'Base URI of synchrotron API'
	);

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create($request=array()){
	    if(!static::canCreate()){ throw new ForbiddenException('You cannot create shipment destinations'); }
	    $request['projectid']=project::getSharedProjectId();
	    return parent::createByClassName($request, 'shipmentdestination');
	}

    /**
     * @return bool
     * @throws BadRequestException
     * @throws NotFoundException
     */
	public static function canCreate(){
		if(session::isAdmin()){ return true; }
		$grp=usergroup::getByName(usergroup::SHIPPERS);
		if(usergroup::userisingroup($grp['id'])){ return true; }
		$grp=usergroup::getByName(usergroup::TECHNICIANS);
		return usergroup::userisingroup($grp['id']);
	}

    /**
     * Gets shipments for this shipment destination.
     * @param int $id The shipment ID.
     * @param array $request The request parameters, e.g., pagination.
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     * @noinspection PhpUnused
     */
	public static function getshipments($id, $request=array()){
	    return shipment::getByProperty('shipmentdestinationid', $id, $request);
	}

    /**
     * Gets beamlines for this shipment destination.
     * @param int $id The shipment ID.
     * @param array $request The request parameters, e.g., pagination.
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function getbeamlines($id, $request=array()){
        return beamline::getByProperty('shipmentdestinationid', $id, $request);
    }

    /**
     * Returns the names of all the shipment handler Javascript files.
     * @return array
     */
	public static function getHandlerScriptNames(){
	    $files=dir(rtrim($_SERVER['DOCUMENT_ROOT'],'/').'/client/js/model/shipping/handlers/');
	    $handlers=array();
	    while (false!==($name=$files->read())) {
	        if('.'==$name || '..'==$name){ continue; }
	        if(substr($name,-18)=='ShippingHandler.js'){
	            $handlers[]=substr($name, 0, -3);
	        }
	    }
	    $files->close();
	    return $handlers;
	}
	
}