<?php class session extends basesession {

    /**
     * Whether the current user is a technician.
     * @return bool true if the user is a technician, otherwise false.
     * @throws NotFoundException if the usergroup does not exist.
     */
	public static function isTechnician(){
		return session::isA(usergroup::TECHNICIANS);
	}

    /**
     * Whether the current user is a shipper.
     * @return bool true if the user is a shipper, otherwise false.
     * @throws NotFoundException if the usergroup does not exist.
     */
	public static function isShipper(){
		return session::isA(usergroup::SHIPPERS);
	}

    /**
     * Whether the current user is in the Plate Destroyers usergroup.
     * @return bool true if the user is in the Plate Destroyers usergroup, otherwise false.
     * @throws NotFoundException if the usergroup does not exist.
     */
	public static function isPlateDestroyer(){
	    return session::isA(usergroup::PLATEDESTROYERS);
	}

    /**
     * Determines whether the current user is in the named usergroup.
     * @param string $groupName The group name.
     * @return bool true if the user is in the named group, otherwise false.
     * @throws BadRequestException
     * @throws NotFoundException if the usergroup does not exist.
     */
	private static function isA($groupName){
		$group=usergroup::getByName($groupName);
		if(!$group){ return false; }
		return usergroup::userisingroup($group['id']);
	}
	
}