<?php class screencondition extends baseobject {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'wellnumber'=>array(validator::REQUIRED,validator::INTEGER),
			'row'=>array(validator::REQUIRED,validator::INTEGER),
			'col'=>array(validator::REQUIRED,validator::INTEGER),
			'screenid'=>array(validator::REQUIRED,validator::INTEGER),
			'description'=>validator::REQUIRED,
	);
	
	protected static $helpTexts=array(
			'name'=>'A unique name for this screen condition',
			'wellnumber'=>'The well number (typically 1-96)',
			'row'=>'The plate row',
			'col'=>'The plate column',
			'screenid'=>'The parent screen',
			'description'=>'A human-readable description of the condition',
	);
	
	public static $defaultSortOrder='wellnumber ASC, `row` ASC, `col` ASC';

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create($request=array()){
		$screen=screen::getById($request['screenid']);
		$projectId=$screen['projectid'];
		$request['projectid']=$projectId;
		return parent::create($request);
	}

    /**
     * @param $id
     * @return bool
     * @throws NotFoundException
     * @throws ServerException
     * @throws BadRequestException
     */
	public static function canUpdate($id){
		return screen::canUpdate($id);
	}
	
}