<?php 
/**
 * All application-specific project methods should go in this class. Do not modify classes/core/baseproject.php.
 * 
 * A project is essentially a container for application-specific records, serving as a way to apply common access rights to them all.
 * One user is designated the "project owner". The project owner can perform certain actions such as archiving the project or updating its details. They may also have some application-specific privileges.
 * Users are members of usergroups. The project owner can grant those groups read, update, create and delete permissions "on the project" - actually on the records within the project.
 */
class project extends baseproject {

    /**
     * Gets the proteins for this project.
     * @param int $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     * @noinspection PhpUnused
     */
	public static function getproteins($id,$request=array()){
		return protein::getByProperty('projectid',$id,$request);
	}

    /**
     * Gets the plates for this project.
     * @param int $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     * @noinspection PhpUnused
     */
	public static function getplates($id,$request=array()){
		return plate::getByProperty('projectid',$id,$request);
	}
	
	
}