<?php class platetype extends baseobject {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'rows'=>array(validator::REQUIRED, validator::INTEGER),
			'cols'=>array(validator::REQUIRED, validator::INTEGER),
			'subs'=>array(validator::REQUIRED, validator::INTEGER),
			'dropmapping'=>array(validator::REQUIRED, validator::DROPMAPPING),
			'defaultdropsize'=>array(validator::ANY),
	);
	
	protected static $helpTexts=array(
			'name'=>'A unique name for this plate type',
			'rows'=>'How many rows of wells these plates have',
			'cols'=>'How many columns of wells these plates have',
			'subs'=>'Number of drop positions per well',
			'dropmapping'=>'How the drop positions are numbered locally',
			'defaultdropsize'=>'The default size of the drop, e.g., 0.2nL',
	);
	
	public static $rowLabels=array('-','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

    /**
     * @return bool
     * @throws BadRequestException
     * @throws NotFoundException
     */
	public static function canCreate(){
		if(session::isAdmin()){ return true; }
		$grp=usergroup::getByName(usergroup::TECHNICIANS);
		return usergroup::userisingroup($grp['id']);
	}
	
}