<?php class platereimportqueue {

    /**
     * @param $id
     * @throws ServerException
     * @noinspection PhpUnusedParameterInspection
     */
    public static function getById($id){
        throw new ServerException('getById not implemented on platereimportqueue');
    }

    /**
     * @param $name
     * @throws ServerException
     * @noinspection PhpUnusedParameterInspection
     */
    public static function getByName($name){
        throw new ServerException('getByName not implemented on platereimportqueue');
    }

    /**
     * @param $request
     * @throws ServerException
     * @noinspection PhpUnusedParameterInspection
     */
    public static function getAll($request){
        throw new ServerException('getAll not implemented on platereimportqueue');
    }

    /**
     * @param $plateId
     * @return array|bool
     */
    public static function getByPlateId($plateId){
        $item=database::queryGetOne('SELECT p.ownerid AS ownerid,q.* from plate as p, platereimportqueue AS q 
            WHERE p.id=q.plateid AND q.plateid=:plateid', array(':plateid'=>$plateId));
        if(!$item){ return false; }
        if(session::isAdmin() || $item['ownerid']==session::getUserId()){ return $item; }
        return false;
    }

    /**
     * @param $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws ServerException
     */
    public static function create($request){
        if(false==(int)(config::get('reimport_enabled'))){
            throw new ForbiddenException('Plate re-import is not enabled');
        } else if(!isset($request['plateid'])){
            throw new BadRequestException('No plate ID specified');
        }
        $plate=plate::getById($request['plateid']);
        if(!$plate || !(session::isAdmin() || $plate['ownerid']==session::getUserId())){
            throw new ForbiddenException('Either the plate does not exist, or you cannot queue it for re-import');
        }
        $item=database::queryGetOne('SELECT * from platereimportqueue WHERE plateid=:plateid', array(':plateid'=>$plate['id']));
        if($item){
            throw new BadRequestException('Plate is already queued for re-import');
        }
        database::query(
            'INSERT INTO platereimportqueue(plateid,queuedby,queuedtime) VALUES(:pid,:uid,:now)',
            array(
                ':pid'=>$plate['id'],
                ':uid'=>session::getUserId(),
                ':now'=>date('Y-m-d H:i:s')
            )
        );
        $newId=database::getLastInsertId();
        $newItem=database::queryGetOne('SELECT * from platereimportqueue WHERE id=:id', array(':id'=>$newId));
        return array('created'=>$newItem);
    }

    /**
     * @param $id
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws ServerException
     */
    public static function delete($id){
        $item=database::queryGetOne('SELECT * from platereimportqueue WHERE id=:id', array(':id'=>$id));
        if(!$item){
            throw new BadRequestException('No queue item with ID '.$id);
        }
        $plate=plate::getById($item['plateid']);
        if(!$plate || !(session::isAdmin() || $plate['ownerid']==session::getUserId())){
            throw new ForbiddenException('Either the plate does not exist, or you cannot remove it from the queue');
        }
        database::query('DELETE from platereimportqueue WHERE id=:id', array(':id'=>$id));
        return array('deleted'=>$id);
    }
    
}