<?php class pdbdepositioncrystal extends baseobject {

    protected static $fields=array(
        'name'=>validator::ANY, //required but autogenerated
        'pdbdepositionid'=>array(validator::REQUIRED, validator::INTEGER),
        'crystalid'=>array(validator::REQUIRED, validator::INTEGER)
    );

    protected static $helpTexts=array(
        'name'=>'Auto-generated',
        'pdbdepositionid'=>'The ID of the PDB deposition record',
        'crystalid'=>'The ID of the crystal record',
    );

    public static function create($request = array()){
        //TODO This should be a baseobject::validate function!
        foreach(static::$fields as $fname=>$validations){
            if(isset($request[$fname])){
                validator::validate($fname, $request[$fname], $validations);
                $fields[]=$fname;
            } else {
                validator::validate($fname, null, $validations);
            }
        }
        $crystal=crystal::getById($request['crystalid']);
        $pdb=pdbdeposition::getById($request['pdbdepositionid']);
        if(!$crystal){
            throw new BadRequestException('That crystal does not exist, or you do not have permission to see it.');
        } else if(1*$crystal['projectownerid']!==1*session::getUserId() && !session::isAdmin()){
            throw new ForbiddenException('Only the owner of the crystal\'s project can manage its PDB depositions');
        }
        if(!$pdb){
            throw new BadRequestException('No PDB deposition record with that ID');
        }
        $request['name']='pdbdeposition'.$pdb['id'].'_crystal'.$crystal['id'];
        $request['projectid']=$crystal['projectid'];
        return parent::create($request);
    }

}