<?php class pdbdeposition extends baseobject {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
	);

	protected static $helpTexts=array(
			'name'=>'The PDB code',
	);

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function getcrystals($id, $request=array()){
	    if(!static::getById($id)){
	        throw new NotFoundException('That PDB does not exist, or you do not have permission to see it');
	    }
	    return database::queryGetAll(
	        'SELECT j.id AS pdbdepositiontocrystalid, c.*, di.imagingsessionid AS imagingsessionid, 
                    w.row, w.col, d.dropnumber, p.name AS platename, p.id AS plateid
                FROM project, crystal AS c, welldrop AS d, platewell AS w, plate AS p,
                     pdbdepositioncrystal AS j, dropimage AS di
                WHERE j.pdbdepositionid=:id AND j.crystalid=c.id AND d.id=c.welldropid 
                    AND w.id=d.platewellid AND p.id=w.plateid AND project.id=c.projectid AND di.id=c.dropimageid '
                .database::getFilterClause($request)
                .database::getProjectClause('read')
                .database::getOrderClause($request,'crystal')
                .database::getLimitClause($request),
            array(':id'=>$id)
        );
    }

    /*
     * Returns the PDB entry. Lower-case PDB codes are preferred, so we enforce that here.
     */
    public static function getByName($name){
        return parent::getByName(strtolower($name));
    }

    public static function getByProperty($key, $value, $request = array()){
        if('name'==$key){ $value=strtolower($value); }
        return parent::getByProperty($key, $value, $request);
    }

    public static function getByProperties($keyValuePairs, $request = array()){
        if(isset($keyValuePairs['name'])){
            $keyValuePairs['name']=strtolower($keyValuePairs['name']);
        }
        return parent::getByProperties($keyValuePairs, $request);
    }

    /*
     * Creates the PDB entry. Lower-case PDB codes are preferred, so we enforce that here.
     */
    public static function create($request = array()){
	    $request['name']=strtolower($request['name']);
        return parent::create($request);
    }

    public static function canCreate(){
        return true;
    }

}