<?php class note extends basenote {

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
    public static function create($request=array()){
        if(session::isShipper() && !session::isAdmin()){
            session::becomeAdmin();
        }
        try {
            $ret=parent::create($request);
            session::revertAdmin();
            return $ret;
        } catch (NotFoundException | BadRequestException | ServerException | ForbiddenException $e){
            session::revertAdmin();
            throw $e;
        }
    }

}