<?php class imager extends baseobject { 
	
	protected static $fields=array(
		'name'=>validator::REQUIRED,
		'friendlyname'=>validator::REQUIRED,
		'manufacturer'=>validator::REQUIRED,
		'temperature'=>array(validator::REQUIRED, validator::INTEGER),
		'platecapacity'=>array(validator::REQUIRED, validator::INTEGER),
		'platesactive'=>array(validator::INTEGER),
		'platesexpired'=>array(validator::INTEGER),
		'alertlevel'=>array(validator::REQUIRED, validator::INTEGER),
		'warninglevel'=>array(validator::REQUIRED, validator::INTEGER),
		'manualimaging'=>validator::BOOLEAN
	);
	
	protected static $helpTexts=array(
		'name'=>'A unique identifier for the imager',
		'friendlyname'=>'A human-friendly mame like "20-degree imager"',
		'manufacturer'=>'The manufacturer name',
		'temperature'=>'The normal temperature in the imager',
		'platecapacity'=>'How many plates the imager can hold',
		'platesactive'=>'How many plates in the imager have inspections scheduled',
		'platesexpired'=>'How many plates in the imager have no inspections scheduled',
		'alertlevel'=>'Plate count when imager is "filling up"',
		'warninglevel'=>'Plate count when imager is "almost full"',
		'manualimaging'=>'Imager is for manually-added plate inspections, e.g., microscope'
	);
	
	public static function create($request=array()){
		$project=project::getByName(project::SHARED);
		$request['projectid']=$project['id'];
        return parent::createByClassName($request,'imager');
	}

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     * @noinspection PhpUnused
     */
	public static function getimagingsessions($id, $request=array()){
		return imagingsession::getByProperty('imagerid', $id, $request);
	}

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     * @noinspection PhpUnused
     */
	public static function getplates($id, $request=array()){
		return plate::getByProperty('locationid', $id, $request);
	}

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     * @noinspection PhpUnused
     */
	public static function getimagerloadlogs($id, $request=array()){
		return imagerloadlog::getByProperty('imagerid', $id, $request);
	}
	
	
}