<?php class dataset extends baseobject {

    protected static $fields=array(
        'name'=>validator::REQUIRED,
        'crystalid'=>array(validator::REQUIRED, validator::INTEGER),
        'diffractionrequestid'=>validator::INTEGER,
        'pdbdepositionid'=>validator::INTEGER,
        'remotedatasetid'=>validator::INTEGER,
        'datalocation'=>validator::REQUIRED,
        'description'=>validator::ANY,
        'beamlineid'=>validator::INTEGER,
        'detectormanufacturer'=>validator::ANY,
        'detectormodel'=>validator::ANY,
        'detectortype'=>validator::ANY,
    );

    protected static $helpTexts=array(
        'crystalid'=>'The crystal from which this dataset came',
        'diffractionrequestid'=>'The diffraction request from which this dataset came',
        'remotedatasetid'=>'The ID of this dataset in the synchrotron database',
        'datalocation'=>'The path, URL, or DOI where the raw data can be found'
    );

    protected static $normalSelect='SELECT dataset.*, crystal.name AS crystalname, crystal.dropimageid, pdbdeposition.name AS pdbcode, project.owner AS projectownerid
        FROM dataset JOIN crystal ON dataset.crystalid=crystal.id
            JOIN project on crystal.projectid=project.id 
            LEFT JOIN pdbdeposition ON dataset.pdbdepositionid=pdbdeposition.id 
        WHERE 1=1
    ';

    protected static $adminSelect='SELECT dataset.*, crystal.name AS crystalname, crystal.dropimageid, pdbdeposition.name AS pdbcode
        FROM dataset JOIN crystal ON dataset.crystalid=crystal.id
            LEFT JOIN pdbdeposition ON dataset.pdbdepositionid=pdbdeposition.id 
        WHERE 1=1
    ';

    public static function create($request = array()){
        $crystalId=$request['crystalid'];
        if(!$crystalId){ throw new BadRequestException("Crystal ID not specified"); }
        $crystal=crystal::getById($crystalId);
        if(!$crystal){ throw new NotFoundException("Crystal not found"); }
        if(1*session::getUserId()!==1*$crystal['projectownerid'] && session::isShipper() && !session::isAdmin()){
            throw new ForbiddenException('Only the project owner can manage datasets');
        }
        $request['projectid']=$crystal['projectid'];
        $request['name']='dataset'.microtime(true);
        session::becomeAdmin();
        $ret=parent::create($request);
        session::revertAdmin();
        return $ret;
    }

    public static function update($id, $request=array()){
        $dataset=static::getById($id);
        if(!$dataset){ throw new NotFoundException('Dataset does not exist or you do not have permission to see it'); }
        if(!session::isShipper() && !session::isAdmin() && (int)($dataset['projectownerid'])!==(int)session::getUserId()){
            throw new ForbiddenException('Only the project owner can modify datasets');
        }
        session::becomeAdmin();
        $ret=parent::update($id, $request);
        session::revertAdmin();
        return $ret;
    }

    public static function delete($id){
        $deposition=static::getById($id);
        if(!$deposition || session::isAdmin()){
            return parent::delete($id);
        }
        $crystal=crystal::getById($deposition['crystalid']);
        if(!$crystal || (1*session::getUserId()!==1*$crystal['projectownerid'] && !session::isAdmin())){
            throw new ForbiddenException('Only the project owner can manage datasets');
        }
        return parent::delete($id);
    }

    /**
     * @return bool
     * @throws NotFoundException
     */
    public static function canCreate(){
        return true; //but checked in create()
    }

    /**
     * @param $id
     * @return bool
     * @throws NotFoundException
     */
    public static function canUpdate($id){
        return true; //but checked in create()
    }

}

