<?php class crystalscoringsystem extends baseobject {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'iscurrent'=>validator::BOOLEAN,
	);
	
	protected static $helpTexts=array(
			'name'=>'A unique name for this scoring system',
			'iscurrent'=>'Whether this system should be used for new plates',
	);

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException if the Shared project is not fount
     * @throws ForbiddenException
     * @throws ServerException
     */
	public static function create($request=array()){
		$project=project::getByName(project::SHARED);
		$request['projectid']=$project['id'];
//		$systemId=$ret['created']['id'];
// 		crystalscore::create(array(
// 				'crystalscoringsystemid'=>$systemId,
// 				'name'=>$systemId.'_Clear',
// 				'label'=>'Clear',
// 				'scoreindex'=>0,
// 				'color'=>'666666'
// 		));
		return parent::createByClassName($request,'crystalscoringsystem');
	}

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function getscores($id, $request=array()){
		return crystalscore::getbyproperty('crystalscoringsystemid',$id, $request);
	}
	
}
