<?php class containercategory extends baseobject { 
	
	protected static $fields=array(
		'name'=>validator::REQUIRED,
		'userscancreate'=>validator::BOOLEAN
	);
	
	protected static $helpTexts=array(
		'name'=>'A unique identifier for the container category',
		'userscancreate'=>'If false, only admins and technicians can create containers in this category',
	);

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create($request=array()){
			if(!static::canCreate()){
			throw new ForbiddenException('Only administrators and technicians can create containers');
		}
		$project=project::getByName(project::SHARED);
		$request['projectid']=$project['id'];
        return parent::createByClassName($request,'containercategory');
	}

    /**
     * @return bool
     * @throws BadRequestException
     * @throws NotFoundException
     */
	public static function canCreate(){
		if(session::isAdmin()){ return true; }
		$grp=usergroup::getByName(usergroup::TECHNICIANS);
		return usergroup::userisingroup($grp['id']);
	}
	
	
}