<?php class beamline extends baseobject {

    protected static $fields=array(
        'name'=>validator::REQUIRED,
        'shipmentdestinationid'=>array(validator::REQUIRED, validator::INTEGER),
        'detectormanufacturer'=>validator::ANY,
        'detectormodel'=>validator::ANY,
        'detectortype'=>validator::ANY,
    );

    protected static $helpTexts=array(

    );

    protected static $adminSelect='SELECT SQL_CALC_FOUND_ROWS beamline.*, shipmentdestination.name AS shipmentdestinationname  
        FROM beamline, shipmentdestination
        WHERE beamline.shipmentdestinationid=shipmentdestination.id
    ';
    protected static $normalSelect='SELECT SQL_CALC_FOUND_ROWS beamline.*, shipmentdestination.name AS shipmentdestinationname
        FROM beamline, shipmentdestination, project
        WHERE beamline.shipmentdestinationid=shipmentdestination.id
            AND beamline.projectid=project.id
    ';
    public static $defaultSortOrder='shipmentdestination.name, beamline.name';

    public static function create($request = array()){
        $sharedProject=project::getByName(project::SHARED);
        $request["projectid"]=$sharedProject['id'];
        return parent::create($request);
    }

    /**
     * @return bool
     * @throws NotFoundException
     */
    public static function canCreate(){
        return session::isShipper() || session::isAdmin();
    }

    /**
     * @param $id
     * @return bool
     * @throws NotFoundException
     */
    public static function canUpdate($id){
        return session::isShipper() || session::isAdmin();
    }

}