<?php 

class userconfig {
	
	protected static $fields=array(
			'name'=>validator::REQUIRED,
    	    'userid'=>validator::REQUIRED,
			'value'=>validator::ANY,
	);
	
	static function get($name){
	    $config=session::get('userConfig');
	    if(isset($config[$name])){
	        return $config[$name];
	    }
	    $userid=session::getUserId();
		$result=database::queryGetOne('SELECT value FROM userconfig WHERE userid=:userid AND name=:name', array(':userid'=>$userid, ':name'=>$name));
		if(!$result){ return null; }
		session::refreshUserConfig();
		return trim($result['value']);
	}

    /**
     * @param $name
     * @param $value
     * @return bool
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function set($name, $value){
	    $userid=session::getUserId();
		database::query('INSERT INTO userconfig (userid,name,value) VALUES(:userid,:name,:value1) ON DUPLICATE KEY UPDATE value=:value2', 
		    array(':name'=>$name, ':userid'=>$userid, ':value1'=>trim($value), ':value2'=>trim($value)));
		session::refreshUserConfig();
		return true;
	}

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ServerException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getAll($request=array()){
	    $userid=session::getUserId();
	    if(!$userid){ return static::$loggedOutConfig; }
	    $config=session::get('userConfig');
	    if(!empty($config)){
	        return $config;
	    }
	    $result=database::queryGetAll('SELECT name,value FROM userconfig WHERE userid=:userid ORDER BY name ', array(':userid'=>$userid));
	    if(!$result){ return array(); }
		$ret=array();
		foreach($result['rows'] as $row){
		    $ret[$row['name']]=$row['value'];
		}
		return $ret;
	}

	private static $loggedOutConfig=array(
	    'skin'=>'default'
	);

    /**
     * @param $id
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	static function getById($id){
		throw new BadRequestException('getById not implemented on userconfig');
	}

    /**
     * @param $name
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	static function getByName($name){
		throw new BadRequestException('getByName not implemented on userconfig');
	}

    /**
     * @param $key
     * @param $value
     * @param array $request
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	static function getByProperty($key,$value,$request=array()){
		throw new BadRequestException('getByProperty not implemented on userconfig');
	}	
	
}