<?php class skin implements crudable {

	protected static $fields=array(
			'name'=>validator::REQUIRED,
			'friendlyname'=>validator::REQUIRED,
    	    'description'=>validator::REQUIRED,
	       //Themes: 'darkicons' or 'lighticons'
    	    'navbaricontheme'=>validator::REQUIRED,
    	    'boxheadericontheme'=>validator::REQUIRED,
    	    'treeheadericontheme'=>validator::REQUIRED,
    	    'bodyicontheme'=>validator::REQUIRED,
	);
	
	protected static $helpTexts=array(
	);

    /**
     * @param $key
     * @param $value
     * @param array $request
     * @return array
     * @throws BadRequestException
     */
	public static function getByProperty($key, $value, $request=array()){
	    if('name'==$key){
	        return static::getByName($value);
	    }
		$keys=array_keys(self::getFieldValidations());
		if(!in_array($key, $keys)){
			throw new BadRequestException('Property '.$key.' not recognised on Skin');
		}
		$sqlStatement='SELECT SQL_CALC_FOUND_ROWS * FROM skin 
				WHERE '.$key.'=:val ';
		$sqlStatement.=database::getOrderClause($request,'skin');
		$sqlStatement.=database::getLimitClause($request);
		$params=array(':val'=>$value);
		return database::queryGetAll($sqlStatement,$params);
	}

	public static function canCreate(){
	    return false;
	}

	public static function canUpdate($id){
	    return false;
	}
	
	public static function getFieldValidations(){
	    return static::$fields;
	}
	
	public static function getFieldHelpTexts(){
	    return static::$helpTexts;
	}
		
	public static function getAll($request=array()){
	    return database::queryGetAll('SELECT * FROM skin ORDER BY friendlyname ',array());
	}
	
	public static function getByName($name){
	    return database::queryGetOne('SELECT * FROM skin WHERE name=:name',array(':name'=>$name));
	}
	
	public static function getById($id){
	    return database::queryGetOne('SELECT * FROM skin WHERE id=:id',array(':id'=>$id));
	}

    /**
     * @param array $request
     * @throws BadRequestException
     */
	public static function create($request=array()){
	    throw new BadRequestException('Cannot create skins');
	}

    /**
     * @param $id
     * @param array $request
     * @throws BadRequestException
     */
	public static function update($id, $request=array()){
	    throw new BadRequestException('Cannot update skins');
	}

    /**
     * @param $id
     * @throws BadRequestException
     */
	public static function delete($id){
	    throw new BadRequestException('Cannot delete skins');
	}

	
}