<?php 
class permission implements crudable {

	protected static $fields=array(
			'projectid'=>validator::INTEGER,
			'usergroupid'=>validator::INTEGER,
			'type'=>validator::PERMISSIONTYPE
	);
	
	protected static $helpTexts=array(
			'projectid'=>'The ID of the project',
			'usergroupid'=>'The ID of the usergroup',
			'type'=>'What permission is being granted - create, read, update or delete'
	);
	
	public static function getFieldValidations(){
		return self::$fields;
	}
	public static function getFieldHelpTexts(){
		return self::$helpTexts;
	}

    /**
     * @param $id
     * @return array
     */
	public static function getById($id){
		$sqlStatement='SELECT * FROM permission WHERE id=:id';
		return database::queryGetOne($sqlStatement, array(':id'=>$id));
	}

    /**
     * @param $name
     * @throws ServerException
     */
	public static function getByName($name){
		throw new ServerException('getByName not implemented on permission');
	}

    /**
     * @param $key
     * @param $value
     * @param array $request
     * @throws ServerException
     */
	public static function getByProperty($key,$value,$request=array()){
		throw new ServerException('getByProperty not implemented on permission');
	}

    /**
     * @param array $request
     * @throws ServerException
     */
	public static function getAll($request=array()){
		throw new ServerException('getAll not implemented on permission');
	}

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create($request=array()){
		$projectId=$request['projectid'];
		$usergroupId=$request['usergroupid'];
		$type=$request['type'];
		$project=project::getbyid($projectId); //throws exception if can't read
		usergroup::getbyid($usergroupId); //throws exception if can't read
		validator::validate($type, $request['type'], self::$fields['type']);
		if(!session::isAdmin() && session::getUserId()!=$project['owner']){
			throw new ForbiddenException('Only administrators and project owners can change groups\' project permissions');
		}
		$params=array(':projectid'=>$projectId, ':usergroupid'=>$usergroupId, ':type'=>$type);
		$sqlStatement='SELECT * FROM permission WHERE projectid=:projectid AND usergroupid=:usergroupid AND type=:type';
		$result=database::queryGetOne($sqlStatement, $params);
		if(!empty($result)){ throw new BadRequestException('Permission already exists'); }
		$sqlStatement='INSERT INTO permission(projectid,usergroupid,type) VALUES(:projectid,:usergroupid,:type)';
		database::query($sqlStatement, $params);
		$lastId=database::getLastInsertId();
		return array("created"=>self::getById($lastId));
	}

    /**
     * @param $id
     * @param array $request
     * @throws ServerException
     */
	public static function update($id, $request=array()){
		throw new ServerException('Update not implemented on permission');
	}

    /**
     * @param $id
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     */
	public static function delete($id){
		$permission=self::getbyid($id);
		$project=project::getbyid($permission['projectid']);
		$usergroup=usergroup::getbyid($permission['usergroupid']);
		if(empty($permission) || empty($project) || empty($usergroup) ){ 
			throw new NotFoundException('Permission does not exist or you cannot read it'); 
		}
		if(!session::isAdmin() && session::getUserId()!=$project['owner']){
			throw new ForbiddenException('Only administrators and project owners can change groups\' project permissions');
		}
		$sqlStatement='DELETE FROM permission WHERE id=:id';
		database::query($sqlStatement, array(':id'=>$id));
		return array("deleted"=>$permission);
	}
	
	public static function canCreate(){
		return true; // and let the actual create sort it out
	}

    /**
     * @param $id
     * @return bool
     */
	public static function canUpdate($id){
		return true; // and let the actual update sort it out
	}
	
}