<?php 

/**
 * Management of the homepage brick layout for a specific user.
 * There is one homepageuserbrick entry per brick on the user's homepage.
 */

class homepageuserbrick {
	
	private static $select='SELECT 
			 homepageuserbrick.id AS id, homepagebrick.id AS homepagebrickid,
			 homepagebrick.name, homepagebrick.title, homepagebrick.version, homepagebrick.description, 
			 homepagebrick.apiurl, homepagebrick.scriptblock, homepagebrick.content,
			 homepagebrick.headertemplates, homepagebrick.rowtemplates, homepagebrick.adminonly,
			 homepagebrick.height, homepagebrick.width, homepageuserbrick.row, homepageuserbrick.col, homepageuserbrick.userid
			FROM homepagebrick, homepageuserbrick 
			WHERE homepagebrick.id=homepageuserbrick.homepagebrickid 
			 ';

    /**
     * @param $id
     * @return array
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function getById($id){
		$sqlStatement=static::$select.' AND homepageuserbrick.id=:id';
		$parameters=array(':id'=>$id);
		$result=database::queryGetOne($sqlStatement, $parameters);
 		$result['rowtemplates']=static::explodeStringToArray($result['rowtemplates']);
 		$result['headertemplates']=static::explodeStringToArray($result['headertemplates']);
		return $result;
	}

    /**
     * @param $name
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getByName($name){
		throw new BadRequestException('homepageuserbrick::getByName not implemented');
	}

    /**
     * @param $name
     * @param $value
     * @param array $request
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getByProperty($name,$value,$request=array()){
		throw new BadRequestException('homepageuserbrick::getByProperty not implemented');
	}

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ServerException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getAll($request=array()){
		$sqlStatement=static::$select.' AND homepageuserbrick.userid=:userid';
		$parameters=array(':userid'=>session::getUserId());
		$result=database::queryGetAll($sqlStatement, $parameters);
		foreach($result['rows'] as &$row){
	 		$row['rowtemplates']=static::explodeStringToArray($row['rowtemplates']);
	 		$row['headertemplates']=static::explodeStringToArray($row['headertemplates']);
		}
		return $result;
	}

    /**
     * @param $id
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function update($id,$request=array()){
		$userBrick=static::getById($id);
		if(!$userBrick || $userBrick['userid']!=session::getUserId()){
			throw new BadRequestException('homeuserpagebrick ID '.$id.' does not exist or is not yours');
		}
		$parts=array();
		foreach($request as $k=>$v){
			if(!in_array($k, array('row','col'))){
				unset($request[$k]);
				continue;
			}
			$v=(int)$v;
			if($v<1 ||$v>3){
				throw new BadRequestException($k.' must be between 1 and 3, was '.$v);
			}
			$parts[]='`'.$k.'`=:'.$k;
		}
		$request['id']=$id;
		$sqlStatement='UPDATE homepageuserbrick SET '.implode(', ',$parts).' WHERE id=:id';
		database::query($sqlStatement, $request);
		return static::getById($id);
	}

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ServerException
     * @throws ForbiddenException
     */
	public static function create($request=array()){
        if(!isset($request['homepagebrickid']) || !isset($request['row']) || !isset($request['col'])){
            throw new BadRequestException('Brick ID, row and col are required');
        }
        $isForCurrentUser=true;
        if(isset($request['userid'])){
            if(session::getUserId()!=$request['userid']){
                $isForCurrentUser=false;
                if(!user::canCreate()) {
                    throw new ForbiddenException('You cannot create homepage bricks for others');
                }
            }
        } else {
            $request['userid']=session::getUserId();
        }
        $result=database::queryGetOne(
            'SELECT * FROM homepageuserbrick WHERE userid=:userid AND homepagebrickid=:homepagebrickid',
            array(
                ':homepagebrickid'=>$request['homepagebrickid'],
                ':userid'=>$request['userid'],
            )
        );
        if(!empty($result)){
            $msg='This user already has that brick on their homepage.';
            if($isForCurrentUser){
                $msg='You already have that brick on your homepage.';
            }
            throw new BadRequestException($msg);
        }

		$sqlStatement='INSERT INTO homepageuserbrick(`homepagebrickid`, `userid`, `row`, `col`) 
				VALUES(:homepagebrickid, :userid, :row, :col)';
		$parameters=array(
				':homepagebrickid'=>$request['homepagebrickid'],
				':userid'=>$request['userid'],
				':row'=>$request['row'],
				':col'=>$request['col']
		);
		database::query($sqlStatement, $parameters);
		$newId=database::getLastInsertId();
		return array('type'=>'homepageuserbrick', 'created'=>self::getById($newId));
	}

    /**
     * @param $id
     * @return array
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function delete($id){
		$userBrick=static::getById($id);
		if(!$userBrick || $userBrick['userid']!=session::getUserId()){
			throw new BadRequestException('homepageuserbrick ID '.$id.' does not exist or is not yours');
		}
		$sqlStatement='DELETE FROM homepageuserbrick WHERE id=:id AND userid=:userid';
		$parameters=array(
				':id'=>$id,
				':userid'=>session::getUserId(),
		);
		database::query($sqlStatement, $parameters);
		return array('deleted'=>$id);
	}
	
	private static function explodeStringToArray($str){
// 		$str=trim($str,"'[]");
// 		$str=explode("','",$str);
		return $str;
	}
	
}