<?php 

/**
 * This class is used for management of the homepage bricks that are available to users.
 * New bricks can be added and existing ones removed.
 */

class homepagebrick {
	
	private static $adminSelect='SELECT SQL_CALC_FOUND_ROWS * FROM homepagebrick WHERE 1=1 ';
	private static $normalSelect='SELECT SQL_CALC_FOUND_ROWS * FROM homepagebrick WHERE adminonly=false ';
	private static function getSelect(){
		if(session::isAdmin()){ return static::$adminSelect; }
		return static::$normalSelect;
	}

    /**
     * @param $id
     * @return array
     */
	public static function getById($id){
		$sqlStatement=static::getSelect().' AND id=:id';
		$parameters=array(':id'=>$id);
        return database::queryGetOne($sqlStatement, $parameters);
	}

    /**
     * @param $name
     * @return array
     */
	public static function getByName($name){
	    $sqlStatement=static::getSelect().' AND name=:name';
	    $parameters=array(':name'=>$name);
        return database::queryGetOne($sqlStatement, $parameters);
	}

    /**
     * @param $name
     * @param $value
     * @param array $request
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getByProperty($name,$value,$request=array()){
		throw new BadRequestException('homepagebrick::getByProperty not implemented');
	}

    /**
     * @param array $request
     * @return array
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getAll($request=array()){
		$sqlStatement=static::getSelect();
		$parameters=array();
		$result=database::queryGetAll($sqlStatement, $parameters);
		foreach($result['rows'] as &$row){
			$row['rowtemplates']=static::explodeStringToArray($row['rowtemplates']);
			$row['headertemplates']=static::explodeStringToArray($row['headertemplates']);
		}
		return $result;
	}

    /**
     * @param $id
     * @param array $request
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function update($id,$request=array()){
		throw new BadRequestException('homepagebrick::update not implemented');
	}

    /**
     * @param $str
     * @return array|string
     */
	private static function explodeStringToArray($str){
		$str=trim($str,"'[]");
		$str=explode("','",$str);
		return $str;
	}

    /**
     *
     * @noinspection SqlInsertValues
     */
	public static function parseBrickFiles(){
	    $dir=rtrim($_SERVER['DOCUMENT_ROOT'],'/').'/client/bricks';
	    $files=scandir($dir);
	    foreach($files as $f){
	        if('.'==$f || '..'==$f){ continue; }
	        if('parser.php'==$f){ continue; }
	        $brick=array(
	            'name'=>'',
	            'title'=>'',
	            'height'=>1,
	            'width'=>1,
	            'url'=>'',
	            'headerTemplates'=>'',
	            'rowTemplates'=>'',
	            'handler'=>'',
	            'content'=>'',
	            'admin_only'=>'no'
	        );
	        $lines=file($dir.'/'.$f);
	        foreach($lines as $line){
	            if(substr($line,0,2)=='--'){
	                array_shift($lines);
	                break;
	            }
	            $line=trim($line);
	            $parts=explode('=',$line,2);
	            if(count($parts)!=2){
	                die('invalid line: '.$line);
	            }
	            $brick[$parts[0]]=$parts[1];
	            array_shift($lines);
	        }
	        $remainder=implode(PHP_EOL,$lines);
	        if(empty($brick['url'])){
	            $brick['content']=$remainder;
	        } else {
	            $brick['handler']=$remainder;
	        }
	        
	        $colsToFields=array(
	            //file=>SQL
	            'name'=>'name',
	            'title'=>'title',
	            'description'=>'description',
	            'version'=>'version',
	            'height'=>'height',
	            'width'=>'width',
	            'url'=>'apiurl',
	            'headerTemplates'=>'headertemplates',
	            'rowTemplates'=>'rowtemplates',
	            'admin_only'=>'adminonly',
	            'handler'=>'scriptblock',
	            'content'=>'content',
	        );
	        
	        if(empty($brick['name'])){ die("Brick name cannot be empty"); }
	        if(empty($brick['title'])){ die("Brick title cannot be empty"); }
	        
	        $brick['admin_only']=strtolower($brick['admin_only']);
	        if("yes"===$brick['admin_only'] || 'true'===$brick['admin_only'] || '1'===$brick['admin_only']){
	            $brick['admin_only']=true;
	        } else {
	            $brick['admin_only']=false;
	        }
	        
	        $result=database::queryGetOne('SELECT * FROM homepagebrick WHERE name=:name', array(':name'=>$brick['name']));
	        if($result){
	            //update
	            $parts=array();
	            $params=array();
	            foreach($brick as $k=>$v){
	                if(empty($v) && $k!='handler' && $k!='admin_only'){ $v=''; }
	                $parts[]=$colsToFields[$k].'=:'.$k;
	                $params[':'.$k]=$v;
	            }
                $sql='UPDATE homepagebrick SET '.implode(', ',$parts).' WHERE name=:name2';
	            $params[':name2']=$brick['name'];
                database::query($sql, $params);
	        } else {
	            //insert new
	            $keys=array();
	            $values=array();
	            $params=array();
	            foreach($brick as $k=>$v){
	                if(empty($v)){ continue; }
	                $keys[]=$colsToFields[$k];
	                $values[]=':'.$k;
	                $params[':'.$k]=$v;
	            }
	            $sql='INSERT INTO homepagebrick ('.implode(', ',$keys).') VALUES ('.implode(', ',$values).')';
                database::query($sql, $params);
	        }
	    }
	}
	
}