<?php class diskusage implements crudable {

    /**
     * @param array $request
     * @return array|mixed
     * @throws ServerException
     */
	public static function getAll($request=array()){ 
		if (strtoupper(substr(PHP_OS, 0, 3)) !== 'LIN') {
			throw new ServerException('Disk usage information is not available because the server is not running Linux.');
		}
		
		$cache = 'filesystem';
		if(!caching::has($cache)){
		    $info=self::getDiskUsage();
    		caching::setContent($cache, $info, '+12 hours');
		}else{
		    $info=caching::getContent($cache);
		}
		return $info;
	}

    /**
     * @throws BadRequestException
     */
	public static function getFieldValidations(){ throw new BadRequestException('Not implemented'); }

    /**
     * @throws BadRequestException
     */
	public static function getFieldHelpTexts(){ throw new BadRequestException('Not implemented'); }

    /**
     * @param $id
     * @throws BadRequestException
     */
	public static function getById($id){ throw new BadRequestException('Not implemented'); }

    /**
     * @param $name
     * @throws BadRequestException
     */
	public static function getByName($name){ throw new BadRequestException('Not implemented'); }

    /**
     * @param $key
     * @param $value
     * @param array $request
     * @throws BadRequestException
     */
	public static function getByProperty($key,$value,$request=array()){ throw new BadRequestException('Not implemented'); }

    /**
     * @param array $request
     * @throws BadRequestException
     */
	public static function create($request=array()){ throw new BadRequestException('Not implemented'); }

    /**
     * @param $id
     * @param array $request
     * @throws BadRequestException
     */
	public static function update($id, $request=array()){ throw new BadRequestException('Not implemented'); }

    /**
     * @param $id
     * @throws BadRequestException
     */
	public static function delete($id){ throw new BadRequestException('Not implemented'); }

    /**
     * @throws BadRequestException
     */
	public static function canCreate(){ throw new BadRequestException('Not implemented'); }

    /**
     * @param $id
     * @throws BadRequestException
     */
	public static function canUpdate($id){ throw new BadRequestException('Not implemented'); }

    /**
     * @return array
     * @throws ServerException
     */
	private static function getDiskUsage(){
	    $result=shell_exec('df -h');
	    //Expected output format
	    // 		$result='Filesystem                         Size  Used Avail Use% Mounted on
	    // 		udev                               2.0G  4.0K  2.0G   1% /dev
	    // 		tmpfs                              392M  628K  392M   1% /run
	    // 		/dev/dm-0                          143G  4.9G  131G   4% /
	    // 		none                               4.0K     0  4.0K   0% /sys/fs/cgroup
	    // 		none                               5.0M     0  5.0M   0% /run/lock
	    // 		none                               2.0G     0  2.0G   0% /run/shm
	    // 		none                               100M     0  100M   0% /run/user
	    // 		/dev/sdb1                          1.8T  589G  1.2T  33% /icebearstore
	    // 		//130.231.188.9/RockMakerStorage   1.9T  1.4T  452G  76% /RockMakerStorage
	    // 		//130.231.188.9/RockMakerStorage2  2.8T  2.6T  223G  93% /RockMakerStorage2
	    // 		/dev/sda1                          236M   40M  184M  18% /boot';
	    if(0!==strpos($result,'Filesystem')){
	        throw new ServerException('Disk usage information is not available. Either it was not in an expected format, or there was an error.');
	    }
	    
	    $result=explode("\n", $result);
	    array_shift($result); //Lose the header
	    $disks=array();
	    foreach($result as $disk){
	        $disk=trim($disk);
	        if(''==$disk){ continue; }
	        $disk=preg_split('/\s+/', $disk);
	        
	        if(count($disk)!==6){
	            throw new ServerException('Disk usage information is not available. It was not in an expected format.');
	        }
	        
	        //Not interested if below 100GB
	        $total=$disk[1];
	        if(false!==stripos($total,'K') || false!==stripos($total,'M') ||
	            (false!==stripos($total,'G') && (int)$total<100) ){ continue; }
	            
	            //$disk=implode('|', $disk);
	            
	            $disks[]=array(
	                'mountpoint'=>$disk[5],
	                'filesystem'=>$disk[0],
	                'size'=>$disk[1].'B',
	                'used'=>$disk[2].'B',
	                'free'=>$disk[3].'B',
	                'percent'=>(int)$disk[4],
	            );
	    }
        return array(
            'total'=>count($disks),
            'rows'=>$disks
        );
	}
	
	
}